/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUICover;
import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.gui.widgets.GT_GuiIconCheckButton;
import gregtech.api.gui.widgets.GT_GuiIntegerTextBox;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.net.GT_Packet_TileEntityCoverNew;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_LiquidMeter
extends GT_CoverBehaviorBase<LiquidMeterData> {
    public GT_Cover_LiquidMeter() {
        super(LiquidMeterData.class);
    }

    @Override
    public LiquidMeterData createDataObject(int aLegacyData) {
        return new LiquidMeterData(aLegacyData == 0, 0);
    }

    @Override
    public LiquidMeterData createDataObject() {
        return new LiquidMeterData();
    }

    @Override
    protected boolean isRedstoneSensitiveImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        return false;
    }

    @Override
    protected LiquidMeterData doCoverThingsImpl(byte aSide, byte aInputRedstone, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IFluidHandler) {
            FluidTankInfo[] tTanks = ((IFluidHandler)aTileEntity).getTankInfo(ForgeDirection.UNKNOWN);
            long tMax = 0L;
            long tUsed = 0L;
            if (tTanks != null) {
                for (FluidTankInfo tTank : tTanks) {
                    if (tTank == null) continue;
                    tMax += (long)tTank.capacity;
                    FluidStack tLiquid = tTank.fluid;
                    if (tLiquid == null) continue;
                    tUsed += (long)tLiquid.amount;
                }
            }
            long redstoneSignal = tUsed == 0L ? 0L : (tUsed >= tMax ? 15L : 1L + 14L * tUsed / tMax);
            if (aCoverVariable.inverted) {
                redstoneSignal = 15L - redstoneSignal;
            }
            if (aCoverVariable.threshold > 0) {
                if (aCoverVariable.inverted && tUsed >= (long)aCoverVariable.threshold) {
                    redstoneSignal = 0L;
                } else if (!aCoverVariable.inverted && tUsed < (long)aCoverVariable.threshold) {
                    redstoneSignal = 0L;
                }
            }
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)redstoneSignal);
        } else {
            aTileEntity.setOutputRedstoneSignal(aSide, (byte)0);
        }
        return aCoverVariable;
    }

    @Override
    protected LiquidMeterData onCoverScrewdriverClickImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (aCoverVariable.inverted) {
            aCoverVariable.inverted = false;
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("055", "Normal"));
        } else {
            aCoverVariable.inverted = true;
            GT_Utility.sendChatToPlayer(aPlayer, this.trans("054", "Inverted"));
        }
        return aCoverVariable;
    }

    @Override
    protected boolean letsEnergyInImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsEnergyOutImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidInImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsFluidOutImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsInImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean letsItemsOutImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, int aSlot, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected int getTickRateImpl(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
        return 5;
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public Object getClientGUIImpl(byte aSide, int aCoverID, LiquidMeterData coverData, ICoverable aTileEntity, EntityPlayer aPlayer, World aWorld) {
        return new GUI(aSide, aCoverID, coverData, aTileEntity);
    }

    private class GUI
    extends GT_GUICover {
        private final byte side;
        private final int coverID;
        private final GT_GuiIconCheckButton invertedButton;
        private final GT_GuiIntegerTextBox thresholdSlot;
        private final LiquidMeterData coverVariable;
        private final int maxCapacity;
        private static final int startX = 10;
        private static final int startY = 25;
        private static final int spaceX = 18;
        private static final int spaceY = 18;
        private final String INVERTED;
        private final String NORMAL;

        public GUI(byte aSide, int aCoverID, LiquidMeterData aCoverVariable, ICoverable aTileEntity) {
            super(aTileEntity, 176, 107, GT_Utility.intToStack(aCoverID));
            this.INVERTED = GT_Cover_LiquidMeter.this.trans("INVERTED", "Inverted");
            this.NORMAL = GT_Cover_LiquidMeter.this.trans("NORMAL", "Normal");
            this.side = aSide;
            this.coverID = aCoverID;
            this.coverVariable = aCoverVariable;
            this.invertedButton = new GT_GuiIconCheckButton(this, 0, 10, 25, GT_GuiIcon.REDSTONE_ON, GT_GuiIcon.REDSTONE_OFF, this.INVERTED, this.NORMAL);
            this.thresholdSlot = new GT_GuiIntegerTextBox(this, 2, 10, 45, 77, 12);
            if (this.tile instanceof IFluidHandler) {
                FluidTankInfo[] tanks = ((IFluidHandler)this.tile).getTankInfo(ForgeDirection.UNKNOWN);
                this.maxCapacity = Arrays.stream(tanks).mapToInt(tank -> tank.capacity).sum();
            } else {
                this.maxCapacity = -1;
            }
        }

        @Override
        public void drawExtras(int mouseX, int mouseY, float parTicks) {
            super.drawExtras(mouseX, mouseY, parTicks);
            this.field_146289_q.func_78276_b(this.coverVariable.inverted ? this.INVERTED : this.NORMAL, 28, 29, -11184811);
            this.getFontRenderer().func_78276_b(GT_Cover_LiquidMeter.this.trans("222", "Fluid threshold"), 90, 47, -11184811);
        }

        @Override
        protected void onInitGui(int guiLeft, int guiTop, int gui_width, int gui_height) {
            this.update();
            this.thresholdSlot.func_146195_b(true);
        }

        @Override
        public void buttonClicked(GuiButton btn) {
            this.coverVariable.inverted = !this.coverVariable.inverted;
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void onMouseWheel(int x, int y, int delta) {
            if (this.thresholdSlot.func_146206_l()) {
                int val = this.parseTextBox(this.thresholdSlot);
                int step = 1000;
                if (GUI.func_146272_n()) {
                    step *= 100;
                }
                if (GUI.func_146271_m()) {
                    step /= 10;
                }
                val += step * Integer.signum(delta);
                int upperBound = this.maxCapacity > 0 ? this.maxCapacity : Integer.MAX_VALUE;
                val = GT_Utility.clamp(val, 0, upperBound);
                this.thresholdSlot.func_146180_a(Integer.toString(val));
            }
        }

        @Override
        public void applyTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.thresholdSlot) {
                this.coverVariable.threshold = this.parseTextBox(this.thresholdSlot);
            }
            GT_Values.NW.sendToServer(new GT_Packet_TileEntityCoverNew(this.side, this.coverID, this.coverVariable, this.tile));
            this.update();
        }

        @Override
        public void resetTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.thresholdSlot) {
                this.thresholdSlot.func_146180_a(Integer.toString(this.coverVariable.threshold));
            }
        }

        private void update() {
            this.invertedButton.setChecked(this.coverVariable.inverted);
            this.resetTextBox(this.thresholdSlot);
        }

        private int parseTextBox(GT_GuiIntegerTextBox box) {
            if (box == this.thresholdSlot) {
                int val;
                String text = box.func_146179_b();
                if (text == null) {
                    return 0;
                }
                try {
                    val = Integer.parseInt(text.trim());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
                int upperBound = this.maxCapacity > 0 ? this.maxCapacity : Integer.MAX_VALUE;
                return GT_Utility.clamp(val, 0, upperBound);
            }
            throw new UnsupportedOperationException("Unknown text box: " + box);
        }
    }

    public static class LiquidMeterData
    implements ISerializableObject {
        private boolean inverted;
        private int threshold;

        public LiquidMeterData() {
            this.inverted = false;
            this.threshold = 0;
        }

        public LiquidMeterData(boolean inverted, int threshold) {
            this.inverted = inverted;
            this.threshold = threshold;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new LiquidMeterData(this.inverted, this.threshold);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("invert", this.inverted);
            tag.func_74768_a("threshold", this.threshold);
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            aBuf.writeBoolean(this.inverted);
            aBuf.writeInt(this.threshold);
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.inverted = tag.func_74767_n("invert");
            this.threshold = tag.func_74762_e("threshold");
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            this.inverted = aBuf.readBoolean();
            this.threshold = aBuf.readInt();
            return this;
        }
    }
}

