/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.common;

import com.gtnewhorizons.gravisuiteneo.common.Achievements;
import com.gtnewhorizons.gravisuiteneo.common.DamageSources;
import com.gtnewhorizons.gravisuiteneo.mixins.MixinEntityPlasmaBall;
import gravisuite.BlockRelocatorPortal;
import gravisuite.EntityPlasmaBall;
import gravisuite.GraviSuite;
import gravisuite.Helpers;
import gravisuite.ItemRelocator;
import gravisuite.ServerProxy;
import gravisuite.TileEntityRelocatorPortal;
import ic2.api.item.ElectricItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityPlasmaBallMKII
extends EntityPlasmaBall {
    public static final float PLASMA_DAMAGE = 100.0f;
    private float charge = 0.0f;
    private int finalTicksForDestruction = -1;

    public EntityPlasmaBallMKII(World world, EntityPlasmaBall origin, float charge) {
        this(world, ((MixinEntityPlasmaBall)origin).getOwnerEntity(), null, 3);
        this.charge = charge;
        this.finalTicksForDestruction = this.field_70173_aa + 10;
        ((MixinEntityPlasmaBall)((Object)this)).setMaxRange(512.0);
        ((MixinEntityPlasmaBall)((Object)this)).setSpeedPerTick(1.0);
        ((MixinEntityPlasmaBall)((Object)this)).setActionType((byte)3);
        this.func_70016_h(0.0, 0.0, 0.0);
        this.field_70165_t = origin.field_70165_t;
        this.field_70163_u = origin.field_70163_u;
        this.field_70161_v = origin.field_70161_v;
    }

    public EntityPlasmaBallMKII(World world, EntityLivingBase entityLiving, float charge, byte entityType) {
        this(world, entityLiving, null, entityType);
        this.charge = charge;
        this.field_70180_af.func_75692_b(29, (Object)Float.valueOf(this.charge));
        ((MixinEntityPlasmaBall)((Object)this)).setMaxRange(512.0);
        ((MixinEntityPlasmaBall)((Object)this)).setSpeedPerTick(1.33);
        if (entityType == 2) {
            this.changeEntitySpeed(3.0f);
        }
    }

    private void changeEntitySpeed(float newSpeed) {
        double magnitude = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        this.field_70159_w /= magnitude;
        this.field_70181_x /= magnitude;
        this.field_70179_y /= magnitude;
        this.field_70159_w *= (double)newSpeed;
        this.field_70181_x *= (double)newSpeed;
        this.field_70179_y *= (double)newSpeed;
        ((MixinEntityPlasmaBall)((Object)this)).setSpeedPerTick(((MixinEntityPlasmaBall)((Object)this)).getSpeedPerTick() * (double)newSpeed);
    }

    public EntityPlasmaBallMKII(World world, EntityLivingBase entityLiving, ItemRelocator.TeleportPoint tpPoint, byte entityType) {
        super(world, entityLiving, tpPoint, entityType);
    }

    public EntityPlasmaBallMKII(World world) {
        super(world);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(29, (Object)Float.valueOf(this.charge));
        this.field_70180_af.func_82708_h(29);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.finalTicksForDestruction > -1 && this.field_70173_aa >= this.finalTicksForDestruction) {
            this.func_70106_y();
        }
    }

    public void func_70109_d(NBTTagCompound nbt) {
        super.func_70109_d(nbt);
        nbt.func_74776_a("charge", this.charge);
    }

    public void func_70020_e(NBTTagCompound nbt) {
        super.func_70020_e(nbt);
        this.charge = nbt.func_74760_g("charge");
    }

    public float getCharge() {
        return this.field_70180_af.func_111145_d(29);
    }

    public static double getImpactRadius(float plasmaEfficiency) {
        return 6.0 * (double)plasmaEfficiency;
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        if (this.finalTicksForDestruction != -1) {
            return;
        }
        byte actionType = ((MixinEntityPlasmaBall)((Object)this)).getActionType();
        if (actionType == 2) {
            double tImpactRadius = MathHelper.func_151237_a((double)EntityPlasmaBallMKII.getImpactRadius(this.charge), (double)1.0, (double)15.0);
            boolean tTerrainDamage = this.charge >= 2.0f;
            EntityPlayer ownerEntity = (EntityPlayer)((MixinEntityPlasmaBall)((Object)this)).getOwnerEntity();
            List e = mop.field_72308_g != null ? this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(mop.field_72308_g.field_70165_t - tImpactRadius), (double)(mop.field_72308_g.field_70163_u - tImpactRadius), (double)(mop.field_72308_g.field_70161_v - tImpactRadius), (double)(mop.field_72308_g.field_70165_t + tImpactRadius), (double)(mop.field_72308_g.field_70163_u + tImpactRadius), (double)(mop.field_72308_g.field_70161_v + tImpactRadius))) : this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)((double)mop.field_72311_b - tImpactRadius), (double)((double)mop.field_72312_c - tImpactRadius), (double)((double)mop.field_72309_d - tImpactRadius), (double)((double)mop.field_72311_b + tImpactRadius), (double)((double)mop.field_72312_c + tImpactRadius), (double)((double)mop.field_72309_d + tImpactRadius)));
            float tFinalDamage = this.charge * 100.0f;
            if (tTerrainDamage) {
                this.field_70170_p.func_72876_a(null, (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, this.charge, true);
            }
            long tDamageDealt = 0L;
            long tEntitiesHitDeadly = 0L;
            for (EntityLivingBase el : e) {
                if (el.func_110143_aJ() < tFinalDamage) {
                    ++tEntitiesHitDeadly;
                }
                el.func_70097_a(DamageSources.causePlayerPlazmaDamage(ownerEntity), tFinalDamage);
                tDamageDealt = (long)((float)tDamageDealt + tFinalDamage);
            }
            if (tDamageDealt > 9000L) {
                ownerEntity.func_71029_a((StatBase)Achievements.OVER9000);
            }
            if (tEntitiesHitDeadly > 100L) {
                ownerEntity.func_71029_a((StatBase)Achievements.ULTRAKILL);
            }
            EntityPlasmaBallMKII explosionBall = new EntityPlasmaBallMKII(this.field_70170_p, this, this.charge);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72908_a((double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, "gravisuiteneo:plasmaImpact", 1.25f, 1.0f);
                this.field_70170_p.func_72838_d((Entity)explosionBall);
                this.func_70106_y();
            }
            return;
        }
        if (mop.field_72308_g != null) {
            if (actionType == 0) {
                ItemRelocator.TeleportPoint targetTpPoint = ((MixinEntityPlasmaBall)((Object)this)).getTargetTpPoint();
                Entity tTerrainDamage = mop.field_72308_g;
                if (tTerrainDamage instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)tTerrainDamage;
                    ItemStack itemstack = player.field_71071_by.field_70460_b[2];
                    if (itemstack != null && itemstack.func_77973_b() == GraviSuite.graviChestPlate) {
                        double dischargeArmorValue = ((MixinEntityPlasmaBall)((Object)this)).getDischargeArmorValue();
                        if (ElectricItem.manager.getCharge(itemstack) < dischargeArmorValue) {
                            Helpers.teleportEntity((Entity)mop.field_72308_g, (ItemRelocator.TeleportPoint)targetTpPoint);
                        } else if (GraviSuite.isSimulating()) {
                            ServerProxy.sendPlayerMessage((EntityPlayer)player, (String)(((MixinEntityPlasmaBall)((Object)this)).getOwnerEntity().func_70005_c_() + " " + StatCollector.func_74838_a((String)"message.relocator.text.messageToTarget")));
                            ElectricItem.manager.discharge(itemstack, dischargeArmorValue, Integer.MAX_VALUE, true, false, false);
                        }
                    } else {
                        Helpers.teleportEntity((Entity)mop.field_72308_g, (ItemRelocator.TeleportPoint)targetTpPoint);
                    }
                } else {
                    Helpers.teleportEntity((Entity)mop.field_72308_g, (ItemRelocator.TeleportPoint)targetTpPoint);
                }
            }
        } else if (actionType == 1) {
            int curPosX = mop.field_72311_b;
            int curPosY = mop.field_72312_c;
            int curPosZ = mop.field_72309_d;
            switch (mop.field_72310_e) {
                case 0: {
                    --curPosY;
                    break;
                }
                case 1: {
                    ++curPosY;
                    break;
                }
                case 2: {
                    --curPosZ;
                    break;
                }
                case 3: {
                    ++curPosZ;
                    break;
                }
                case 4: {
                    --curPosX;
                    break;
                }
                case 5: {
                    ++curPosX;
                }
            }
            if (GraviSuite.isSimulating()) {
                try {
                    TileEntity currentTileEntity;
                    TileEntity tileEntity;
                    this.field_70170_p.func_147468_f(curPosX, curPosY, curPosZ);
                    this.field_70170_p.func_147449_b(curPosX, curPosY, curPosZ, GraviSuite.blockRelocatorPortal);
                    this.field_70170_p.func_147471_g(curPosX, curPosY, curPosZ);
                    MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
                    ItemRelocator.TeleportPoint targetTpPoint = ((MixinEntityPlasmaBall)((Object)this)).getTargetTpPoint();
                    WorldServer targetServer = minecraftserver.func_71218_a(targetTpPoint.dimID);
                    targetServer.field_73059_b.func_73158_c((int)targetTpPoint.x >> 4, (int)targetTpPoint.z >> 4);
                    Block block = targetServer.func_147439_a((int)targetTpPoint.x, (int)targetTpPoint.y, (int)targetTpPoint.z);
                    if (!(block instanceof BlockRelocatorPortal)) {
                        targetServer.func_147449_b((int)targetTpPoint.x, (int)targetTpPoint.y, (int)targetTpPoint.z, GraviSuite.blockRelocatorPortal);
                        targetServer.func_147471_g((int)targetTpPoint.x, (int)targetTpPoint.y, (int)targetTpPoint.z);
                    }
                    if ((tileEntity = targetServer.func_147438_o((int)targetTpPoint.x, (int)targetTpPoint.y, (int)targetTpPoint.z)) instanceof TileEntityRelocatorPortal) {
                        TileEntityRelocatorPortal portal = (TileEntityRelocatorPortal)tileEntity;
                        ItemRelocator.TeleportPoint tmpPoint = new ItemRelocator.TeleportPoint();
                        tmpPoint.dimID = this.field_70170_p.field_73011_w.field_76574_g;
                        tmpPoint.x = curPosX;
                        tmpPoint.y = curPosY;
                        tmpPoint.z = curPosZ;
                        portal.setParentPortal(tmpPoint);
                    }
                    if ((currentTileEntity = this.field_70170_p.func_147438_o(curPosX, curPosY, curPosZ)) instanceof TileEntityRelocatorPortal) {
                        TileEntityRelocatorPortal currentPortal = (TileEntityRelocatorPortal)currentTileEntity;
                        currentPortal.setParentPortal(targetTpPoint);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

