/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.gravisuiteneo.items;

import com.gtnewhorizons.gravisuiteneo.GraviSuiteNeoRegistry;
import com.gtnewhorizons.gravisuiteneo.client.ICustomItemBars;
import com.gtnewhorizons.gravisuiteneo.common.Properties;
import com.gtnewhorizons.gravisuiteneo.util.FluidHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravisuite.IItemTickListener;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemPlasmaCell
extends Item
implements IElectricItem,
IItemTickListener,
ICustomItemBars,
IFluidContainerItem {
    private static final String NBT_FLUID_TAG = "Fluid";
    private static final int CAPACITY = 64000;
    private final int maxCharge;
    private final int transferLimit;
    private final int tier;

    public ItemPlasmaCell() {
        this.maxCharge = Properties.ElectricPresets.PlasmaCell.maxCharge;
        this.transferLimit = Properties.ElectricPresets.PlasmaCell.transferLimit;
        this.func_77637_a(GraviSuiteNeoRegistry.graviCreativeTab);
        this.tier = Properties.ElectricPresets.PlasmaCell.tier;
        this.func_77656_e(27);
        this.func_77625_d(1);
        this.func_77655_b("PlasmaCell");
        this.func_111206_d("gravisuiteneo:itemPlasmaCell");
    }

    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound tTagCompound = ItemPlasmaCell.getOrCreateNbtData(container);
        NBTTagCompound tFluidTag = tTagCompound.func_74775_l(NBT_FLUID_TAG);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tFluidTag);
    }

    public static NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound ret = itemStack.func_77978_p();
        if (ret == null) {
            ret = new NBTTagCompound();
            itemStack.func_77982_d(ret);
        }
        return ret;
    }

    public int getCapacity(ItemStack container) {
        return 64000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (GraviSuiteNeoRegistry.getPlasmaEfficiency(resource) < 1.0f) {
            return 0;
        }
        if (container.field_77994_a != 1) {
            return 0;
        }
        if (resource == null) {
            return 0;
        }
        NBTTagCompound tagCompound = ItemPlasmaCell.getOrCreateNbtData(container);
        NBTTagCompound fluidTag = tagCompound.func_74775_l(NBT_FLUID_TAG);
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            fs = new FluidStack(resource, 0);
        }
        if (!fs.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(64000 - fs.amount, resource.amount);
        if (doFill && amount > 0) {
            fs.amount += amount;
            fs.writeToNBT(fluidTag);
            tagCompound.func_74782_a(NBT_FLUID_TAG, (NBTBase)fluidTag);
        }
        return amount;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77994_a != 1) {
            return null;
        }
        NBTTagCompound tagCompound = ItemPlasmaCell.getOrCreateNbtData(container);
        NBTTagCompound fluidTag = tagCompound.func_74775_l(NBT_FLUID_TAG);
        FluidStack fs = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (fs == null) {
            return null;
        }
        maxDrain = Math.min(fs.amount, maxDrain);
        if (doDrain) {
            fs.amount -= maxDrain;
            if (fs.amount <= 0) {
                tagCompound.func_82580_o(NBT_FLUID_TAG);
            } else {
                fs.writeToNBT(fluidTag);
                tagCompound.func_74782_a(NBT_FLUID_TAG, (NBTBase)fluidTag);
            }
        }
        return new FluidStack(fs, maxDrain);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advancedTooltip) {
        tooltip.addAll(ItemPlasmaCell.getToolTipInfo(stack));
    }

    public static List<String> getToolTipInfo(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        FluidStack fluid = ((IFluidContainerItem)GraviSuiteNeoRegistry.itemPlasmaCell).getFluid(stack);
        if (fluid != null) {
            list.add(StatCollector.func_74837_a((String)"message.plasmaCell.contains", (Object[])new Object[]{FluidHelper.getFluidName(fluid), fluid.amount}));
            list.add(StatCollector.func_74837_a((String)"message.plasmaCell.efficiency", (Object[])new Object[]{Float.valueOf(GraviSuiteNeoRegistry.getPlasmaEfficiency(fluid))}));
        } else {
            list.add(StatCollector.func_74838_a((String)"message.plasmaCell.nothing"));
            list.add(StatCollector.func_74837_a((String)"message.plasmaCell.efficiency", (Object[])new Object[]{Float.valueOf(0.0f)}));
        }
        return list;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.uncommon;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack itemStack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean onTick(EntityPlayer player, ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List subItems) {
        ItemStack stack = new ItemStack((Item)this, 1);
        ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
        ItemStack fullStack = new ItemStack((Item)this, 1, this.func_77612_l());
        subItems.add(fullStack);
        for (Fluid fluid : GraviSuiteNeoRegistry.getRegisteredFuels()) {
            ItemStack tempStack = new ItemStack((Item)this, 1, this.func_77612_l());
            ElectricItem.manager.charge(tempStack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            this.fill(tempStack, new FluidStack(fluid, 64000), true);
            subItems.add(tempStack);
        }
    }

    @Override
    public int getNumBars(ItemStack itemStack) {
        return 2;
    }

    @Override
    public Color getColorForMinValue(ItemStack itemStack, int barIndex) {
        return Color.RED;
    }

    @Override
    public Color getColorForMaxValue(ItemStack itemStack, int barIndex) {
        if (barIndex == 0) {
            return Color.GREEN;
        }
        return Color.YELLOW;
    }

    @Override
    public double getMaxValue(ItemStack itemStack, int barIndex) {
        if (barIndex == 0) {
            return this.maxCharge;
        }
        return 64000.0;
    }

    @Override
    public double getValueForBar(ItemStack itemStack, int barIndex) {
        if (barIndex == 0) {
            return ElectricItem.manager.getCharge(itemStack);
        }
        FluidStack tFluid = this.getFluid(itemStack);
        if (tFluid != null) {
            return tFluid.amount;
        }
        return 0.0;
    }

    @Override
    public ICustomItemBars.BarAlignment getBarAlignment() {
        return ICustomItemBars.BarAlignment.BOTTOM;
    }

    @Override
    public int getBarThickness(ItemStack itemStack, int barIndex) {
        return 1;
    }

    @Override
    public boolean getIsBarInverted(ItemStack itemStack, int barIndex) {
        return true;
    }
}

