/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import makeo.gadomancy.api.ClickBehavior;
import makeo.gadomancy.common.Gadomancy;
import makeo.gadomancy.common.blocks.tiles.SynchronizedTileEntity;
import makeo.gadomancy.common.entities.fake.AdvancedFakePlayer;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.SaveHandler;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.foci.ItemFocusPrimal;
import thaumcraft.common.lib.research.ResearchManager;

public class TileInfusionClaw
extends SynchronizedTileEntity
implements ISidedInventory {
    private static final UUID FAKE_UUID = UUID.fromString("b23c8c3f-d7bd-49b3-970a-8e86728bab82");
    private static final Random RANDOM = new Random();
    private static final ItemWandCasting WAND_ITEM = (ItemWandCasting)ConfigItems.itemWandCasting;
    private static final ItemFocusPrimal WAND_FOCUS = (ItemFocusPrimal)ConfigItems.itemFocusPrimal;
    private static final AspectList MAX_WAND_COST = new AspectList().add(Aspect.WATER, 250).add(Aspect.AIR, 250).add(Aspect.EARTH, 250).add(Aspect.FIRE, 250).add(Aspect.ORDER, 250).add(Aspect.ENTROPY, 250);
    private ItemInWorldManager im;
    private Boolean redstoneState;
    private int count;
    private String player;
    private ItemStack wandStack;
    private boolean isLocked;
    private int cooldown;
    @SideOnly(value=Side.CLIENT)
    public float lastRenderTick;
    @SideOnly(value=Side.CLIENT)
    public float[] animationStates;
    private ArrayList<String> research;

    public TileInfusionClaw() {
        if (Gadomancy.proxy.getSide() == Side.CLIENT) {
            this.animationStates = new float[12];
            EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
            this.lastRenderTick = entity == null ? 0.0f : (float)entity.field_70173_aa;
        }
    }

    public void func_145845_h() {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            if (this.redstoneState == null) {
                this.redstoneState = world.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                if (this.cooldown == 150) {
                    this.performClickBlock();
                }
            }
            if (this.count > 20) {
                this.count = 0;
                if (this.field_145848_d > 0) {
                    world.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                }
            }
            ++this.count;
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("player")) {
            this.player = compound.func_74779_i("player");
        }
        this.wandStack = NBTHelper.getStack(compound, "wandStack");
        this.isLocked = compound.func_74767_n("isLocked");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        if (this.hasOwner()) {
            compound.func_74778_a("player", this.player);
        }
        if (this.wandStack != null) {
            NBTHelper.setStack(compound, "wandStack", this.wandStack);
        }
        compound.func_74757_a("isLocked", this.isLocked);
    }

    private void markForUpdate() {
        this.func_70296_d();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void updateRedstone(boolean state) {
        if (this.redstoneState != null && state && !this.redstoneState.booleanValue()) {
            this.startClickBlock();
        }
        this.redstoneState = state;
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setIsLocked(boolean isLocked) {
        this.isLocked = isLocked;
        if (!this.func_145831_w().field_72995_K) {
            this.markForUpdate();
        }
    }

    public boolean setOwner(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K && this.isValidOwner(player)) {
            this.player = player.func_70005_c_();
            this.markForUpdate();
            return true;
        }
        return false;
    }

    public boolean isValidOwner(EntityPlayer player) {
        return !AdvancedFakePlayer.isFakePlayer(player);
    }

    private void loadResearch(EntityPlayer fakePlayer) {
        boolean online = false;
        for (String username : MinecraftServer.func_71276_C().func_71213_z()) {
            if (!username.equals(this.player)) continue;
            online = true;
            break;
        }
        if (online) {
            this.research = ResearchManager.getResearchForPlayer((String)this.player);
        } else if (this.research == null) {
            Thaumcraft.proxy.getCompletedResearch().put(fakePlayer.func_70005_c_(), new ArrayList());
            IPlayerFileData playerNBTManagerObj = MinecraftServer.func_71276_C().func_71218_a(0).func_72860_G().func_75756_e();
            SaveHandler sh = (SaveHandler)playerNBTManagerObj;
            File dir = (File)ObfuscationReflectionHelper.getPrivateValue(SaveHandler.class, (Object)sh, (String[])new String[]{"playersDirectory", "field_75771_c"});
            File file1 = new File(dir, this.player + ".thaum");
            File file2 = new File(dir, this.player + ".thaumbak");
            ResearchManager.loadPlayerData((EntityPlayer)fakePlayer, (File)file1, (File)file2, (boolean)false);
            this.research = ResearchManager.getResearchForPlayerSafe((String)fakePlayer.func_70005_c_());
        }
        Thaumcraft.proxy.getCompletedResearch().put(fakePlayer.func_70005_c_(), this.research == null ? new ArrayList<String>() : this.research);
    }

    public String getOwner() {
        return this.player;
    }

    public boolean hasOwner() {
        return this.player != null;
    }

    private void startClickBlock() {
        ClickBehavior behavior;
        if (!(this.isRunning() || (behavior = this.getClickBehavior(this.func_145831_w(), this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) == null || behavior.hasVisCost() && !this.hasSufficientVis())) {
            this.startRunning();
        }
    }

    private void performClickBlock() {
        int z;
        int y;
        int x;
        World world = this.func_145831_w();
        ClickBehavior behavior = this.getClickBehavior(world, x = this.field_145851_c, y = this.field_145848_d - 1, z = this.field_145849_e);
        if (behavior != null) {
            if (world == null) {
                try {
                    world = this.func_145831_w();
                }
                catch (NullPointerException e) {
                    Gadomancy.log.error("fatal error, world == null! at InfusionClaw");
                    return;
                }
            }
            AdvancedFakePlayer fakePlayer = new AdvancedFakePlayer((WorldServer)world, FAKE_UUID);
            this.loadResearch((EntityPlayer)fakePlayer);
            if (behavior.hasVisCost()) {
                if (this.hasSufficientVis()) {
                    this.consumeVis((EntityPlayer)fakePlayer);
                } else {
                    return;
                }
            }
            if (this.im == null) {
                this.im = new ItemInWorldManager(world);
            } else {
                this.im.func_73080_a((WorldServer)world);
            }
            if (fakePlayer == null) {
                Gadomancy.log.warn("Infusion Claw was build inside of a protected area! You need to allow FakePlayers here!");
                return;
            }
            fakePlayer.setHeldItem(this.wandStack);
            this.im.func_73078_a((EntityPlayer)fakePlayer, world, this.wandStack, x, y, z, ForgeDirection.UP.ordinal(), 0.5f, 0.5f, 0.5f);
            this.addInstability(behavior);
        }
    }

    private ClickBehavior getClickBehavior(World world, int x, int y, int z) {
        if (y >= 0 && !world.field_72995_K && world instanceof WorldServer && this.hasOwner() && !world.func_147437_c(x, y, z) && this.wandStack != null && this.wandStack.field_77994_a > 0) {
            return RegisteredBlocks.getClawClickBehavior(world, x, y, z);
        }
        return null;
    }

    public boolean isRunning() {
        if (this.func_145831_w().field_72995_K) {
            return this.animationStates[8] + this.animationStates[9] + this.animationStates[11] != 0.0f;
        }
        return this.cooldown > 0;
    }

    private void startRunning() {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketStartAnimation(0, this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 48.0));
        this.cooldown = 440;
    }

    private void addInstability(ClickBehavior behavior) {
        int instability = 23;
        int maxVis = WAND_ITEM.getMaxVis(this.wandStack);
        instability = (int)((double)(instability += maxVis < 100 ? 3 : -2) - Math.floor((float)(maxVis > 300 ? 300 : maxVis) / 300.0f * 10.0f));
        instability -= WAND_ITEM.isStaff(this.wandStack) ? 6 : -1;
        instability = (int)((double)instability + Math.floor(((double)WAND_ITEM.getCap(this.wandStack).getBaseCostModifier() - 0.4) * 3.0));
        instability -= WAND_ITEM.getCap(this.wandStack) == ConfigItems.WAND_CAP_VOID ? 3 : 0;
        behavior.addInstability(instability -= WAND_ITEM.getRod(this.wandStack) == ConfigItems.STAFF_ROD_PRIMAL ? 6 : 0);
    }

    private boolean hasSufficientVis() {
        return this.wandStack != null && this.wandStack.field_77994_a > 0 && WAND_ITEM.consumeAllVis(this.wandStack, null, MAX_WAND_COST, false, false);
    }

    private void consumeVis(EntityPlayer player) {
        WAND_ITEM.consumeAllVis(this.wandStack, player, WAND_FOCUS.getVisCost(this.wandStack), true, false);
        this.markForUpdate();
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return this.wandStack;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.isRunning()) {
            return null;
        }
        if (amount > 0) {
            ItemStack result = this.wandStack.func_77946_l();
            this.wandStack = null;
            this.markForUpdate();
            return result;
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.wandStack = stack;
        this.markForUpdate();
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.isRunning()) {
            return false;
        }
        if (stack.func_77973_b() == WAND_ITEM) {
            return !WAND_ITEM.isSceptre(stack) && WAND_ITEM.getFocus(stack) == null;
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return !this.isRunning() && side > 0 && side < 6;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return (!this.isLocked() || !this.hasSufficientVis()) && this.func_102007_a(slot, stack, side);
    }
}

