/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.api.GadomancyApi;
import makeo.gadomancy.api.golems.AdditionalGolemType;
import makeo.gadomancy.api.golems.cores.AdditionalGolemCore;
import makeo.gadomancy.common.entities.golems.cores.BodyguardGolemCore;
import makeo.gadomancy.common.entities.golems.cores.BreakGolemCore;
import makeo.gadomancy.common.entities.golems.types.SilverwoodGolemType;
import makeo.gadomancy.common.entities.golems.upgrades.GolemUpgrade;
import makeo.gadomancy.common.entities.golems.upgrades.GolemUpgradeRunicShield;

public class RegisteredGolemStuff {
    public static final List<GolemUpgrade> UPGRADES = new ArrayList<GolemUpgrade>();
    public static GolemUpgradeRunicShield upgradeRunicShield;
    public static SilverwoodGolemType typeSilverwood;
    public static AdditionalGolemCore breakCore;
    public static AdditionalGolemCore bodyguardCore;

    private RegisteredGolemStuff() {
    }

    public static void init() {
        typeSilverwood = RegisteredGolemStuff.registerGolemType("SILVERWOOD", new SilverwoodGolemType());
        breakCore = RegisteredGolemStuff.registerGolemCore("breakCore", new BreakGolemCore());
        bodyguardCore = RegisteredGolemStuff.registerGolemCore("bodyguardCore", new BodyguardGolemCore());
        upgradeRunicShield = RegisteredGolemStuff.registerGolemUpgrade(new GolemUpgradeRunicShield());
    }

    private static <T extends AdditionalGolemType> T registerGolemType(String name, T type) {
        GadomancyApi.registerAdditionalGolemType(name, "gadomancy", type);
        return type;
    }

    private static <T extends AdditionalGolemCore> T registerGolemCore(String name, T core) {
        GadomancyApi.registerAdditionalGolemCore(name, core);
        return core;
    }

    private static <T extends GolemUpgrade> T registerGolemUpgrade(T upgrade) {
        UPGRADES.add(upgrade);
        return upgrade;
    }
}

