/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.client.renderers.item.ItemRenderFamiliar;
import makeo.gadomancy.common.data.DataFamiliar;
import makeo.gadomancy.common.network.packets.PacketFamiliarBolt;
import makeo.gadomancy.common.utils.world.fake.FakeWorld;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.fx.bolt.FXLightningBolt;
import thaumcraft.client.renderers.entity.RenderWisp;
import thaumcraft.common.entities.monster.EntityWisp;

public class FamiliarHandlerClient {
    private static EntityWisp ENTITY_WISP;
    private static RenderWisp fallbackRenderer;
    private static Map<String, ExFamiliarData> clientFamiliars;

    @SideOnly(value=Side.CLIENT)
    public static void processBoltPacket(PacketFamiliarBolt pkt) {
        EntityPlayer p = Minecraft.func_71410_x().field_71441_e.func_72924_a(pkt.owner);
        if (p == null || p.func_70068_e((Entity)Minecraft.func_71410_x().field_71439_g) > 1024.0) {
            return;
        }
        ExFamiliarData data = clientFamiliars.get(p.func_70005_c_());
        if (data == null) {
            return;
        }
        PartialEntityFamiliar fam = data.familiar;
        float y = (float)(fam.posY + (double)1.22f);
        if (!Minecraft.func_71410_x().field_71439_g.func_70005_c_().equalsIgnoreCase(pkt.owner)) {
            y += 0.2f;
        }
        FXLightningBolt bolt = new FXLightningBolt((World)Minecraft.func_71410_x().field_71441_e, (double)((float)fam.posX), (double)y, (double)((float)fam.posZ), (double)pkt.targetX, (double)pkt.targetY, (double)pkt.targetZ, Minecraft.func_71410_x().field_71441_e.field_73012_v.nextLong(), 10, 4.0f, 5);
        bolt.defaultFractal();
        bolt.setType(pkt.type);
        bolt.finalizeBolt();
    }

    @SideOnly(value=Side.CLIENT)
    public static void playerRenderEvent(EntityPlayer player, float partialTicks) {
        String otherPl;
        String ownerName = player.func_70005_c_();
        if (!clientFamiliars.containsKey(ownerName)) {
            return;
        }
        ExFamiliarData data = clientFamiliars.get(ownerName);
        PartialEntityFamiliar fam = data.familiar;
        Aspect aspect = Aspect.getAspect((String)data.data.aspectTag);
        if (ENTITY_WISP == null) {
            ENTITY_WISP = new EntityWisp((World)new FakeWorld());
        }
        ENTITY_WISP.setType(aspect.getTag());
        FamiliarHandlerClient.ENTITY_WISP.field_70173_aa = fam.dummyEntity.field_70173_aa;
        GL11.glPushMatrix();
        if (fam.owner == null || fam.owner.get() == null) {
            fam.owner = new WeakReference<EntityPlayer>(player);
        }
        EntityClientPlayerMP current = Minecraft.func_71410_x().field_71439_g;
        double diffX = fam.renderX - current.field_70165_t + player.field_70165_t;
        double diffY = fam.renderY - current.field_70163_u + player.field_70163_u + 0.5;
        double diffZ = fam.renderZ - current.field_70161_v + player.field_70161_v;
        String currentPl = current.func_70005_c_();
        if (!currentPl.equals(otherPl = player.func_70005_c_())) {
            diffY += 1.32;
            EntityLivingBase entity = Minecraft.func_71410_x().field_71451_h;
            diffX -= (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            diffY -= (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            diffZ -= (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        }
        ItemRenderFamiliar.renderEntityWispFor((EntityPlayer)fam.owner.get(), ENTITY_WISP, diffX, diffY, diffZ, 0.0f, partialTicks);
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static void playerTickEvent() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        for (ExFamiliarData data : clientFamiliars.values()) {
            data.familiar.tick();
        }
        PartialEntityFamiliar.DUMMY_FAMILIAR.tick();
    }

    public static void handleAdditions(List<DataFamiliar.FamiliarData> toAdd) {
        for (DataFamiliar.FamiliarData data : toAdd) {
            PartialEntityFamiliar familiar = new PartialEntityFamiliar(Minecraft.func_71410_x().field_71441_e.func_72924_a(data.owner), data.owner);
            ExFamiliarData exData = new ExFamiliarData(data, familiar);
            clientFamiliars.put(data.owner, exData);
        }
    }

    public static void handleRemovals(List<DataFamiliar.FamiliarData> toRemove) {
        for (DataFamiliar.FamiliarData data : toRemove) {
            clientFamiliars.remove(data.owner);
        }
    }

    static {
        clientFamiliars = new HashMap<String, ExFamiliarData>();
        fallbackRenderer = new RenderWisp();
        fallbackRenderer.func_76976_a(RenderManager.field_78727_a);
    }

    public static class PartialEntityFamiliar {
        public static final PartialEntityFamiliar DUMMY_FAMILIAR = new PartialEntityFamiliar(null, "\u00a7Invalid\u00a7");
        private static final double RAD_CAP = Math.PI * 2;
        private static final int CRICLE_TIME_TICKS = 160;
        private static final double RADIUS = 1.0;
        public DummyEntityFamiliar dummyEntity = new DummyEntityFamiliar(null);
        public WeakReference<EntityPlayer> owner;
        public String potentialOwnerName;
        public double posX;
        public double posY;
        public double posZ;
        public double renderX;
        public double renderY;
        public double renderZ;
        public double prevPosX;
        public double prevPosY;
        public double prevPosZ;
        public int ticksExisted;

        public PartialEntityFamiliar(EntityPlayer owner, String ownerNameToSearch) {
            this.owner = new WeakReference<EntityPlayer>(owner);
            this.potentialOwnerName = ownerNameToSearch;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void tick() {
            ++this.ticksExisted;
            this.dummyEntity.field_70173_aa = this.ticksExisted;
            if (this.owner.get() == null) {
                if (this.potentialOwnerName == null) return;
                EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_72924_a(this.potentialOwnerName);
                if (player == null) return;
                this.owner = new WeakReference<EntityPlayer>(player);
            } else if (((EntityPlayer)this.owner.get()).field_70170_p.field_73011_w.field_76574_g != Minecraft.func_71410_x().field_71451_h.field_70170_p.field_73011_w.field_76574_g) {
                this.owner = new WeakReference<Object>(null);
                return;
            }
            this.prevPosX = this.posX;
            this.prevPosY = this.posY;
            this.prevPosZ = this.posZ;
            double part = (double)this.ticksExisted / 160.0;
            double theta = Math.PI * 2 * part;
            this.renderX = 1.0 * Math.cos(theta);
            this.renderZ = 1.0 * Math.sin(theta);
            this.renderY = Math.sin(theta * 2.0) / 2.0;
            this.posX = ((EntityPlayer)this.owner.get()).field_70165_t + this.renderX;
            this.posZ = ((EntityPlayer)this.owner.get()).field_70161_v + this.renderZ;
            this.posY = ((EntityPlayer)this.owner.get()).field_70163_u + this.renderY;
        }
    }

    public static class DummyEntityFamiliar
    extends Entity {
        public DummyEntityFamiliar(World p_i1582_1_) {
            super(p_i1582_1_);
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound p_70037_1_) {
        }

        protected void func_70014_b(NBTTagCompound p_70014_1_) {
        }
    }

    public static class ExFamiliarData {
        public final DataFamiliar.FamiliarData data;
        public final PartialEntityFamiliar familiar;

        public ExFamiliarData(DataFamiliar.FamiliarData data, PartialEntityFamiliar familiar) {
            this.data = data;
            this.familiar = familiar;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExFamiliarData that = (ExFamiliarData)o;
            return (this.data != null ? this.data.equals(that.data) : that.data == null) && (this.familiar != null ? this.familiar.equals(that.familiar) : that.familiar == null);
        }

        public int hashCode() {
            int result = this.data != null ? this.data.hashCode() : 0;
            result = 31 * result + (this.familiar != null ? this.familiar.hashCode() : 0);
            return result;
        }
    }
}

