/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import makeo.gadomancy.client.util.MultiTickEffectDispatcher;
import makeo.gadomancy.client.util.UtilsFX;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.blocks.tiles.TileInfusionClaw;
import makeo.gadomancy.common.utils.ExplosionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.common.Thaumcraft;

public class PacketStartAnimation
implements IMessage,
IMessageHandler<PacketStartAnimation, IMessage> {
    public static final byte ID_INFUSIONCLAW = 0;
    public static final byte ID_EX_VORTEX = 1;
    public static final byte ID_BURST = 2;
    public static final byte ID_RUNES = 3;
    public static final byte ID_SPARKLE_SPREAD = 4;
    public static final byte ID_SPARKLE = 5;
    public static final byte ID_SMOKE = 6;
    public static final byte ID_SMOKE_SPREAD = 7;
    public static final byte ID_BUBBLES = 8;
    private byte annimationId;
    private int x;
    private int y;
    private int z;
    private int additionalData;

    public PacketStartAnimation(byte annimationId, int x, int y, int z) {
        this(annimationId, x, y, z, 0);
    }

    public PacketStartAnimation(byte annimationId, int x, int y, int z, int additionalData) {
        this.annimationId = annimationId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.additionalData = additionalData;
    }

    public PacketStartAnimation() {
    }

    public void fromBytes(ByteBuf buf) {
        this.annimationId = buf.readByte();
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.additionalData = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.annimationId);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.additionalData);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketStartAnimation message, MessageContext ctx) {
        switch (message.annimationId) {
            case 0: {
                TileInfusionClaw tile = (TileInfusionClaw)Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
                if (tile == null) break;
                tile.animationStates[8] = 1.0f;
                break;
            }
            case 1: {
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
                if (te == null || !(te instanceof TileExtendedNode)) {
                    return null;
                }
                ExplosionHelper.VortexExplosion.vortexLightning((TileExtendedNode)te);
                break;
            }
            case 2: {
                Thaumcraft.proxy.burst((World)Minecraft.func_71410_x().field_71441_e, (double)((float)message.x + 0.5f), (double)((float)message.y + 0.5f), (double)((float)message.z + 0.5f), (float)(Minecraft.func_71410_x().field_71441_e.field_73012_v.nextInt(3) + 1));
                break;
            }
            case 3: {
                UtilsFX.doRuneEffects((World)Minecraft.func_71410_x().field_71441_e, message.x, message.y, message.z, message.additionalData);
                break;
            }
            case 4: {
                UtilsFX.doSparkleEffectsAround((World)Minecraft.func_71410_x().field_71441_e, message.x, message.y, message.z);
                break;
            }
            case 5: {
                UtilsFX.doSparkleEffects((World)Minecraft.func_71410_x().field_71441_e, message.x, message.y, message.z);
                break;
            }
            case 6: {
                UtilsFX.doSmokeEffects((World)Minecraft.func_71410_x().field_71441_e, message.x, message.y, message.z, Float.intBitsToFloat(message.additionalData));
                break;
            }
            case 7: {
                UtilsFX.doSmokeEffectsAround((World)Minecraft.func_71410_x().field_71441_e, message.x, message.y, message.z, Float.intBitsToFloat(message.additionalData));
                break;
            }
            case 8: {
                MultiTickEffectDispatcher.BubbleFXInfo bubbles = new MultiTickEffectDispatcher.BubbleFXInfo(Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g, Float.intBitsToFloat(message.x), Float.intBitsToFloat(message.y), Float.intBitsToFloat(message.z), 10, Float.intBitsToFloat(message.additionalData));
                MultiTickEffectDispatcher.registerBubbles(bubbles);
            }
        }
        return null;
    }
}

