/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.lib.utils.InventoryUtils;

public class TileArcaneDropper
extends TileEntity
implements ISidedInventory {
    private static final double RADIUS = 1.5;
    private List<EntityItem> items = new ArrayList<EntityItem>();
    private final List<EntityItem> dropQueue = new ArrayList<EntityItem>();
    private int count;
    private int removedCount;
    private EntityItem removedEntity;

    public void func_145845_h() {
        this.removedCount = 0;
        this.removedEntity = null;
        if (this.dropQueue.size() > 0) {
            for (int i = 0; i < this.dropQueue.size(); ++i) {
                EntityItem item = this.dropQueue.get(i);
                if (item.field_70128_L || this.field_145850_b.field_72996_f.contains(item)) continue;
                this.func_145831_w().func_72838_d((Entity)item);
                this.dropQueue.remove(i);
                --i;
            }
        }
        if (this.count > 20) {
            this.count = 0;
            World world = this.func_145831_w();
            if (!world.field_72995_K) {
                int oldSize = this.items.size();
                this.updateInventory();
                if (oldSize != 0 || this.items.size() != 0) {
                    world.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                }
            }
        }
        ++this.count;
    }

    private void updateInventory() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() & 7));
        double x = (double)(this.field_145851_c + dir.offsetX * 2) + 0.5;
        double y = (double)(this.field_145848_d + dir.offsetY * 2) + 0.5;
        double z = (double)(this.field_145849_e + dir.offsetZ * 2) + 0.5;
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)x, (double)y, (double)z).func_72314_b(1.5, 1.5, 1.5);
        this.items = this.func_145831_w().func_72872_a(EntityItem.class, box);
        for (int i = 0; i < 10; ++i) {
            this.items.add(null);
        }
    }

    private EntityItem dropItem(ItemStack stack) {
        if (this.removedEntity != null && this.removedEntity.field_70128_L) {
            for (EntityItem entityItem : this.items) {
                if (entityItem != this.removedEntity || !InventoryUtils.areItemStacksEqualStrict((ItemStack)this.removedEntity.func_92059_d(), (ItemStack)stack) || this.removedEntity.func_92059_d().field_77994_a + this.removedCount != stack.field_77994_a) continue;
                this.removedEntity.func_92059_d().field_77994_a += this.removedCount;
                this.removedEntity.field_70128_L = false;
                this.removedCount = 0;
                this.removedEntity = null;
                return entityItem;
            }
        }
        ForgeDirection side = ForgeDirection.getOrientation((int)(this.func_145832_p() & 7));
        double x = (double)this.field_145851_c + 0.5 + (double)side.offsetX * 0.5;
        double y = (double)this.field_145848_d + 0.25 + (double)side.offsetY * 0.5;
        double z = (double)this.field_145849_e + 0.5 + (double)side.offsetZ * 0.5;
        EntityItem entityItem = new EntityItem(this.func_145831_w(), x, y, z, stack.func_77946_l());
        entityItem.field_70159_w = (double)side.offsetX * 0.1;
        entityItem.field_70181_x = (double)side.offsetY * 0.1;
        entityItem.field_70179_y = (double)side.offsetZ * 0.1;
        entityItem.field_145804_b = 3;
        this.dropQueue.add(entityItem);
        return entityItem;
    }

    public int func_70302_i_() {
        this.updateInventory();
        return this.items.size();
    }

    public ItemStack func_70301_a(int slot) {
        this.updateInventory();
        if (slot >= this.items.size()) {
            return null;
        }
        EntityItem entity = this.items.get(slot);
        return entity == null || entity.field_70128_L ? null : entity.func_92059_d();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack.field_77994_a - amount <= 0) {
            this.func_70299_a(slot, null);
            return stack.func_77946_l();
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.field_77994_a = amount;
        stack.field_77994_a -= amount;
        this.removedEntity = this.items.get(slot);
        this.removedCount = amount;
        return newStack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        EntityItem oldEntity = this.items.get(slot);
        if (oldEntity != null) {
            oldEntity.func_70106_y();
        }
        if (stack != null && stack.field_77994_a > 0) {
            if (oldEntity != null && InventoryUtils.areItemStacksEqualStrict((ItemStack)oldEntity.func_92059_d(), (ItemStack)stack)) {
                oldEntity.func_92059_d().field_77994_a = stack.field_77994_a;
                oldEntity.field_70128_L = false;
            } else {
                this.items.set(slot, this.dropItem(stack));
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public String func_145825_b() {
        return RegisteredBlocks.blockArcaneDropper.func_149732_F();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        int[] slots = new int[this.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return RegisteredBlocks.blockArcaneDropper.isSideSolid((IBlockAccess)this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, ForgeDirection.getOrientation((int)side));
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (this.func_102007_a(slot, stack, side)) {
            EntityItem entityItem = this.items.get(slot);
            return entityItem == null || entityItem.field_145804_b <= 0;
        }
        return false;
    }
}

