/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.familiar;

import baubles.api.BaublesApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import makeo.gadomancy.common.familiar.FamiliarAIProcess_Old;
import makeo.gadomancy.common.registration.RegisteredFamiliarAI_Old;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class FamiliarAIController_Old {
    private static final Random RAND = new Random();
    private static Map<EntityPlayer, LinkedList<EntityLivingBase>> targetMap = new HashMap<EntityPlayer, LinkedList<EntityLivingBase>>();
    private List<FamiliarAIProcess_Old> availableTasks = new ArrayList<FamiliarAIProcess_Old>();
    private Map<FamiliarAIProcess_Old, Integer> cooldownProcesses = new HashMap<FamiliarAIProcess_Old, Integer>();
    private LinkedList<FamiliarAIProcess_Old> requestedLoop = new LinkedList();
    private FamiliarAIProcess_Old runningTask;
    private int ticksInTask;
    private EntityPlayer owningPlayer;

    public FamiliarAIController_Old(EntityPlayer owningPlayer) {
        this.owningPlayer = owningPlayer;
    }

    public void registerDefaultTasks() {
        this.availableTasks.add(RegisteredFamiliarAI_Old.familiarAIIdle);
        this.availableTasks.add(RegisteredFamiliarAI_Old.familiarAIZapAttackingMonsters);
    }

    public void scheduleTick() {
        this.reduceRunningCooldowns();
        if (this.runningTask == null) {
            this.selectNewTask();
        } else {
            ItemStack famStack = BaublesApi.getBaubles((EntityPlayer)this.owningPlayer).func_70301_a(0);
            this.runningTask.tick(this.ticksInTask, this.owningPlayer.field_70170_p, this.owningPlayer, famStack);
            ++this.ticksInTask;
            if (this.ticksInTask >= this.runningTask.getDuration()) {
                if (this.runningTask.getCooldownDuration(famStack) > 0) {
                    this.cooldownProcesses.put(this.runningTask, this.runningTask.getCooldownDuration(famStack));
                }
                if (this.runningTask.tryLoop() && !this.requestedLoop.contains(this.runningTask)) {
                    this.requestedLoop.addLast(this.runningTask);
                }
                this.runningTask = null;
                this.ticksInTask = 0;
            }
        }
    }

    private void selectNewTask() {
        if (!this.requestedLoop.isEmpty()) {
            Iterator it = this.requestedLoop.iterator();
            while (it.hasNext()) {
                FamiliarAIProcess_Old process = (FamiliarAIProcess_Old)it.next();
                if (this.cooldownProcesses.containsKey(process)) continue;
                this.runningTask = process;
                it.remove();
                return;
            }
        }
        int size = this.availableTasks.size();
        int randIndex = RAND.nextInt(size);
        for (int i = 0; i < size; ++i) {
            int index = (randIndex + i) % size;
            FamiliarAIProcess_Old process = this.availableTasks.get(index);
            if (!process.canRun(this.owningPlayer.field_70170_p, this.owningPlayer.field_70165_t, this.owningPlayer.field_70163_u, this.owningPlayer.field_70161_v, this.owningPlayer, BaublesApi.getBaubles((EntityPlayer)this.owningPlayer).func_70301_a(0)) || this.cooldownProcesses.containsKey(process)) continue;
            this.runningTask = process;
        }
    }

    private void reduceRunningCooldowns() {
        Iterator<FamiliarAIProcess_Old> itProcesses = this.cooldownProcesses.keySet().iterator();
        while (itProcesses.hasNext()) {
            FamiliarAIProcess_Old process = itProcesses.next();
            int cd = this.cooldownProcesses.get(process) - 1;
            if (cd <= 0) {
                itProcesses.remove();
                continue;
            }
            this.cooldownProcesses.put(process, cd);
        }
    }

    public EntityPlayer getOwningPlayer() {
        return this.owningPlayer;
    }

    public static boolean hasLastTargetter(EntityPlayer player) {
        return targetMap.containsKey(player) && targetMap.get(player).size() >= 1;
    }

    public static LinkedList<EntityLivingBase> getLastTargetters(EntityPlayer player) {
        if (!targetMap.containsKey(player)) {
            return null;
        }
        if (targetMap.get(player).size() < 1) {
            return null;
        }
        return targetMap.get(player);
    }

    public static void cleanTargetterList(EntityPlayer player) {
        if (!targetMap.containsKey(player)) {
            return;
        }
        Iterator it = targetMap.get(player).iterator();
        while (it.hasNext()) {
            EntityLivingBase living = (EntityLivingBase)it.next();
            if (!living.field_70128_L) continue;
            it.remove();
        }
    }

    public static void notifyTargetEvent(EntityLivingBase targetter, EntityPlayer targetted) {
        LinkedList<Object> targetters;
        boolean needsUpdate = false;
        if (targetMap.containsKey(targetted)) {
            targetters = targetMap.get(targetted);
        } else {
            targetters = new LinkedList();
            needsUpdate = true;
        }
        if (!targetters.contains(targetter)) {
            targetters.addLast(targetter);
        }
        if (needsUpdate) {
            targetMap.put(targetted, targetters);
        }
    }
}

