/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import makeo.gadomancy.api.ClickBehavior;
import makeo.gadomancy.common.blocks.BlockAdditionalEldritchPortal;
import makeo.gadomancy.common.blocks.BlockArcaneDropper;
import makeo.gadomancy.common.blocks.BlockAuraPylon;
import makeo.gadomancy.common.blocks.BlockEssentiaCompressor;
import makeo.gadomancy.common.blocks.BlockExtendedNodeJar;
import makeo.gadomancy.common.blocks.BlockInfusionClaw;
import makeo.gadomancy.common.blocks.BlockKnowledgeBook;
import makeo.gadomancy.common.blocks.BlockNodeManipulator;
import makeo.gadomancy.common.blocks.BlockRemoteJar;
import makeo.gadomancy.common.blocks.BlockStickyJar;
import makeo.gadomancy.common.blocks.BlockStoneMachine;
import makeo.gadomancy.common.blocks.tiles.TileAdditionalEldritchPortal;
import makeo.gadomancy.common.blocks.tiles.TileArcaneDropper;
import makeo.gadomancy.common.blocks.tiles.TileArcanePackager;
import makeo.gadomancy.common.blocks.tiles.TileAuraPylon;
import makeo.gadomancy.common.blocks.tiles.TileAuraPylonTop;
import makeo.gadomancy.common.blocks.tiles.TileBlockProtector;
import makeo.gadomancy.common.blocks.tiles.TileEssentiaCompressor;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNodeJar;
import makeo.gadomancy.common.blocks.tiles.TileInfusionClaw;
import makeo.gadomancy.common.blocks.tiles.TileKnowledgeBook;
import makeo.gadomancy.common.blocks.tiles.TileManipulationFocus;
import makeo.gadomancy.common.blocks.tiles.TileManipulatorPillar;
import makeo.gadomancy.common.blocks.tiles.TileNodeManipulator;
import makeo.gadomancy.common.blocks.tiles.TileRemoteJar;
import makeo.gadomancy.common.blocks.tiles.TileStickyJar;
import makeo.gadomancy.common.items.ItemBlockAdditionalEldritchPortal;
import makeo.gadomancy.common.items.ItemBlockAuraPylon;
import makeo.gadomancy.common.items.ItemBlockEssentiaCompressor;
import makeo.gadomancy.common.items.ItemBlockKnowledgeBook;
import makeo.gadomancy.common.items.ItemBlockRemoteJar;
import makeo.gadomancy.common.items.ItemBlockStoneMachine;
import makeo.gadomancy.common.items.ItemNodeManipulator;
import makeo.gadomancy.common.registration.StickyJarInfo;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import thaumcraft.common.blocks.BlockAiry;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.tiles.TileInfusionMatrix;

public class RegisteredBlocks {
    public static int rendererTransparentBlock;
    public static int rendererExtendedNodeJarBlock;
    public static int rendererBlockStoneMachine;
    public static BlockStickyJar blockStickyJar;
    public static BlockArcaneDropper blockArcaneDropper;
    public static BlockInfusionClaw blockInfusionClaw;
    public static BlockRemoteJar blockRemoteJar;
    public static BlockAiry blockNode;
    public static BlockExtendedNodeJar blockExtendedNodeJar;
    public static BlockNodeManipulator blockNodeManipulator;
    public static BlockStoneMachine blockStoneMachine;
    public static BlockAdditionalEldritchPortal blockAdditionalEldrichPortal;
    public static BlockAuraPylon blockAuraPylon;
    public static BlockKnowledgeBook blockKnowledgeBook;
    public static BlockEssentiaCompressor blockEssentiaCompressor;
    private static List<StickyJarInfo> stickyJars;
    private static List<ClickBehavior> clawBehaviors;

    private RegisteredBlocks() {
    }

    public static void init() {
        RegisteredBlocks.registerBlocks();
        RegisteredBlocks.registerTileEntities();
        RegisteredBlocks.registerDefaultStickyJars();
        RegisteredBlocks.registerDefaultClawBehaviors();
    }

    private static void registerBlocks() {
        blockStickyJar = RegisteredBlocks.registerBlock(new BlockStickyJar());
        blockArcaneDropper = RegisteredBlocks.registerBlock(new BlockArcaneDropper());
        blockInfusionClaw = RegisteredBlocks.registerBlock(new BlockInfusionClaw());
        blockRemoteJar = RegisteredBlocks.registerBlock(new BlockRemoteJar(), ItemBlockRemoteJar.class);
        blockNode = (BlockAiry)ConfigBlocks.blockAiry;
        blockExtendedNodeJar = RegisteredBlocks.registerBlock(new BlockExtendedNodeJar());
        blockNodeManipulator = RegisteredBlocks.registerBlock(new BlockNodeManipulator(), ItemNodeManipulator.class);
        blockStoneMachine = RegisteredBlocks.registerBlock(new BlockStoneMachine(), ItemBlockStoneMachine.class);
        blockAdditionalEldrichPortal = RegisteredBlocks.registerBlock(new BlockAdditionalEldritchPortal(), ItemBlockAdditionalEldritchPortal.class);
        blockAuraPylon = RegisteredBlocks.registerBlock(new BlockAuraPylon(), ItemBlockAuraPylon.class);
        blockKnowledgeBook = RegisteredBlocks.registerBlock(new BlockKnowledgeBook(), ItemBlockKnowledgeBook.class);
        blockEssentiaCompressor = RegisteredBlocks.registerBlock(new BlockEssentiaCompressor(), ItemBlockEssentiaCompressor.class);
    }

    private static <T extends Block> T registerBlock(String name, T block) {
        block.func_149663_c(name);
        GameRegistry.registerBlock(block, (String)name);
        return block;
    }

    private static <T extends Block> T registerBlock(String name, T block, Class<? extends ItemBlock> itemClass) {
        block.func_149663_c(name);
        GameRegistry.registerBlock(block, itemClass, (String)name);
        return block;
    }

    private static <T extends Block> T registerBlock(T block, Class<? extends ItemBlock> itemClass) {
        RegisteredBlocks.registerBlock(block.getClass().getSimpleName(), block, itemClass);
        return block;
    }

    private static <T extends Block> T registerBlock(T block) {
        RegisteredBlocks.registerBlock(block.getClass().getSimpleName(), block);
        return block;
    }

    private static void registerTileEntities() {
        RegisteredBlocks.registerTile(TileStickyJar.class);
        RegisteredBlocks.registerTile(TileArcaneDropper.class);
        RegisteredBlocks.registerTile(TileInfusionClaw.class);
        RegisteredBlocks.registerTile(TileRemoteJar.class);
        RegisteredBlocks.registerTile(TileExtendedNode.class);
        RegisteredBlocks.registerTile(TileExtendedNodeJar.class);
        RegisteredBlocks.registerTile(TileNodeManipulator.class);
        RegisteredBlocks.registerTile(TileManipulatorPillar.class);
        RegisteredBlocks.registerTile(TileManipulationFocus.class);
        RegisteredBlocks.registerTile(TileAdditionalEldritchPortal.class);
        RegisteredBlocks.registerTile(TileBlockProtector.class);
        RegisteredBlocks.registerTile(TileAuraPylon.class);
        RegisteredBlocks.registerTile(TileAuraPylonTop.class);
        RegisteredBlocks.registerTile(TileArcanePackager.class);
        RegisteredBlocks.registerTile(TileKnowledgeBook.class);
        RegisteredBlocks.registerTile(TileEssentiaCompressor.class);
    }

    private static void registerTile(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)name);
    }

    private static void registerTile(Class<? extends TileEntity> tile) {
        RegisteredBlocks.registerTile(tile, tile.getSimpleName());
    }

    private static void registerDefaultStickyJars() {
        RegisteredBlocks.registerStickyJar(ConfigBlocks.blockJar, 0, true, true);
        RegisteredBlocks.registerStickyJar(ConfigBlocks.blockJar, 3, true, true);
        RegisteredBlocks.registerStickyJar((Block)blockRemoteJar, 0, false, false);
    }

    public static void registerStickyJar(Block block, int metadata, boolean isLabelable, boolean isPhialable) {
        stickyJars.add(0, new StickyJarInfo(block, metadata, isLabelable, isPhialable));
    }

    public static StickyJarInfo getStickyJarInfo(Block block, int metadata) {
        for (StickyJarInfo info : stickyJars) {
            if (info.getBlock() != block || info.getMetadata() != metadata) continue;
            return info;
        }
        return null;
    }

    private static void registerDefaultClawBehaviors() {
        RegisteredBlocks.registerClawClickBehavior(new ClickBehavior(){

            @Override
            public boolean isValidForBlock() {
                return this.block == Blocks.field_150342_X && this.metadata == 0 || this.block == Blocks.field_150383_bp && this.metadata == 0;
            }
        });
        RegisteredBlocks.registerClawClickBehavior(new ClickBehavior(true){
            private TileInfusionMatrix matrix;

            @Override
            public boolean isValidForBlock() {
                if (this.block == ConfigBlocks.blockStoneDevice && this.metadata == 2) {
                    this.matrix = (TileInfusionMatrix)this.world.func_147438_o(this.x, this.y, this.z);
                    return true;
                }
                return false;
            }

            @Override
            public void addInstability(int instability) {
                this.matrix.instability += instability;
            }

            @Override
            public int getComparatorOutput() {
                return this.matrix.crafting ? 15 : 0;
            }
        });
    }

    public static void registerClawClickBehavior(ClickBehavior behavior) {
        clawBehaviors.add(behavior);
    }

    public static ClickBehavior getClawClickBehavior(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        for (ClickBehavior behavior : clawBehaviors) {
            behavior.init(world, block, x, y, z, metadata);
            if (!behavior.isValidForBlock()) continue;
            return behavior;
        }
        return null;
    }

    public static List<ClickBehavior> getClawClickBehaviors() {
        return clawBehaviors;
    }

    static {
        stickyJars = new ArrayList<StickyJarInfo>();
        clawBehaviors = new ArrayList<ClickBehavior>();
    }
}

