/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.effect.fx;

import java.util.Random;
import makeo.gadomancy.client.effect.EffectHandler;
import makeo.gadomancy.client.events.ClientHandler;
import makeo.gadomancy.common.blocks.tiles.TileEssentiaCompressor;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.lib.QuadHelper;
import thaumcraft.client.lib.UtilsFX;

public class FXVortex {
    private static final Random RAND = new Random();
    public static final ResourceLocation TC_VORTEX_TEXTURE = new ResourceLocation("thaumcraft", "textures/misc/vortex.png");
    private static final float RAD = (float)Math.PI * 2;
    private TileEssentiaCompressor parent;
    private long lastUpdateCall = System.currentTimeMillis();
    private double x;
    private double y;
    private double z;
    public boolean registered;

    public FXVortex(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public FXVortex(double x, double y, double z, TileEssentiaCompressor parent) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.parent = parent;
    }

    private void render(Tessellator tessellator, float pTicks) {
        float arX = ActiveRenderInfo.field_74588_d;
        float arXZ = ActiveRenderInfo.field_74589_e;
        float arZ = ActiveRenderInfo.field_74586_f;
        float arYZ = ActiveRenderInfo.field_74587_g;
        float arXY = ActiveRenderInfo.field_74596_h;
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float agescale = (float)(ClientHandler.ticks % 800) / 400.0f;
        if (agescale >= 1.0f) {
            agescale = 2.0f - agescale;
        }
        float size = 0.2f + 0.1f * agescale;
        if (this.parent != null) {
            size += size * ((float)this.parent.getSizeStage() * 0.04f);
        }
        float anglePerc = (float)(ClientHandler.ticks % 300) / 300.0f;
        float angle = (float)Math.PI * 2 - (float)Math.PI * 2 * anglePerc;
        Vector3 iV = MiscUtils.interpolateEntityPosition((Entity)Minecraft.func_71410_x().field_71451_h, pTicks);
        if (this.parent != null && this.parent.getSizeStage() > 4) {
            float mult = 0.001f * ((float)this.parent.getSizeStage() - 4.0f);
            Vector3 shake = new Vector3(RAND.nextFloat() * mult * (float)(RAND.nextBoolean() ? 1 : -1), RAND.nextFloat() * mult * (float)(RAND.nextBoolean() ? 1 : -1), RAND.nextFloat() * mult * (float)(RAND.nextBoolean() ? 1 : -1));
            iV.add(shake);
        }
        GL11.glTranslated((double)(-iV.getX()), (double)(-iV.getY()), (double)(-iV.getZ()));
        UtilsFX.bindTexture((ResourceLocation)TC_VORTEX_TEXTURE);
        tessellator.func_78382_b();
        tessellator.func_78380_c(220);
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        Vec3 v1 = Vec3.func_72443_a((double)(-arX * size - arYZ * size), (double)(-arXZ * size), (double)(-arZ * size - arXY * size));
        Vec3 v2 = Vec3.func_72443_a((double)(-arX * size + arYZ * size), (double)(arXZ * size), (double)(-arZ * size + arXY * size));
        Vec3 v3 = Vec3.func_72443_a((double)(arX * size + arYZ * size), (double)(arXZ * size), (double)(arZ * size + arXY * size));
        Vec3 v4 = Vec3.func_72443_a((double)(arX * size - arYZ * size), (double)(-arXZ * size), (double)(arZ * size - arXY * size));
        if (angle != 0.0f) {
            Vec3 pvec = Vec3.func_72443_a((double)iV.getX(), (double)iV.getY(), (double)iV.getZ());
            Vec3 tvec = Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
            Vec3 qvec = pvec.func_72444_a(tvec).func_72432_b();
            QuadHelper.setAxis((Vec3)qvec, (double)angle).rotate(v1);
            QuadHelper.setAxis((Vec3)qvec, (double)angle).rotate(v2);
            QuadHelper.setAxis((Vec3)qvec, (double)angle).rotate(v3);
            QuadHelper.setAxis((Vec3)qvec, (double)angle).rotate(v4);
        }
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        tessellator.func_78374_a(this.x + v1.field_72450_a, this.y + v1.field_72448_b, this.z + v1.field_72449_c, 0.0, 1.0);
        tessellator.func_78374_a(this.x + v2.field_72450_a, this.y + v2.field_72448_b, this.z + v2.field_72449_c, 1.0, 1.0);
        tessellator.func_78374_a(this.x + v3.field_72450_a, this.y + v3.field_72448_b, this.z + v3.field_72449_c, 1.0, 0.0);
        tessellator.func_78374_a(this.x + v4.field_72450_a, this.y + v4.field_72448_b, this.z + v4.field_72449_c, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }

    public static void sheduleRender(Iterable<FXVortex> vortexes, Tessellator tessellator, float partialTicks) {
        for (FXVortex vortex : vortexes) {
            GL11.glPushMatrix();
            vortex.render(tessellator, partialTicks);
            GL11.glPopMatrix();
        }
    }

    public static void tickVortexes(Iterable<FXVortex> vortexes) {
        for (FXVortex vortex : vortexes) {
            if (System.currentTimeMillis() - vortex.lastUpdateCall <= 100L) continue;
            EffectHandler.getInstance().unregisterVortex(vortex);
        }
    }

    public void notify(long timeMillis) {
        this.lastUpdateCall = timeMillis;
    }
}

