/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Iterator;
import java.util.List;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNode;
import makeo.gadomancy.common.blocks.tiles.TileExtendedNodeJar;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.entities.EntityAuraCore;
import makeo.gadomancy.common.items.ItemAuraCore;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.node.ExtendedNodeType;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.registration.RegisteredIntegrations;
import makeo.gadomancy.common.registration.RegisteredRecipes;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.nodes.INode;
import thaumcraft.api.nodes.NodeModifier;
import thaumcraft.api.nodes.NodeType;
import thaumcraft.common.blocks.BlockMagicalLog;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.tiles.TileJarNode;
import thaumcraft.common.tiles.TileOwned;
import thaumcraft.common.tiles.TileWarded;

public class WandHandler {
    public static void handleWandInteract(World world, int x, int y, int z, EntityPlayer entityPlayer, ItemStack i) {
        Block target = world.func_147439_a(x, y, z);
        if (target == null) {
            return;
        }
        if (ModConfig.enableAdditionalNodeTypes) {
            if (target.equals(Blocks.field_150359_w)) {
                if (ResearchManager.isResearchComplete((String)entityPlayer.func_70005_c_(), (String)"NODEJAR")) {
                    WandHandler.tryTCJarNodeCreation(i, entityPlayer, world, x, y, z);
                }
            } else if (target.equals(ConfigBlocks.blockWarded) && RegisteredIntegrations.automagy.isPresent() && ResearchManager.isResearchComplete((String)entityPlayer.func_70005_c_(), (String)"ADVNODEJAR")) {
                WandHandler.tryAutomagyJarNodeCreation(i, entityPlayer, world, x, y, z);
            }
        }
        if (target.equals(ConfigBlocks.blockCrystal) && ResearchManager.isResearchComplete((String)entityPlayer.func_70005_c_(), (String)("gadomancy".toUpperCase() + ".AURA_CORE"))) {
            WandHandler.tryAuraCoreCreation(i, entityPlayer, world, x, y, z);
        }
    }

    private static void tryAuraCoreCreation(ItemStack i, EntityPlayer entityPlayer, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        List items = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(10.0, 10.0, 10.0));
        Iterator it = items.iterator();
        EntityItem itemAuraCore = null;
        while (itemAuraCore == null && it.hasNext()) {
            EntityItem entityItem;
            Object item = it.next();
            if (item == null || !(item instanceof EntityItem) || ((EntityItem)item).field_70128_L || (entityItem = (EntityItem)item).func_92059_d() == null || entityItem.func_92059_d().func_77973_b() == null || !(entityItem.func_92059_d().func_77973_b() instanceof ItemAuraCore) || item instanceof EntityAuraCore || !((ItemAuraCore)entityItem.func_92059_d().func_77973_b()).isBlank(entityItem.func_92059_d())) continue;
            itemAuraCore = entityItem;
        }
        if (itemAuraCore == null) {
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        if (meta <= 6) {
            Aspect[] aspects;
            switch (meta) {
                case 0: {
                    aspects = new Aspect[]{Aspect.AIR};
                    break;
                }
                case 1: {
                    aspects = new Aspect[]{Aspect.FIRE};
                    break;
                }
                case 2: {
                    aspects = new Aspect[]{Aspect.WATER};
                    break;
                }
                case 3: {
                    aspects = new Aspect[]{Aspect.EARTH};
                    break;
                }
                case 4: {
                    aspects = new Aspect[]{Aspect.ORDER};
                    break;
                }
                case 5: {
                    aspects = new Aspect[]{Aspect.ENTROPY};
                    break;
                }
                case 6: {
                    aspects = new Aspect[]{Aspect.AIR, Aspect.FIRE, Aspect.EARTH, Aspect.WATER, Aspect.ORDER, Aspect.ENTROPY};
                    break;
                }
                default: {
                    return;
                }
            }
            if (!ThaumcraftApiHelper.consumeVisFromWandCrafting((ItemStack)i, (EntityPlayer)entityPlayer, (AspectList)((AspectList)RegisteredRecipes.auraCoreRecipes[meta].get(0)), (boolean)true)) {
                return;
            }
            PacketStartAnimation packet = new PacketStartAnimation(2, x, y, z);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)x, (double)y, (double)z, 32.0));
            world.func_72876_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 1.5f, false);
            world.func_147468_f(x, y, z);
            EntityAuraCore ea = new EntityAuraCore(itemAuraCore.field_70170_p, itemAuraCore.field_70165_t, itemAuraCore.field_70163_u, itemAuraCore.field_70161_v, itemAuraCore.func_92059_d(), new ChunkCoordinates(x, y, z), aspects);
            ea.field_70292_b = itemAuraCore.field_70292_b;
            ea.field_70290_d = itemAuraCore.field_70290_d;
            ea.field_70159_w = itemAuraCore.field_70159_w;
            ea.field_70181_x = itemAuraCore.field_70181_x;
            ea.field_70179_y = itemAuraCore.field_70179_y;
            itemAuraCore.field_70170_p.func_72838_d((Entity)ea);
            itemAuraCore.func_70106_y();
        }
    }

    private static void tryTCJarNodeCreation(ItemStack wandStack, EntityPlayer player, World world, int x, int y, int z) {
        JarPieceEvaluationRunnable slabRunnable = new JarPieceEvaluationRunnable(){

            @Override
            public boolean isValidPieceAt(World world, int absX, int absY, int absZ, EntityPlayer player) {
                Block block = world.func_147439_a(absX, absY, absZ);
                int md = world.func_72805_g(absX, absY, absZ);
                return WandHandler.containsMatch(false, OreDictionary.getOres((String)"slabWood"), new ItemStack[]{new ItemStack(block, 1, md)});
            }
        };
        JarPieceEvaluationRunnable glassRunnable = new JarPieceEvaluationRunnable(){

            @Override
            public boolean isValidPieceAt(World world, int absX, int absY, int absZ, EntityPlayer player) {
                return world.func_147439_a(absX, absY, absZ) == Blocks.field_150359_w;
            }
        };
        JarPieceEvaluationRunnable nodeRunnable = new JarPieceEvaluationRunnable(){

            @Override
            public boolean isValidPieceAt(World world, int absX, int absY, int absZ, EntityPlayer player) {
                TileEntity tile = world.func_147438_o(absX, absY, absZ);
                return tile != null && tile instanceof INode && !(tile instanceof TileJarNode);
            }
        };
        int[] result = WandHandler.evaluateIfValidJarIsPresent(world, x, y, z, player, slabRunnable, glassRunnable, nodeRunnable);
        if (result == null) {
            return;
        }
        if (!ThaumcraftApiHelper.consumeVisFromWandCrafting((ItemStack)wandStack, (EntityPlayer)player, (AspectList)new AspectList().add(Aspect.FIRE, 70).add(Aspect.EARTH, 70).add(Aspect.ORDER, 70).add(Aspect.AIR, 70).add(Aspect.ENTROPY, 70).add(Aspect.WATER, 70), (boolean)true)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        WandHandler.replaceJar(world, result[0], result[1], result[2], true);
    }

    private static void tryAutomagyJarNodeCreation(ItemStack wandStack, EntityPlayer player, World world, int x, int y, int z) {
        JarPieceEvaluationRunnable silverWoodRunnable = new JarPieceEvaluationRunnable(){

            @Override
            public boolean isValidPieceAt(World world, int absX, int absY, int absZ, EntityPlayer player) {
                TileEntity te = world.func_147438_o(absX, absY, absZ);
                if (te instanceof TileWarded) {
                    TileWarded warded = (TileWarded)te;
                    if (warded.block == ConfigBlocks.blockMagicalLog && BlockMagicalLog.limitToValidMetadata((int)warded.blockMd) == 1) {
                        return player.func_70005_c_().hashCode() == warded.owner;
                    }
                }
                return false;
            }
        };
        JarPieceEvaluationRunnable glassRunnable = new JarPieceEvaluationRunnable(){

            @Override
            public boolean isValidPieceAt(World world, int absX, int absY, int absZ, EntityPlayer player) {
                TileEntity te;
                if (world.func_147439_a(absX, absY, absZ) == ConfigBlocks.blockCosmeticOpaque && world.func_72805_g(absX, absY, absZ) == 2 && (te = world.func_147438_o(absX, absY, absZ)) instanceof TileOwned) {
                    return player.func_70005_c_().equals(((TileOwned)te).owner);
                }
                return false;
            }
        };
        JarPieceEvaluationRunnable nodeRunnable = new JarPieceEvaluationRunnable(){

            @Override
            public boolean isValidPieceAt(World world, int absX, int absY, int absZ, EntityPlayer player) {
                TileEntity tile = world.func_147438_o(absX, absY, absZ);
                return tile != null && tile instanceof INode && !(tile instanceof TileJarNode);
            }
        };
        int[] result = WandHandler.evaluateIfValidJarIsPresent(world, x, y, z, player, silverWoodRunnable, glassRunnable, nodeRunnable);
        if (result == null) {
            return;
        }
        if (!RegisteredIntegrations.automagy.handleNodeJarVisCost(wandStack, player)) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        if (!RegisteredIntegrations.automagy.isPresent()) {
            return;
        }
        WandHandler.replaceJar(world, result[0], result[1], result[2], false);
    }

    private static boolean containsMatch(boolean strict, List<ItemStack> inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!OreDictionary.itemMatches((ItemStack)input, (ItemStack)target, (boolean)strict)) continue;
                return true;
            }
        }
        return false;
    }

    private static int[] evaluateIfValidJarIsPresent(World world, int x, int y, int z, EntityPlayer player, JarPieceEvaluationRunnable topRunnable, JarPieceEvaluationRunnable glassRunnable, JarPieceEvaluationRunnable centerRunnable) {
        for (int xx = x - 2; xx <= x; ++xx) {
            for (int yy = y - 3; yy <= y; ++yy) {
                for (int zz = z - 2; zz <= z; ++zz) {
                    if (!WandHandler.isValidJarAt(world, xx, yy, zz, player, topRunnable, glassRunnable, centerRunnable)) continue;
                    return new int[]{xx, yy, zz};
                }
            }
        }
        return null;
    }

    private static boolean isValidJarAt(World world, int x, int y, int z, EntityPlayer player, JarPieceEvaluationRunnable topRunnable, JarPieceEvaluationRunnable glassRunnable, JarPieceEvaluationRunnable centerRunnable) {
        int[][][] blueprint = new int[][][]{new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 3, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}};
        for (int yy = 0; yy < 4; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    int index = blueprint[yy][xx][zz];
                    if (index == 1 && !topRunnable.isValidPieceAt(world, x + xx, y - yy + 2, z + zz, player)) {
                        return false;
                    }
                    if (index == 2 && !glassRunnable.isValidPieceAt(world, x + xx, y - yy + 2, z + zz, player)) {
                        return false;
                    }
                    if (index != 3 || centerRunnable.isValidPieceAt(world, x + xx, y - yy + 2, z + zz, player)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static void replaceJar(World world, int x, int y, int z, boolean isThaumcraft) {
        int[][][] blueprint = new int[][][]{new int[][]{{1, 1, 1}, {1, 1, 1}, {1, 1, 1}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 3, 2}, {2, 2, 2}}, new int[][]{{2, 2, 2}, {2, 2, 2}, {2, 2, 2}}};
        for (int yy = 0; yy < 4; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    if (blueprint[yy][xx][zz] == 3) {
                        WandHandler.handleJarForming(world, x, y, z, xx, yy, zz, isThaumcraft);
                        continue;
                    }
                    world.func_147468_f(x + xx, y - yy + 2, z + zz);
                }
            }
        }
        if (isThaumcraft) {
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thaumcraft:wand", 1.0f, 1.0f);
        }
    }

    private static void handleJarForming(World world, int x, int y, int z, int xx, int yy, int zz, boolean degrade) {
        TileEntity tile = world.func_147438_o(x + xx, y - yy + 2, z + zz);
        INode node = (INode)tile;
        AspectList na = node.getAspects().copy();
        int nt = node.getNodeType().ordinal();
        int nm = -1;
        int exNt = -1;
        NBTTagCompound behaviorSnapshot = null;
        if (node.getNodeModifier() != null) {
            nm = node.getNodeModifier().ordinal();
        }
        if (tile instanceof TileExtendedNode && ((TileExtendedNode)tile).getExtendedNodeType() != null) {
            exNt = ((TileExtendedNode)tile).getExtendedNodeType().ordinal();
            behaviorSnapshot = ((TileExtendedNode)tile).getBehaviorSnapshot();
        }
        if (degrade && world.field_73012_v.nextFloat() < 0.75f) {
            if (node.getNodeModifier() == null) {
                nm = NodeModifier.PALE.ordinal();
            } else if (node.getNodeModifier() == NodeModifier.BRIGHT) {
                nm = -1;
            } else if (node.getNodeModifier() == NodeModifier.PALE) {
                nm = NodeModifier.FADING.ordinal();
            }
        }
        String nid = node.getId();
        node.setAspects(new AspectList());
        world.func_147475_p(x + xx, y - yy + 2, z + zz);
        if (exNt != -1) {
            world.func_147465_d(x + xx, y - yy + 2, z + zz, (Block)RegisteredBlocks.blockExtendedNodeJar, 0, 3);
            tile = world.func_147438_o(x + xx, y - yy + 2, z + zz);
            TileExtendedNodeJar exJar = (TileExtendedNodeJar)tile;
            exJar.setAspects(na);
            if (nm >= 0) {
                exJar.setNodeModifier(NodeModifier.values()[nm]);
            }
            exJar.setNodeType(NodeType.values()[nt]);
            exJar.setExtendedNodeType(ExtendedNodeType.values()[exNt]);
            if (behaviorSnapshot != null) {
                exJar.setBehaviorSnapshot(behaviorSnapshot);
            }
            exJar.setId(nid);
            world.func_147452_c(x + xx, y - yy + 2, z + zz, (Block)RegisteredBlocks.blockExtendedNodeJar, 9, 0);
        } else {
            world.func_147465_d(x + xx, y - yy + 2, z + zz, ConfigBlocks.blockJar, 2, 3);
            tile = world.func_147438_o(x + xx, y - yy + 2, z + zz);
            TileJarNode jar = (TileJarNode)tile;
            jar.setAspects(na);
            if (nm >= 0) {
                jar.setNodeModifier(NodeModifier.values()[nm]);
            }
            jar.setNodeType(NodeType.values()[nt]);
            jar.setId(nid);
            world.func_147452_c(x + xx, y - yy + 2, z + zz, ConfigBlocks.blockJar, 9, 0);
        }
    }

    public static abstract class JarPieceEvaluationRunnable {
        public abstract boolean isValidPieceAt(World var1, int var2, int var3, int var4, EntityPlayer var5);
    }
}

