/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.network.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.awt.Color;
import makeo.gadomancy.common.utils.StringHelper;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.PlayerNotifications;

public class PacketTCNotificationText
implements IMessage,
IMessageHandler<PacketTCNotificationText, IMessage> {
    private String text;
    private String additionalInfo;
    private int color;

    public PacketTCNotificationText() {
    }

    public PacketTCNotificationText(String text, Color color, String additionalInfo) {
        this(text, color.getRGB(), additionalInfo);
    }

    public PacketTCNotificationText(String text, int color, String additionalInfo) {
        this.text = text;
        this.additionalInfo = additionalInfo;
        this.color = color;
    }

    public PacketTCNotificationText(String text, String additionalInfo) {
        this(text, 0, additionalInfo);
    }

    public PacketTCNotificationText(String text) {
        this(text, "");
    }

    public void fromBytes(ByteBuf buf) {
        this.color = buf.readInt();
        this.text = StringHelper.readFromBuffer(buf);
        this.additionalInfo = StringHelper.readFromBuffer(buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.color);
        StringHelper.writeToBuffer(buf, this.text);
        if (this.additionalInfo == null) {
            this.additionalInfo = "";
        }
        StringHelper.writeToBuffer(buf, this.additionalInfo);
    }

    public IMessage onMessage(PacketTCNotificationText message, MessageContext ctx) {
        if (message.text == null) {
            return null;
        }
        String translated = StatCollector.func_74838_a((String)message.text);
        ResourceLocation image = null;
        int color = message.color;
        Aspect a = Aspect.getAspect((String)message.additionalInfo);
        if (a != null) {
            image = a.getImage();
            color = a.getColor();
        }
        if (message.text.equals("gadomancy.aura.research.unlock")) {
            translated = a != null ? EnumChatFormatting.GREEN + String.format(translated, a.getName()) : EnumChatFormatting.GREEN + String.format(translated, message.additionalInfo);
        }
        PlayerNotifications.addNotification((String)translated, (ResourceLocation)image, (int)(color &= 0xFFFFFF));
        return null;
    }
}

