/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.aura;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import makeo.gadomancy.common.aura.AuraResearchManager;
import makeo.gadomancy.common.utils.SimpleResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.research.ResearchPage;

public class ResearchPageAuraAspects
extends ResearchPage {
    private static final ResourceLocation transparent = new SimpleResourceLocation("items/transparent.png");

    private ResearchPageAuraAspects(AspectList as) {
        super(as);
    }

    public static ResearchPage[] createAllAuraPagesFor(EntityPlayer player) {
        ArrayList<ResearchPageAuraAspects> pages = new ArrayList<ResearchPageAuraAspects>();
        int additionalPages = ResearchPageAuraAspects.getAdditionalPagesFor(player);
        for (int i = 0; i < additionalPages; ++i) {
            List<String> tags = ResearchPageAuraAspects.getAspectTagsForPageIndex(player, i);
            AspectList list = ResearchPageAuraAspects.createPageAspectList(tags);
            pages.add(new ResearchPageAuraAspects(list));
        }
        ResearchPage[] t = new ResearchPage[1];
        return pages.toArray(t);
    }

    public static int getAdditionalPagesFor(EntityPlayer player) {
        List<String> knowledge = AuraResearchManager.getKnowledge(player);
        if (knowledge.size() == 0) {
            return 0;
        }
        return (knowledge.size() & 3) == 0 ? knowledge.size() >> 2 : (knowledge.size() >> 2) + 1;
    }

    public static List<String> getAspectTagsForPageIndex(EntityPlayer player, int pageIndex) {
        List<String> knowledge = AuraResearchManager.getKnowledge(player);
        if (knowledge.size() <= 0) {
            return new ArrayList<String>();
        }
        Collections.sort(knowledge);
        int startIndex = pageIndex << 2;
        if (knowledge.size() <= startIndex) {
            return new ArrayList<String>();
        }
        return knowledge.subList(startIndex, startIndex + 4 > knowledge.size() ? knowledge.size() : startIndex + 4);
    }

    public static AspectList createPageAspectList(List<String> tagList) {
        AspectList list = new AspectList();
        for (String tag : tagList) {
            Aspect a = ResearchPageAuraAspects.createAuraFakeAspect(tag);
            if (a == null) continue;
            list.add(a, 0);
        }
        return list;
    }

    private static Aspect createAuraFakeAspect(String tag) {
        Aspect original = Aspect.getAspect((String)tag);
        if (original == null) {
            return null;
        }
        String fakeTemp = "GADOMANCY_TEMP_" + tag;
        FakeAspect fake = new FakeAspect(fakeTemp, original.getColor(), null, original.getImage(), original.getBlend(), true);
        fake.setTag(original.getTag());
        return fake;
    }

    private static class FakeAspect
    extends Aspect {
        private boolean headAspect;

        public FakeAspect(String tag, int color, Aspect[] components, ResourceLocation image, int blend, boolean isHead) {
            super(tag, color, components, image, blend);
            Aspect.aspects.remove(tag);
            this.headAspect = isHead;
        }

        public String getName() {
            if (this.headAspect) {
                return super.getName();
            }
            String tag = super.getTag();
            if (tag == null || tag.isEmpty() || tag.equals("")) {
                return "";
            }
            return StatCollector.func_74838_a((String)tag);
        }
    }
}

