/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.effect.fx;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import makeo.gadomancy.client.effect.EffectHandler;
import makeo.gadomancy.client.effect.fx.EntityFXFlowPolicy;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.SimpleResourceLocation;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class FXFlow {
    private Color color;
    private Color fadingColor;
    private int policyCounter;
    private EntityFXFlowPolicy policy;
    private Vector3 target;
    private int livingTicks = -1;
    private World origin;
    private double motionBufferX;
    private double motionBufferY;
    private double motionBufferZ;
    private double lastTickPosX;
    private double lastTickPosY;
    private double lastTickPosZ;
    private double posX;
    private double posY;
    private double posZ;
    private float motionMultiplier = 1.0f;
    private float mainParticleSize = 0.2f;
    private float surroundingParticleSize = 0.1f;
    private float surroundingDistance = 0.8f;
    private double unmodMotionBufX;
    private double unmodMotionBufY;
    private double unmodMotionBufZ;
    public long lastUpdateCall = System.currentTimeMillis();

    public FXFlow(World originWorld) {
        this.origin = originWorld;
        this.policy = EntityFXFlowPolicy.Policies.DEFAULT.getPolicy();
    }

    public FXFlow applyTarget(Vector3 target) {
        this.target = target;
        return this;
    }

    public FXFlow setSurroundingDistance(float surroundingDistance) {
        this.surroundingDistance = 1.0f / surroundingDistance;
        return this;
    }

    public FXFlow setMainParticleSize(float newSize) {
        this.mainParticleSize = newSize;
        return this;
    }

    public FXFlow setSurroundingParticleSize(float newSize) {
        this.surroundingParticleSize = newSize;
        return this;
    }

    public FXFlow setLivingTicks(int livingTicks) {
        this.livingTicks = livingTicks;
        return this;
    }

    public FXFlow setColor(Color newColor) {
        this.fadingColor = this.color;
        this.color = newColor;
        return this;
    }

    public FXFlow setPosition(double x, double y, double z) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        return this;
    }

    public FXFlow setPosition(Vector3 vec) {
        return this.setPosition(vec.getX(), vec.getY(), vec.getZ());
    }

    public void setMotionMultiplier(float motionMultiplier) {
        this.motionMultiplier = motionMultiplier;
    }

    public FXFlow setMotion(double motionX, double motionY, double motionZ) {
        this.unmodMotionBufX = motionX;
        this.unmodMotionBufY = motionY;
        this.unmodMotionBufZ = motionZ;
        this.motionBufferX = motionX *= (double)this.motionMultiplier;
        this.motionBufferY = motionY *= (double)this.motionMultiplier;
        this.motionBufferZ = motionZ *= (double)this.motionMultiplier;
        return this;
    }

    public void tick() {
        --this.livingTicks;
        if (this.livingTicks <= 0) {
            EffectHandler.getInstance().unregisterFlow(this);
            return;
        }
        this.calculateVelocity();
        this.lastTickPosX = this.posX;
        this.lastTickPosY = this.posY;
        this.lastTickPosZ = this.posZ;
        this.posX += this.motionBufferX;
        this.posY += this.motionBufferY;
        this.posZ += this.motionBufferZ;
        ++this.policyCounter;
        this.doParticles();
    }

    private void calculateVelocity() {
        if (this.target == null) {
            return;
        }
        if (this.livingTicks <= 0) {
            return;
        }
        Vector3 pos = this.getPositionVector();
        double motDirX = this.target.getX() - pos.getX();
        double motDirY = this.target.getY() - pos.getY();
        double motDirZ = this.target.getZ() - pos.getZ();
        Vector3 mot = new Vector3(motDirX, motDirY, motDirZ).divide(this.livingTicks);
        this.setMotion(mot.getX(), mot.getY(), mot.getZ());
    }

    private Vector3 getPositionVector() {
        return new Vector3(this.posX, this.posY, this.posZ);
    }

    public void setPolicy(EntityFXFlowPolicy policy) {
        this.policy = policy;
    }

    public void setPolicy(EntityFXFlowPolicy.Policies policy) {
        this.policy = policy.getPolicy();
    }

    private void doParticles() {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            EffectHandler.getInstance().unregisterFlow(this);
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g != this.origin.field_73011_w.field_76574_g) {
            EffectHandler.getInstance().unregisterFlow(this);
            return;
        }
        FXFlowBase flow = new FXFlowBase(this.origin, this.posX, this.posY, this.posZ, this.color, this.mainParticleSize, 9, 240);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flow);
        double lastPosX = this.posX - (this.posX - this.lastTickPosX) / 2.0;
        double lastPosY = this.posY - (this.posY - this.lastTickPosY) / 2.0;
        double lastPosZ = this.posZ - (this.posZ - this.lastTickPosZ) / 2.0;
        FXFlowBase flow2 = new FXFlowBase(this.origin, lastPosX, lastPosY, lastPosZ, this.color, (float)((double)this.mainParticleSize * 0.8), 8, 240);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)flow2);
        if (this.policy != null) {
            this.policy.doSubParticles(this, this.policyCounter, this.posX, this.posY, this.posZ, lastPosX, lastPosY, lastPosZ);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public Color getFadingColor() {
        return this.fadingColor;
    }

    public float getSurroundingDistance() {
        return this.surroundingDistance;
    }

    public float getSurroundingParticleSize() {
        return this.surroundingParticleSize;
    }

    public float getMainParticleSize() {
        return this.mainParticleSize;
    }

    public float getMotionMultiplier() {
        return this.motionMultiplier;
    }

    public boolean isMovementVectorNullLength() {
        return new Vector3(this.motionBufferX, this.motionBufferY, this.motionBufferZ).lengthSquared() == 0.0;
    }

    public Vector3 getTarget() {
        return this.target;
    }

    public World getOriginWorld() {
        return this.origin;
    }

    public Vector3 getMovementVector() {
        if (this.isMovementVectorNullLength()) {
            return new Vector3(this.unmodMotionBufX, this.unmodMotionBufY, this.unmodMotionBufZ);
        }
        return new Vector3(this.motionBufferX, this.motionBufferY, this.motionBufferZ);
    }

    public Random getRand() {
        return this.origin.field_73012_v;
    }

    public FXFlow applyProperties(EntityFlowProperties properties) {
        if (properties != null) {
            if (properties.hasTarget) {
                this.applyTarget(properties.target);
            }
            if (properties.color != null) {
                if (properties.fading != null) {
                    this.setColor(properties.fading);
                    this.setColor(properties.color);
                } else {
                    this.setColor(properties.color);
                }
            } else if (properties.fading != null) {
                this.setColor(properties.fading);
            }
            if (properties.livingTicks != -1) {
                this.setLivingTicks(properties.livingTicks);
            }
            if (properties.mainParticleSize != -1.0f) {
                this.setMainParticleSize(properties.mainParticleSize);
            }
            if (properties.surroundingDistance != -1.0f) {
                this.setSurroundingDistance(properties.surroundingDistance);
            }
            if (properties.surroundingParticleSize != -1.0f) {
                this.setSurroundingParticleSize(properties.surroundingParticleSize);
            }
            if (properties.motionMultiplier != Float.MAX_VALUE) {
                this.setMotionMultiplier(properties.motionMultiplier);
            }
            if (properties.policy != null) {
                this.setPolicy(properties.policy);
            }
        }
        return this;
    }

    public static void tickFlows(Iterable<FXFlow> fxFlows) {
        for (FXFlow flow : fxFlows) {
            if (System.currentTimeMillis() - flow.lastUpdateCall > 1000L) {
                EffectHandler.getInstance().unregisterFlow(flow);
            }
            flow.tick();
        }
    }

    public static class FXFlowBase
    extends EntityFX {
        private static Queue<FXFlowBase> fxQueue = new ArrayDeque<FXFlowBase>();
        private float partBlue;
        private float partGreen;
        private float partRed;
        private float partAlpha;
        private float partialTicks;
        private float rendArg1;
        private float rendArg2;
        private float rendArg3;
        private float rendArg4;
        private float rendArg5;
        private int rendBrightness;
        private ResourceLocation texture = new SimpleResourceLocation("fx/flow_large.png");
        private float buffHalfLife;
        private float buffParticleScale;

        public FXFlowBase(World world, double x, double y, double z, Color color, float size, int multiplier, int brightness) {
            super(world, x, y, z);
            if (color != null) {
                this.partBlue = (float)color.getBlue() / 255.0f;
                this.partGreen = (float)color.getGreen() / 255.0f;
                this.partRed = (float)color.getRed() / 255.0f;
                this.partAlpha = (float)color.getAlpha() / 255.0f;
            }
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70544_f *= size;
            this.field_70547_e = 3 * multiplier;
            this.field_70145_X = false;
            this.func_70105_a(0.01f, 0.01f);
            this.field_70546_d = 0;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_94054_b = 0;
            this.field_94055_c = 0;
            this.buffHalfLife = this.field_70547_e / 2;
            this.buffParticleScale = this.field_70544_f;
            this.rendBrightness = brightness;
            this.field_70145_X = true;
        }

        public static void sheduleRender(Tessellator tessellator) {
            boolean isLightingEnabled = GL11.glGetBoolean((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glAlphaFunc((int)516, (float)0.003921569f);
            if (isLightingEnabled) {
                GL11.glDisable((int)2896);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            for (FXFlowBase fx : fxQueue) {
                tessellator.func_78382_b();
                fx.renderEssenceBase(tessellator);
                tessellator.func_78381_a();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            if (isLightingEnabled) {
                GL11.glEnable((int)2896);
            }
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            fxQueue.clear();
        }

        private void renderEssenceBase(Tessellator tessellator) {
            tessellator.func_78380_c(this.rendBrightness);
            GL11.glColor4f((float)this.partRed, (float)this.partGreen, (float)this.partBlue, (float)this.partAlpha);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            if (this.field_70546_d >= this.field_70547_e) {
                return;
            }
            float agescale = (float)this.field_70546_d / this.buffHalfLife;
            if (agescale >= 1.0f) {
                agescale = 2.0f - agescale;
            }
            this.field_70544_f = this.buffParticleScale * agescale;
            float f10 = 0.5f * this.field_70544_f;
            float f11 = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)this.partialTicks - EntityFX.field_70556_an);
            float f12 = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)this.partialTicks - EntityFX.field_70554_ao);
            float f13 = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)this.partialTicks - EntityFX.field_70555_ap);
            tessellator.func_78374_a((double)(f11 - this.rendArg1 * f10 - this.rendArg4 * f10), (double)(f12 - this.rendArg2 * f10), (double)(f13 - this.rendArg3 * f10 - this.rendArg5 * f10), 0.0, 1.0);
            tessellator.func_78374_a((double)(f11 - this.rendArg1 * f10 + this.rendArg4 * f10), (double)(f12 + this.rendArg2 * f10), (double)(f13 - this.rendArg3 * f10 + this.rendArg5 * f10), 1.0, 1.0);
            tessellator.func_78374_a((double)(f11 + this.rendArg1 * f10 + this.rendArg4 * f10), (double)(f12 + this.rendArg2 * f10), (double)(f13 + this.rendArg3 * f10 + this.rendArg5 * f10), 1.0, 0.0);
            tessellator.func_78374_a((double)(f11 + this.rendArg1 * f10 - this.rendArg4 * f10), (double)(f12 - this.rendArg2 * f10), (double)(f13 + this.rendArg3 * f10 - this.rendArg5 * f10), 0.0, 0.0);
        }

        public void func_70539_a(Tessellator tessellator, float partialTicks, float par3, float par4, float par5, float par6, float par7) {
            Vector3 vector3 = new Vector3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (MiscUtils.getPositionVector((Entity)Minecraft.func_71410_x().field_71451_h).distance(vector3) > (double)ModConfig.renderParticleDistance) {
                return;
            }
            this.partialTicks = partialTicks;
            this.rendArg1 = par3;
            this.rendArg2 = par4;
            this.rendArg3 = par5;
            this.rendArg4 = par6;
            this.rendArg5 = par7;
            fxQueue.add(this);
        }
    }

    public static class EntityFlowProperties {
        protected boolean hasTarget;
        protected Vector3 target;
        protected Color color;
        protected Color fading;
        protected EntityFXFlowPolicy policy;
        protected float mainParticleSize = -1.0f;
        protected float surroundingParticleSize = -1.0f;
        protected float surroundingDistance = -1.0f;
        protected int livingTicks = -1;
        protected float motionMultiplier = Float.MAX_VALUE;

        public EntityFlowProperties setTarget(Vector3 target) {
            this.hasTarget = target != null;
            this.target = target;
            return this;
        }

        public EntityFlowProperties setPolicy(EntityFXFlowPolicy policy) {
            this.policy = policy;
            return this;
        }

        public EntityFlowProperties setPolicy(EntityFXFlowPolicy.Policies policy) {
            this.policy = policy.getPolicy();
            return this;
        }

        public EntityFlowProperties setColor(Color color) {
            this.color = color;
            return this;
        }

        public EntityFlowProperties setMotionMultiplier(float motionMultiplier) {
            this.motionMultiplier = motionMultiplier;
            return this;
        }

        public EntityFlowProperties setFading(Color fading) {
            this.fading = fading;
            return this;
        }

        public EntityFlowProperties setMainParticleSize(float mainParticleSize) {
            this.mainParticleSize = mainParticleSize;
            return this;
        }

        public EntityFlowProperties setSurroundingParticleSize(float surroundingParticleSize) {
            this.surroundingParticleSize = surroundingParticleSize;
            return this;
        }

        public EntityFlowProperties setSurroundingDistance(float surroundingDistance) {
            this.surroundingDistance = surroundingDistance;
            return this;
        }

        public EntityFlowProperties setLivingTicks(int livingTicks) {
            this.livingTicks = livingTicks;
            return this;
        }
    }
}

