/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.items.baubles;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import makeo.gadomancy.common.data.DataFamiliar;
import makeo.gadomancy.common.data.SyncDataHolder;
import makeo.gadomancy.common.familiar.FamiliarAugment;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.utils.MiscUtils;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.research.ResearchManager;

public class ItemEtherealFamiliar
extends Item
implements IBauble {
    public ItemEtherealFamiliar() {
        this.func_77655_b("ItemEtherealFamiliar");
        this.func_77625_d(1);
        this.func_77664_n();
        this.func_77637_a(RegisteredItems.creativeTab);
        this.func_111206_d("gadomancy:category_icon");
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        ItemStack stack = new ItemStack(item);
        ItemEtherealFamiliar.setFamiliarAspect(stack, Aspect.MAGIC);
        list.add(stack);
        stack = new ItemStack(item);
        ItemEtherealFamiliar.setFamiliarAspect(stack, Aspect.FIRE);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.FIRE, 3);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.DAMAGE_INCREASE, 3);
        list.add(stack);
        stack = new ItemStack(item);
        ItemEtherealFamiliar.setFamiliarAspect(stack, Aspect.WEATHER);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.SHOCK, 3);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.ATTACK_SPEED, 2);
        list.add(stack);
        stack = new ItemStack(item);
        ItemEtherealFamiliar.setFamiliarAspect(stack, Aspect.POISON);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.POISON, 3);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.ATTACK_SPEED, 2);
        list.add(stack);
        stack = new ItemStack(item);
        ItemEtherealFamiliar.setFamiliarAspect(stack, Aspect.WEAPON);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.WEAKNESS, 3);
        ItemEtherealFamiliar.addAugmentUnsafe(stack, FamiliarAugment.RANGE_INCREASE, 2);
        list.add(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lore, boolean flag) {
        ArrayList<String> newLore = new ArrayList<String>();
        if (ItemEtherealFamiliar.hasFamiliarAspect(stack)) {
            newLore.add(EnumChatFormatting.GRAY + ItemEtherealFamiliar.getFamiliarAspect(stack).getName());
        }
        FamiliarAugment.FamiliarAugmentList augments = ItemEtherealFamiliar.getAugments(stack);
        for (FamiliarAugment.FamiliarAugmentPair pair : augments) {
            newLore.add(EnumChatFormatting.GRAY + pair.augment.getLocalizedName() + " " + MiscUtils.toRomanNumeral(pair.level));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            lore.addAll(newLore);
        } else if (!newLore.isEmpty()) {
            lore.add(EnumChatFormatting.DARK_GRAY + "" + EnumChatFormatting.ITALIC + StatCollector.func_74838_a((String)"gadomancy.lore.hasAdditionalLore"));
        }
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return RegisteredItems.raritySacred;
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.AMULET;
    }

    public static boolean hasFamiliarAspect(ItemStack stack) {
        return ItemEtherealFamiliar.getFamiliarAspect(stack) != null;
    }

    public static void setFamiliarAspect(ItemStack stack, Aspect aspect) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemEtherealFamiliar)) {
            return;
        }
        NBTHelper.getData(stack).func_74778_a("aspect", aspect.getTag());
    }

    public static Aspect getFamiliarAspect(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemEtherealFamiliar)) {
            return null;
        }
        String tag = NBTHelper.getData(stack).func_74779_i("aspect");
        if (tag == null || tag.equalsIgnoreCase("")) {
            return null;
        }
        return Aspect.getAspect((String)tag);
    }

    public static boolean hasAugment(ItemStack stack, FamiliarAugment augment) {
        FamiliarAugment.FamiliarAugmentList pairs = ItemEtherealFamiliar.getAugments(stack);
        for (FamiliarAugment.FamiliarAugmentPair pair : pairs) {
            if (!pair.augment.equals(augment)) continue;
            return true;
        }
        return false;
    }

    public static FamiliarAugment.FamiliarAugmentList getAugments(ItemStack stack) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemEtherealFamiliar)) {
            return new FamiliarAugment.FamiliarAugmentList();
        }
        NBTTagCompound augmentTag = NBTHelper.getData(stack).func_74775_l("augments");
        Set strKeySet = augmentTag.func_150296_c();
        if (strKeySet == null || strKeySet.size() <= 0) {
            return new FamiliarAugment.FamiliarAugmentList();
        }
        FamiliarAugment.FamiliarAugmentList augmentList = new FamiliarAugment.FamiliarAugmentList();
        for (String key : strKeySet) {
            FamiliarAugment augment = FamiliarAugment.getByUnlocalizedName(key);
            int level = augmentTag.func_74762_e(key);
            augmentList.add(new FamiliarAugment.FamiliarAugmentPair(augment, level));
        }
        return augmentList;
    }

    public static boolean incrementAugmentLevel(ItemStack stack, FamiliarAugment toAdd) {
        if (!ItemEtherealFamiliar.hasAugment(stack, toAdd)) {
            return ItemEtherealFamiliar.addAugmentUnsafe(stack, toAdd, 1);
        }
        int current = ItemEtherealFamiliar.getAugments(stack).getLevel(toAdd);
        return ItemEtherealFamiliar.addAugmentUnsafe(stack, toAdd, current + 1);
    }

    public static boolean addAugmentUnsafe(ItemStack stack, FamiliarAugment augment, int level) {
        if (stack == null || !(stack.func_77973_b() instanceof ItemEtherealFamiliar) || level <= 0) {
            return false;
        }
        NBTTagCompound tag = NBTHelper.getData(stack);
        NBTTagCompound augmentTag = NBTHelper.getData(stack).func_74775_l("augments");
        augmentTag.func_74768_a(augment.getUnlocalizedName(), level);
        tag.func_74782_a("augments", (NBTBase)augmentTag);
        return true;
    }

    public void onWornTick(ItemStack itemStack, EntityLivingBase entity) {
        if (itemStack == null) {
            return;
        }
        if (entity instanceof EntityPlayer && itemStack.func_77973_b() instanceof ItemEtherealFamiliar) {
            DataFamiliar familiarData = (DataFamiliar)SyncDataHolder.getDataServer("FamiliarData");
            Aspect a = ItemEtherealFamiliar.getFamiliarAspect(itemStack);
            if (a != null) {
                familiarData.equipTick(((EntityPlayer)entity).field_70170_p, (EntityPlayer)entity, a);
            }
        }
    }

    public void onEquipped(ItemStack itemStack, EntityLivingBase entity) {
        if (itemStack == null) {
            return;
        }
        if (entity instanceof EntityPlayer && itemStack.func_77973_b() instanceof ItemEtherealFamiliar) {
            DataFamiliar familiarData = (DataFamiliar)SyncDataHolder.getDataServer("FamiliarData");
            Aspect a = ItemEtherealFamiliar.getFamiliarAspect(itemStack);
            if (a != null) {
                familiarData.handleEquip(((EntityPlayer)entity).field_70170_p, (EntityPlayer)entity, a);
            }
        }
    }

    public void onUnequipped(ItemStack itemStack, EntityLivingBase entity) {
        if (itemStack == null) {
            return;
        }
        if (entity instanceof EntityPlayer && itemStack.func_77973_b() instanceof ItemEtherealFamiliar) {
            DataFamiliar familiarData = (DataFamiliar)SyncDataHolder.getDataServer("FamiliarData");
            Aspect a = ItemEtherealFamiliar.getFamiliarAspect(itemStack);
            if (a != null) {
                familiarData.handleUnequip(((EntityPlayer)entity).field_70170_p, (EntityPlayer)entity, a);
            }
        }
    }

    public boolean canEquip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        if (!(entityLivingBase instanceof EntityPlayer)) {
            return false;
        }
        return ResearchManager.isResearchComplete((String)entityLivingBase.func_70005_c_(), (String)("gadomancy".toUpperCase() + ".ETHEREAL_FAMILIAR"));
    }

    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }
}

