/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.utils.world.fake;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.utils.world.fake.FakeWorld;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.entities.EntityPermanentItem;
import thaumcraft.common.entities.monster.EntityEldritchGuardian;

public class FakeWorldTCGeneration
extends FakeWorld {
    public ChunkMap chunks = new ChunkMap();
    public List<Object> bufferedEntities = new ArrayList<Object>();
    public Map<ChunkCoordinates, TileEntity> gettedTE = new HashMap<ChunkCoordinates, TileEntity>();
    public int blockCount;
    public int blockOverwriteCount;

    public FakeWorldTCGeneration() {
        super(TCFakeWorldProvider.instance);
    }

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int flags) {
        if (block == ConfigBlocks.blockEldritchPortal) {
            return true;
        }
        if (block == ConfigBlocks.blockEldritch && (meta == 1 || meta == 2 || meta == 3)) {
            return true;
        }
        ++this.blockCount;
        long chKey = (long)x >> 4 | (long)z >> 4 << 32;
        ChunkBuffer buf = this.chunks.get(chKey);
        int keyX = (x & 0xF) << 7 << 4;
        int keyZ = (z & 0xF) << 7;
        int key = keyX | keyZ | y;
        if (buf.blockData[key] != null) {
            ++this.blockOverwriteCount;
            ChunkCoordinates cc = new ChunkCoordinates(x, y, z);
            this.gettedTE.remove(cc);
        }
        buf.blockData[key] = block;
        buf.metaBuffer[key] = (byte)meta;
        if (block.hasTileEntity(meta)) {
            buf.tiles.add(new Integer[]{x, y, z, key});
        }
        return true;
    }

    public boolean func_72921_c(int x, int y, int z, int metadata, int flags) {
        long chKey = (long)x >> 4 | (long)z >> 4 << 32;
        ChunkBuffer buf = this.chunks.get(chKey);
        int keyX = (x & 0xF) << 7 << 4;
        int keyZ = (z & 0xF) << 7;
        int key = keyX | keyZ | y;
        buf.metaBuffer[key] = (byte)metadata;
        return true;
    }

    @Override
    public Block func_147439_a(int x, int y, int z) {
        long chKey = (long)x >> 4 | (long)z >> 4 << 32;
        ChunkBuffer buf = this.chunks.get(chKey);
        int keyX = (x & 0xF) << 7 << 4;
        int keyZ = (z & 0xF) << 7;
        int key = keyX | keyZ | y;
        Block b = buf.blockData[key];
        return b == null ? Blocks.field_150350_a : b;
    }

    @Override
    public int func_72805_g(int x, int y, int z) {
        long chKey = (long)x >> 4 | (long)z >> 4 << 32;
        ChunkBuffer buf = this.chunks.get(chKey);
        int keyX = (x & 0xF) << 7 << 4;
        int keyZ = (z & 0xF) << 7;
        int key = keyX | keyZ | y;
        return buf.metaBuffer[key];
    }

    public boolean func_72937_j(int p_72937_1_, int p_72937_2_, int p_72937_3_) {
        return false;
    }

    protected boolean func_72916_c(int p_72916_1_, int p_72916_2_) {
        return true;
    }

    public Chunk func_72964_e(int x, int z) {
        long key = (long)x | (long)z << 32;
        return new FakeChunk(this, x, z, this.chunks.get(key));
    }

    public int func_72972_b(EnumSkyBlock type, int x, int y, int z) {
        if (type == EnumSkyBlock.Block) {
            ChunkBuffer buf = this.chunks.get((long)x >> 4 | (long)z >> 4 << 32);
            int keyX = (x & 0xF) << 7 << 4;
            int keyZ = (z & 0xF) << 7;
            int key = keyX | keyZ | y;
            return buf.lightData[key];
        }
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z) == Blocks.field_150350_a;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side) {
        return this.func_147439_a(x, y, z).isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    public Chunk func_72938_d(int p_72938_1_, int p_72938_2_) {
        return new Chunk((World)this, 0, 0);
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        TileEntity te = this.func_147439_a(x, y, z).createTileEntity(null, this.func_72805_g(x, y, z));
        if (te == null) {
            return null;
        }
        ChunkCoordinates cc = new ChunkCoordinates(x, y, z);
        if (!this.gettedTE.containsKey(cc)) {
            this.gettedTE.put(cc, te);
        }
        te.func_145834_a((World)this);
        te.field_145851_c = x;
        te.field_145848_d = y;
        te.field_145849_e = z;
        return te;
    }

    public void func_147476_b(int p_147476_1_, int p_147476_2_, int p_147476_3_, TileEntity p_147476_4_) {
    }

    public void func_147453_f(int p_147453_1_, int p_147453_2_, int p_147453_3_, Block p_147453_4_) {
    }

    public boolean func_72838_d(Entity entity) {
        if (entity instanceof EntityPermanentItem) {
            this.bufferedEntities.add(new EntityPermItem(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ((EntityPermanentItem)entity).func_92059_d()));
        } else if (entity instanceof EntityEldritchGuardian) {
            this.bufferedEntities.add(new EntityGuardianBuf(((EntityEldritchGuardian)entity).func_110172_bL(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, ((EntityEldritchGuardian)entity).func_110174_bM()));
        }
        return true;
    }

    public float func_147462_b(double p_147462_1_, double p_147462_3_, double p_147462_5_) {
        return 0.0f;
    }

    public int func_72976_f(int p_72976_1_, int p_72976_2_) {
        return 0;
    }

    public void func_147444_c(int p_147444_1_, int p_147444_2_, int p_147444_3_, Block p_147444_4_) {
    }

    public static class TCFakeWorldProvider
    extends WorldProvider {
        private static TCFakeWorldProvider instance = new TCFakeWorldProvider();

        public String func_80007_l() {
            return "FAKEWORLD-TC";
        }

        static {
            TCFakeWorldProvider.instance.field_76574_g = ModConfig.dimOuterId;
            TCFakeWorldProvider.instance.field_76576_e = true;
        }
    }

    public static class ChunkMap
    extends HashMap<Long, ChunkBuffer> {
        @Override
        public ChunkBuffer get(Object key) {
            if (!this.containsKey(key)) {
                this.put((Long)key, new ChunkBuffer((Long)key));
            }
            return (ChunkBuffer)super.get(key);
        }
    }

    public static class ChunkBuffer {
        private long key;
        public Block[] blockData = new Block[32768];
        public byte[] metaBuffer = new byte[32768];
        public List<Integer[]> tiles = new ArrayList<Integer[]>();
        public int[] lightData = new int[32768];

        public ChunkBuffer(long key) {
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChunkBuffer that = (ChunkBuffer)o;
            return this.key == that.key;
        }

        public int hashCode() {
            return (int)(this.key ^ this.key >>> 32);
        }
    }

    public static class EntityPermItem {
        public double x;
        public double y;
        public double z;
        public ItemStack buffItemStack;

        public EntityPermItem(double x, double y, double z, ItemStack buffItemStack) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.buffItemStack = buffItemStack;
        }
    }

    public static class EntityGuardianBuf {
        public ChunkCoordinates coordinates;
        public double x;
        public double y;
        public double z;
        public double dst;

        public EntityGuardianBuf(ChunkCoordinates coordinates, double x, double y, double z, double dst) {
            this.coordinates = coordinates;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dst = dst;
        }
    }

    private static class FakeChunk
    extends Chunk {
        private ChunkBuffer buf;

        public FakeChunk(World world, int x, int z, ChunkBuffer buf) {
            super(world, x, z);
            this.buf = buf;
        }

        public void func_76633_a(EnumSkyBlock type, int x, int y, int z, int light) {
            if (type == EnumSkyBlock.Block) {
                int key = ((x & 0xF) << 4 | z & 0xF) << 7 | y;
                this.buf.lightData[key] = light;
            }
        }
    }
}

