/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.registration;

import java.lang.reflect.Field;
import makeo.gadomancy.common.data.config.ModConfig;
import makeo.gadomancy.common.enchantments.EnchantmentRevealer;
import makeo.gadomancy.common.utils.Injector;
import net.minecraft.enchantment.Enchantment;

public class RegisteredEnchantments {
    public static EnchantmentRevealer revealer;

    public static void init() {
        revealer = RegisteredEnchantments.registerEnchantment(EnchantmentRevealer.class);
    }

    public static void createConfigEntries() {
        for (Field field : RegisteredEnchantments.class.getFields()) {
            if (!Enchantment.class.isAssignableFrom(field.getType())) continue;
            ModConfig.loadEnchantmentId(field.getType().getSimpleName());
        }
    }

    public static <T extends Enchantment> T registerEnchantment(Class<T> enchClass) {
        int id = ModConfig.loadEnchantmentId(enchClass.getSimpleName());
        if (id == -1) {
            id = RegisteredEnchantments.getUnassignedId(enchClass);
        }
        return (T)((Enchantment)new Injector(enchClass).invokeConstructor(Integer.TYPE, (Object)id));
    }

    private static int getUnassignedId(Class<? extends Enchantment> enchClass) {
        for (int i = 0; i < Enchantment.field_77331_b.length; ++i) {
            if (Enchantment.field_77331_b[i] != null) continue;
            return i;
        }
        throw new RuntimeException("Failed to find free id for Gadomancy enchantment (" + enchClass.getName() + ")! Please consider using the config option to change the enchantment id.");
    }
}

