/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.DayMonth;
import forestry.core.utils.StringUtil;
import java.util.Calendar;
import net.minecraft.world.World;

public class MutationConditionTimeLimited
implements IMutationCondition {
    private final DayMonth start;
    private final DayMonth end;

    public MutationConditionTimeLimited(int startMonth, int startDay, int endMonth, int endDay) {
        this.start = new DayMonth(startDay, startMonth);
        this.end = new DayMonth(endDay, endMonth);
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        DayMonth now = new DayMonth();
        if (Calendar.getInstance().get(5) == this.start.day && Calendar.getInstance().get(2) + 1 == this.start.month) {
            return 1.0f;
        }
        if (Calendar.getInstance().get(5) == this.end.day && Calendar.getInstance().get(2) + 1 == this.end.month) {
            return 1.0f;
        }
        if (now.between(this.start, this.end)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("mutation.condition.date").replace("%START", this.start.toString()).replace("%END", this.end.toString());
    }
}

