/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.StringUtil;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MutationConditionRequiresResource
implements IMutationCondition {
    private final ItemStack blockRequired;

    public MutationConditionRequiresResource(Block block, int meta) {
        this.blockRequired = new ItemStack(block, 1, meta);
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1) {
        ItemStack stk = BlockUtil.getItemStackFromBlockBelow(world, x, y, z, tile -> tile instanceof IBeeHousing);
        return InventoryUtil.isItemEqual(this.blockRequired, stk, true, true) ? 1.0f : 0.0f;
    }

    @Override
    public String getDescription() {
        return StringUtil.localizeAndFormat("mutation.condition.resource", this.blockRequired.func_82833_r());
    }
}

