/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.service.blockfinder.BlockFoundResponse;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import com.gtnh.findit.service.itemfinder.ItemFoundResponse;
import com.gtnh.findit.util.WorldUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFindService {
    public ItemFindService() {
        FindItNetwork.registerMessage(FindItemRequest.Handler.class, FindItemRequest.class, Side.SERVER);
        FindItNetwork.registerMessage(ItemFoundResponse.Handler.class, ItemFoundResponse.class, Side.CLIENT);
    }

    public void handleRequest(EntityPlayerMP player, FindItemRequest request) {
        if (FindIt.getCooldownService().checkSearchCooldown(player)) {
            return;
        }
        ArrayList<ChunkPosition> positions = new ArrayList<ChunkPosition>();
        for (TileEntity tileEntity : WorldUtils.getTileEntitiesAround((Entity)player, FindItConfig.SEARCH_RADIUS)) {
            try {
                if (!(tileEntity instanceof IInventory) || !this.findItemInInventory((IInventory)tileEntity, request)) continue;
                positions.add(new ChunkPosition(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e));
                if (positions.size() != FindItConfig.MAX_RESPONSE_SIZE) continue;
                break;
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        FindItNetwork.CHANNEL.sendTo((IMessage)new BlockFoundResponse(positions), player);
        FindItNetwork.CHANNEL.sendTo((IMessage)new ItemFoundResponse(request.getStackToFind()), player);
    }

    private boolean findItemInInventory(IInventory inventory, FindItemRequest request) {
        if (request.hasFluidStack() && inventory instanceof IFluidHandler) {
            FluidTankInfo[] tankInfo;
            for (FluidTankInfo info : tankInfo = ((IFluidHandler)inventory).getTankInfo(ForgeDirection.UNKNOWN)) {
                if (!request.equals(info.fluid)) continue;
                return true;
            }
        }
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            if (!request.equals(inventory.func_70301_a(slot))) continue;
            return true;
        }
        return false;
    }
}

