/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.modintegration;

import com.rwtema.extrautils.modintegration.TConTextureResourcePackBase;
import java.awt.image.BufferedImage;

public class TConTextureResourcePackUnstableIngot
extends TConTextureResourcePackBase {
    public TConTextureResourcePackUnstableIngot(String name) {
        super(name);
    }

    @Override
    public BufferedImage modifyImage(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        boolean[][] trans = new boolean[width][height];
        boolean[][] edge = new boolean[width][height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int c;
                if (x == 0 || y == 0 || x == width - 1 || y == height - 1) {
                    edge[x][y] = true;
                }
                if ((c = image.getRGB(x, y)) != 0 && rgb.getAlpha(c) >= 64) continue;
                trans[x][y] = true;
                if (x > 0) {
                    edge[x - 1][y] = true;
                }
                if (y > 0) {
                    edge[x][y - 1] = true;
                }
                if (x < width - 1) {
                    edge[x + 1][y] = true;
                }
                if (y >= height - 1) continue;
                edge[x][y + 1] = true;
            }
        }
        int white = -1;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (trans[x][y]) continue;
                int c = image.getRGB(x, y);
                int lum = this.brightness(rgb.getRed(c), rgb.getGreen(c), rgb.getBlue(c));
                if (edge[x][y]) {
                    int alpha = 255;
                    lum = 256 + (x * 16 / width + y * 16 / height - 16) * 6;
                    if (lum >= 256) {
                        lum = 255 - (lum - 256);
                    }
                    int col = alpha << 24 | lum << 16 | lum << 8 | lum;
                    image.setRGB(x, y, col);
                    continue;
                }
                image.setRGB(x, y, 0);
            }
        }
        return image;
    }
}

