/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.configuration;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigEnchantsPotions;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigExperiments;
import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.configuration.configs.ConfigWorld;
import ganymedes01.etfuturum.mixinplugin.EtFuturumEarlyMixins;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.spongepowered.asm.mixin.MixinEnvironment;

public abstract class ConfigBase
extends Configuration {
    protected final List<ConfigCategory> configCats = new ArrayList<ConfigCategory>();
    private static final Set<ConfigBase> CONFIGS = new HashSet<ConfigBase>();
    public static final String configDir = "config" + File.separator + "etfuturum" + File.separator;
    public static final ConfigBase EXPERIMENTS = new ConfigExperiments(ConfigBase.createConfigFile("experiments"));
    public static final ConfigBase BLOCKS_ITEMS = new ConfigBlocksItems(ConfigBase.createConfigFile("blocksitems"));
    public static final ConfigBase ENCHANTS_POTIONS = new ConfigEnchantsPotions(ConfigBase.createConfigFile("enchantspotions"));
    public static final ConfigBase FUNCTIONS = new ConfigFunctions(ConfigBase.createConfigFile("functions"));
    public static final ConfigBase TWEAKS = new ConfigTweaks(ConfigBase.createConfigFile("tweaks"));
    public static final ConfigBase WORLD = new ConfigWorld(ConfigBase.createConfigFile("world"));
    public static final ConfigBase ENTITIES = new ConfigEntities(ConfigBase.createConfigFile("entities"));
    public static final ConfigBase SOUNDS = new ConfigSounds(ConfigBase.createConfigFile("sounds"));
    public static final ConfigBase MOD_COMPAT = new ConfigModCompat(ConfigBase.createConfigFile("modcompat"));
    public static final ConfigBase MIXINS = new ConfigMixins(ConfigBase.createConfigFile("mixins"));

    public ConfigBase(File file) {
        super(file);
        CONFIGS.add(this);
    }

    private static File createConfigFile(String name) {
        return new File(Launch.minecraftHome, configDir + name + ".cfg");
    }

    public static void initializeConfigs() {
        for (ConfigBase config : CONFIGS) {
            config.syncConfig();
        }
    }

    private void syncConfig() {
        this.syncConfigOptions();
        for (ConfigCategory cat : this.configCats) {
            if (EtFuturumEarlyMixins.side == MixinEnvironment.Side.SERVER && cat.getName().toLowerCase().contains("client")) {
                for (Property prop : cat.getOrderedValues()) {
                    cat.remove((Object)prop.getName());
                }
            }
            if (!cat.isEmpty() || cat.getName().toLowerCase().contains("experiment")) continue;
            this.removeCategory(cat);
        }
        if (this.hasChanged()) {
            this.save();
        }
    }

    protected abstract void syncConfigOptions();

    protected void initValues() {
    }

    public static void postInit() {
        for (ConfigBase config : CONFIGS) {
            config.initValues();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("etfuturum".equals(eventArgs.modID)) {
            this.syncConfig();
        }
    }
}

