/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.structurenbt;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import ganymedes01.etfuturum.EtFuturum;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.structurenbt.BlockStateContainer;
import ganymedes01.etfuturum.core.utils.structurenbt.BlockStateConverter;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockSign;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class NBTStructure {
    private final NBTTagCompound compound;
    private final Map<Integer, BlockStateContainer>[][] palettes;
    private final Map<BlockPos, BlockStateContainer>[][] buildMaps;
    private final BlockPos[] sizes;
    private final String location;
    protected final BlockStateConverter converter;

    public NBTStructure(String loc) {
        this(loc, BlockStateConverter.DEFAULT_INSTANCE);
    }

    public NBTStructure(String loc, BlockStateConverter converter) {
        this.converter = converter;
        try {
            InputStream file = EtFuturum.class.getResourceAsStream(loc);
            this.compound = CompressedStreamTools.func_74796_a((InputStream)file);
            file.close();
        }
        catch (Exception e) {
            Logger.error("Failed to find or read structure NBT file for " + loc);
            throw new RuntimeException(e);
        }
        this.buildMaps = new Map[this.getPaletteCount()][4];
        this.palettes = new Map[this.getPaletteCount()][4];
        this.location = loc;
        BlockPos size = NBTStructure.getPosFromTagList(this.compound.func_150295_c("size", 3));
        this.sizes = new BlockPos[]{size, new BlockPos(size.getZ(), size.getY(), size.getX())};
        this.init();
        this.createPalettes();
        this.createBuildMaps();
    }

    private void createPalettes() {
        for (int i = 0; i < this.getPaletteCount(); ++i) {
            this.palettes[i][0] = this.createPalette(ForgeDirection.NORTH, this.getPaletteNBT(i));
            this.palettes[i][1] = this.createPalette(ForgeDirection.SOUTH, this.getPaletteNBT(i));
            this.palettes[i][2] = this.createPalette(ForgeDirection.WEST, this.getPaletteNBT(i));
            this.palettes[i][3] = this.createPalette(ForgeDirection.EAST, this.getPaletteNBT(i));
        }
    }

    private void createBuildMaps() {
        for (int facing = 0; facing < 4; ++facing) {
            for (int j = 0; j < this.getPaletteCount(); ++j) {
                BlockStateContainer state;
                HashMap<BlockPos, BlockStateContainer> map = new HashMap<BlockPos, BlockStateContainer>();
                HashMap<BlockPos, String> structureBlocks = new HashMap<BlockPos, String>();
                NBTTagList list = this.getCompound().func_150295_c("blocks", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    NBTTagCompound comp = list.func_150305_b(i);
                    BlockPos pos = this.getListPosFromFacing(comp, facing);
                    state = this.getBuildPalettes()[j][facing].get(comp.func_74762_e("state"));
                    boolean isStructureBlock = false;
                    if (comp.func_150297_b("nbt", 10)) {
                        if (comp.func_74775_l("nbt").func_74779_i("id").equals("minecraft:structure_block")) {
                            isStructureBlock = true;
                            structureBlocks.put(pos, comp.func_74775_l("nbt").func_74779_i("metadata"));
                        } else if (state.getType() == BlockStateContainer.BlockStateType.BLOCK_ENTITY) {
                            this.getNBTAction(pos, state, comp.func_74775_l("nbt"), this.getFacingFromInt(facing));
                        }
                    }
                    if (isStructureBlock) continue;
                    map.put(pos, state);
                }
                for (Map.Entry entry : structureBlocks.entrySet()) {
                    BlockStateContainer belowState;
                    BlockStateContainer blockStateContainer = belowState = ((BlockPos)entry.getKey()).getY() <= 0 ? null : (BlockStateContainer)map.get(((BlockPos)entry.getKey()).down());
                    state = this.setStructureBlockAction((BlockPos)entry.getKey(), belowState, (String)entry.getValue(), this.getFacingFromInt(facing));
                    if (state == null) continue;
                    map.put((BlockPos)entry.getKey(), state);
                }
                this.buildMaps[j][facing] = map;
            }
        }
    }

    public void getNBTAction(BlockPos pos, BlockStateContainer state, NBTTagCompound modernCompound, ForgeDirection facing) {
        if (state.getBlock() instanceof BlockSign) {
            NBTTagCompound signText = new NBTTagCompound();
            if (modernCompound.func_74764_b("front_text")) {
                NBTTagCompound frontTextCompound = modernCompound.func_74775_l("front_text");
                if (frontTextCompound.func_74764_b("messages")) {
                    NBTTagList list = frontTextCompound.func_150295_c("messages", 8);
                    for (int i = 0; i < 4; ++i) {
                        signText.func_74778_a("Text" + (i + 1), this.getJsonTextValue(list.func_150307_f(i)));
                    }
                    state.setCompound(signText);
                }
            } else if (modernCompound.func_74764_b("Text1") && modernCompound.func_74764_b("Text2") && modernCompound.func_74764_b("Text3") && modernCompound.func_74764_b("Text4")) {
                for (int i = 1; i <= 4; ++i) {
                    signText.func_74778_a("Text" + i, this.getJsonTextValue(modernCompound.func_74779_i("Text" + i)));
                }
                state.setCompound(signText);
            }
        }
    }

    protected String getJsonTextValue(String jsonComponent) {
        try {
            return ((JsonObject)new Gson().fromJson(jsonComponent, JsonObject.class)).get("text").getAsString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public BlockStateContainer setStructureBlockAction(BlockPos pos, BlockStateContainer below, String data, ForgeDirection facing) {
        return new BlockStateContainer(Blocks.field_150350_a);
    }

    private BlockPos getListPosFromFacing(NBTTagCompound comp, int facing) {
        BlockPos size = this.getSize(this.getFacingFromInt(facing));
        BlockPos pos = NBTStructure.getPosFromTagList(comp.func_150295_c("pos", 3));
        if (facing == 1) {
            pos = new BlockPos(size.getX() - pos.getX(), pos.getY(), size.getZ() - pos.getZ());
        } else if (facing == 2) {
            pos = new BlockPos(pos.getZ(), pos.getY(), pos.getX());
        } else if (facing == 3) {
            pos = new BlockPos(size.getX() - pos.getZ(), pos.getY(), size.getZ() - pos.getX());
        }
        return pos;
    }

    public final NBTTagCompound getCompound() {
        return this.compound;
    }

    public final Map<Integer, BlockStateContainer>[][] getBuildPalettes() {
        return this.palettes;
    }

    public final boolean placeStructure(World world, Random rand, int x, int y, int z, float integrity) {
        return this.placeStructure(world, rand, x, y, z, this.getFacingFromInt(rand.nextInt(4)), integrity, rand.nextInt(this.getPaletteCount()));
    }

    public final boolean placeStructure(World world, Random rand, int x, int y, int z) {
        return this.placeStructure(world, rand, x, y, z, this.getFacingFromInt(rand.nextInt(4)));
    }

    public final boolean placeStructure(World world, Random rand, int x, int y, int z, ForgeDirection facing) {
        return this.placeStructure(world, rand, x, y, z, facing, 1.0f, rand.nextInt(this.getPaletteCount()));
    }

    public final boolean placeStructure(World world, Random rand, int x, int y, int z, ForgeDirection facing, float integrity) {
        return this.placeStructure(world, rand, x, y, z, facing, integrity, rand.nextInt(this.getPaletteCount()));
    }

    public final boolean placeStructure(World world, Random rand, int x, int y, int z, ForgeDirection facing, float integrity, int paletteIndex) {
        return this.placeStructure(world, rand, x, y, z, facing, integrity, paletteIndex, null);
    }

    public final boolean placeStructure(World world, Random rand, int x, int y, int z, ForgeDirection facing, float integrity, int paletteIndex, StructureBoundingBox box) {
        BlockPos pos;
        Map<BlockPos, BlockStateContainer> blockSet = this.buildMaps[paletteIndex][this.getIntFromFacing(facing)];
        HashMap<BlockPos, BlockStateContainer> entitySet = new HashMap<BlockPos, BlockStateContainer>();
        for (Map.Entry<BlockPos, BlockStateContainer> entry : blockSet.entrySet()) {
            if (entry.getValue().getType() == BlockStateContainer.BlockStateType.ENTITY) {
                entitySet.put(entry.getKey(), entry.getValue());
                continue;
            }
            pos = entry.getKey();
            if (box != null && !box.func_78890_b(pos.getX() + x, pos.getY() + y, pos.getZ() + z)) continue;
            this.setBlockState(world, rand, pos.getX() + x, pos.getY() + y, pos.getZ() + z, entry.getValue(), integrity);
        }
        for (Map.Entry<BlockPos, BlockStateContainer> entry : entitySet.entrySet()) {
            pos = entry.getKey();
            if (box != null && !box.func_78890_b(pos.getX() + x, pos.getY() + y, pos.getZ() + z)) continue;
            Entity entity = entry.getValue().createNewEntity(world);
            entity.func_70020_e(entry.getValue().getCompound());
            this.onEntityCreated(entity, entry.getValue().getCompound(), x, y, z, pos, facing);
            world.func_72838_d(entity);
        }
        return true;
    }

    protected final void onEntityCreated(Entity entity, NBTTagCompound containerCompound, int x, int y, int z, BlockPos offsetPos, ForgeDirection dir) {
        entity.func_70107_b((double)(offsetPos.getX() + x) + 0.5, (double)(offsetPos.getY() + y), (double)(offsetPos.getZ() + z) + 0.5);
        if (entity instanceof EntityHanging) {
            ForgeDirection hangingDir = this.converter.getItemFrameDirFromRotation(((EntityHanging)entity).field_82332_a);
            ((EntityHanging)entity).field_146063_b = MathHelper.func_76128_c((double)(offsetPos.getX() + x)) + hangingDir.offsetX;
            ((EntityHanging)entity).field_146064_c = MathHelper.func_76128_c((double)(offsetPos.getY() + y));
            ((EntityHanging)entity).field_146062_d = MathHelper.func_76128_c((double)(offsetPos.getZ() + z)) + hangingDir.offsetZ;
        }
    }

    protected void setBlockState(World world, Random rand, int x, int y, int z, BlockStateContainer state, float integrity) {
        BlockStateContainer newState;
        if ((integrity >= 1.0f || 0.0f < integrity && rand.nextFloat() <= integrity) && (newState = this.getBlockStateContainer(world, rand, x, y, z, state)) != null) {
            TileEntity te;
            world.func_147465_d(x, y, z, state.getBlock(), state.getMeta(), 2);
            if (state.getType() == BlockStateContainer.BlockStateType.BLOCK_ENTITY && (te = world.func_147438_o(x, y, z)) != null) {
                NBTTagCompound nbt = state.getCompound() != null ? state.getCompound() : new NBTTagCompound();
                nbt.func_74768_a("x", x);
                nbt.func_74768_a("y", y);
                nbt.func_74768_a("z", z);
                te.field_145854_h = state.getBlock();
                te.field_145847_g = state.getMeta();
                te.func_145839_a(this.getTileEntityNBTPostPlace(world, rand, x, y, z, state, integrity, nbt));
                te.func_70296_d();
                if (te instanceof IInventory && state.getLootTable() != null) {
                    WeightedRandomChestContent.func_76293_a((Random)world.field_73012_v, (WeightedRandomChestContent[])state.getLootTable().getItems(world.field_73012_v), (IInventory)((IInventory)te), (int)state.getLootTable().getCount(world.field_73012_v));
                }
            }
        }
    }

    protected NBTTagCompound getTileEntityNBTPostPlace(World world, Random rand, int x, int y, int z, BlockStateContainer state, float integrity, NBTTagCompound nbt) {
        return nbt;
    }

    protected BlockStateContainer getBlockStateContainer(World world, Random rand, int x, int y, int z, BlockStateContainer state) {
        return state;
    }

    public final BlockPos getSize(ForgeDirection facing) {
        if (facing.ordinal() < 2 || facing.ordinal() > 5) {
            throw new IllegalArgumentException("ForgeDirection object must be NORTH, SOUTH, EAST or WEST!");
        }
        return facing == ForgeDirection.NORTH || facing == ForgeDirection.SOUTH ? this.sizes[0] : this.sizes[1];
    }

    public final NBTTagCompound getPaletteEntryFromIndex(int paletteIndex, int entryIndex) {
        return this.getPaletteObjectFromIndex(paletteIndex).func_150305_b(entryIndex);
    }

    public final String getBlockNamespaceFromPaletteEntry(int paletteIndex, int entryIndex) {
        return NBTStructure.getBlockNamespaceFromNBT(this.getPaletteEntryFromIndex(paletteIndex, entryIndex));
    }

    public static String getBlockNamespaceFromNBT(NBTTagCompound nbt) {
        return nbt.func_74779_i("Name");
    }

    protected final boolean usesPaletteArray() {
        if (this.getCompound().func_74764_b("palettes")) {
            return true;
        }
        if (this.getCompound().func_74764_b("palette")) {
            return false;
        }
        throw new IllegalArgumentException("Input NBT structure has no palettes!");
    }

    protected final NBTTagList getPaletteObjectFromIndex(int index) {
        if (!this.usesPaletteArray()) {
            if (index == 0) {
                return this.getCompound().func_150295_c("palette", 10);
            }
            throw new IllegalArgumentException("This structure does not use a multi-palette array, so the index cannot be greater than 0");
        }
        return (NBTTagList)this.getCompound().func_150295_c((String)"palettes", (int)9).field_74747_a.get(index);
    }

    public final int getPaletteCount() {
        if (this.usesPaletteArray()) {
            return this.getCompound().func_150295_c("palettes", 9).func_74745_c();
        }
        return 1;
    }

    public final Set<Pair<Integer, NBTTagCompound>> getPaletteNBT(int paletteIndex) {
        HashSet<Pair<Integer, NBTTagCompound>> set = new HashSet<Pair<Integer, NBTTagCompound>>();
        for (int i = 0; i < this.getPaletteObjectFromIndex(paletteIndex).func_74745_c(); ++i) {
            set.add((Pair<Integer, NBTTagCompound>)new ImmutablePair((Object)i, (Object)this.getPaletteEntryFromIndex(paletteIndex, i)));
        }
        return set;
    }

    public final Map<String, String> getPropertiesFromIndex(int paletteIndex, int entryIndex) {
        return NBTStructure.getProperties(this.getPaletteEntryFromIndex(paletteIndex, entryIndex));
    }

    public static Map<String, String> getProperties(NBTTagCompound compound) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry props : compound.func_74775_l((String)"Properties").field_74784_a.entrySet()) {
            if (((NBTBase)props.getValue()).func_74732_a() != 8) continue;
            map.put((String)props.getKey(), ((NBTTagString)props.getValue()).func_150285_a_());
        }
        return map;
    }

    public final String getBlockIDFromPalette(int paletteIndex, int entryIndex) {
        return this.getPaletteEntryFromIndex(paletteIndex, entryIndex).func_74779_i("Name");
    }

    public static String getBlockProperty(NBTTagCompound nbt, String property) {
        if (!nbt.func_74764_b("properties")) {
            return null;
        }
        return nbt.func_74775_l("properties").func_74779_i(property);
    }

    public static BlockPos getPosFromTagList(NBTTagList list) {
        if (list.func_74745_c() != 3 && list.func_74732_a() != 3) {
            throw new IllegalArgumentException("This is not a BlockPos taglist!");
        }
        return new BlockPos(NBTStructure.getIntFromTagList(list, 0), NBTStructure.getIntFromTagList(list, 1), NBTStructure.getIntFromTagList(list, 2));
    }

    protected static int getIntFromTagList(NBTTagList list, int index) {
        if (index >= 0 && index < list.func_74745_c()) {
            NBTBase nbtbase = (NBTBase)list.field_74747_a.get(index);
            return nbtbase.func_74732_a() == 3 ? ((NBTTagInt)nbtbase).func_150287_d() : 0;
        }
        return 0;
    }

    public final ForgeDirection getFacingFromInt(int i) {
        if (i < 0 || i > 3) {
            throw new IllegalArgumentException("Facing int must be at least 0 and at most 3!");
        }
        return ForgeDirection.VALID_DIRECTIONS[i + 2];
    }

    public final int getIntFromFacing(ForgeDirection dir) {
        if (dir.ordinal() < 2 || dir.ordinal() > 5) {
            throw new IllegalArgumentException("ForgeDirection object for structure must be NORTH, SOUTH, EAST or WEST!");
        }
        return dir.ordinal() - 2;
    }

    public final String getLocation() {
        return this.location;
    }

    protected Map<Integer, BlockStateContainer> createPalette(ForgeDirection facing, Set<Pair<Integer, NBTTagCompound>> paletteNBT) {
        return this.converter.processPalette(facing, paletteNBT);
    }

    public void init() {
    }
}

