/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api.mappings;

import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class RegistryMapping<T> {
    private static final RegistryMapping keyInstance = new RegistryMapping();
    private T object;
    private transient int meta;

    private RegistryMapping() {
        this.object = null;
        this.meta = 0;
    }

    public RegistryMapping(T obj, int meta) {
        if (!(obj instanceof Block) && !(obj instanceof Item)) {
            throw new IllegalArgumentException("RegistryMapping must be either an item or a block!");
        }
        this.setObject(obj);
        this.setMeta(meta);
    }

    public T getObject() {
        return this.object;
    }

    public int getMeta() {
        return this.meta;
    }

    public boolean equals(Object obj) {
        return obj instanceof RegistryMapping && this.object == ((RegistryMapping)obj).object && (this.meta == Short.MAX_VALUE || ((RegistryMapping)obj).meta == Short.MAX_VALUE || this.meta == ((RegistryMapping)obj).meta);
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public static <E> RegistryMapping<E> getKeyFor(E object, int meta) {
        return super.setMeta(meta);
    }

    private RegistryMapping<T> setObject(T obj) {
        this.object = obj;
        return this;
    }

    private RegistryMapping<T> setMeta(int meta) {
        this.meta = this.object instanceof Item || meta == Short.MAX_VALUE ? meta : meta & 0xF;
        return this;
    }
}

