/*
 * Decompiled with CFR 0.152.
 */
package singulariteam.eternalsingularity;

import java.util.Iterator;
import javax.annotation.Nonnull;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import singulariteam.eternalsingularity.proxy.CommonProxy;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import wanion.lib.common.MineTweakerHelper;

@ZenClass(value="mods.eternalsingularity")
public final class EternalRecipeTweaker {
    private EternalRecipeTweaker() {
    }

    public static void init() {
        MineTweakerAPI.registerClass(EternalRecipeTweaker.class);
    }

    @ZenMethod
    public static void add(@Nonnull IItemStack input) {
        ItemStack itemStack = MineTweakerHelper.toStack((IItemStack)input);
        if (itemStack != null && itemStack.func_77973_b() != null) {
            MineTweakerAPI.apply((IUndoableAction)new Add(itemStack));
        }
    }

    @ZenMethod
    public static void remove(IItemStack input) {
        ItemStack itemStack = MineTweakerHelper.toStack((IItemStack)input);
        if (itemStack != null && itemStack.func_77973_b() != null) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(itemStack));
        }
    }

    private static class Add
    implements IUndoableAction {
        private final ItemStack itemStack;

        public Add(@Nonnull ItemStack itemStack) {
            this.itemStack = itemStack;
        }

        public void apply() {
            CommonProxy.getEternalSingularityRecipe().getInput().add(this.itemStack);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CommonProxy.getEternalSingularityRecipe().getInput().remove(this.itemStack);
        }

        public String describe() {
            return "Adding " + this.itemStack.func_82833_r() + " into Eternal Singularity Recipe.";
        }

        public String describeUndo() {
            return "Removing " + this.itemStack.func_82833_r() + " from Eternal Singularity Recipe.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack itemStack;

        private Remove(@Nonnull ItemStack itemStackToRemove) {
            ItemStack itemStack = null;
            Iterator eternalSingularityRecipeIterator = CommonProxy.getEternalSingularityRecipe().getInput().iterator();
            while (eternalSingularityRecipeIterator.hasNext() && itemStack == null) {
                Object input = eternalSingularityRecipeIterator.next();
                if (!(input instanceof ItemStack) || !((ItemStack)input).func_77969_a(itemStackToRemove)) continue;
                itemStack = (ItemStack)input;
            }
            this.itemStack = itemStack;
        }

        public void apply() {
            CommonProxy.getEternalSingularityRecipe().getInput().remove(this.itemStack);
        }

        public boolean canUndo() {
            return this.itemStack != null;
        }

        public void undo() {
            CommonProxy.getEternalSingularityRecipe().getInput().add(this.itemStack);
        }

        public String describe() {
            return "Removing " + this.itemStack.func_82833_r() + " from Eternal Singularity Recipe.";
        }

        public String describeUndo() {
            return "Adding " + this.itemStack.func_82833_r() + " into Eternal Singularity Recipe.";
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

