/*
 * Decompiled with CFR 0.152.
 */
package glowredman.defaultserverlist;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.IOUtils;

public class Config {
    public static final List<ServerData> SERVERS = new ArrayList<ServerData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInit(File configDir) {
        Configuration config = new Configuration(new File(configDir, "defaultserverlist.cfg"));
        config.load();
        boolean useURL = config.get("general", "useURL", false).getBoolean();
        String url = config.get("general", "url", "").getString();
        String[] servers = config.get("general", "servers", new String[0], "Pattern: NAME;URL").getStringList();
        if (config.hasChanged()) {
            config.save();
        }
        if (useURL) {
            InputStream inputStream = null;
            try {
                inputStream = new URL(url).openStream();
                servers = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8).split("\n");
            }
            catch (Exception e) {
                try {
                    FMLLog.severe((String)"Could not parse default server list from URL!", (Object[])new Object[0]);
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        for (String s : servers) {
            String[] info = s.split(";", 2);
            if (info.length < 2) continue;
            SERVERS.add(new ServerData(info[0], info[1]));
        }
    }
}

