/*
 * Decompiled with CFR 0.152.
 */
package glowredman.defaultserverlist;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import cpw.mods.fml.common.FMLLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ServerData;
import org.apache.commons.io.IOUtils;

public class Config {
    public static ConfigObj config = new ConfigObj();
    public static final List<ServerData> SERVERS = new ArrayList<ServerData>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Path configPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInit(File configDir) {
        BufferedReader fileReader = null;
        try {
            configPath = configDir.toPath().resolve("defaultserverlist.json");
            if (!Files.exists(configPath, new LinkOption[0])) {
                Config.saveConfig(config);
            } else {
                fileReader = Files.newBufferedReader(configPath, StandardCharsets.UTF_8);
                config = (ConfigObj)GSON.fromJson((Reader)fileReader, ConfigObj.class);
            }
            if (Config.config.useURL) {
                try {
                    Map remoteDefaultServers = (Map)GSON.fromJson(IOUtils.toString((URL)new URL(Config.config.url), (Charset)StandardCharsets.UTF_8), new TypeToken<LinkedHashMap<String, String>>(){
                        private static final long serialVersionUID = -1786059589535074931L;
                    }.getType());
                    if (Config.config.allowModifications) {
                        LinkedHashMap diff = new LinkedHashMap();
                        remoteDefaultServers.forEach((name, ip) -> {
                            if (!Config.config.prevDefaultServers.contains(ip)) {
                                diff.put(name, ip);
                            }
                        });
                        if (!diff.isEmpty()) {
                            Config.config.servers.putAll(diff);
                            Config.config.prevDefaultServers = remoteDefaultServers.values();
                            Config.saveConfig(config);
                        }
                    } else {
                        Config.config.servers = remoteDefaultServers;
                        Config.saveConfig(config);
                    }
                }
                catch (Exception e) {
                    FMLLog.warning((String)"Could not get default server list from default location! Are you connected to the internet?", (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
            Config.config.servers.forEach((name, ip) -> SERVERS.add(new ServerData(name, ip)));
            IOUtils.closeQuietly((Reader)fileReader);
        }
        catch (Exception e) {
            FMLLog.severe((String)"Could not parse default server list!", (Object[])new Object[0]);
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly(fileReader);
        }
    }

    public static void saveConfig(ConfigObj config) throws IOException {
        File f = configPath.toFile();
        if (f.exists()) {
            f.delete();
        }
        Files.write(configPath, Arrays.asList(GSON.toJson((Object)config)), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static final class ConfigObj {
        public boolean useURL = false;
        public boolean allowModifications = true;
        public String url = "";
        public Map<String, String> servers = new LinkedHashMap<String, String>();
        @SerializedName(value="DO_NOT_EDIT_prevDefaultServers")
        public Collection<String> prevDefaultServers = new ArrayList<String>();

        public ConfigObj() {
        }

        public ConfigObj(Map<String, String> servers) {
            this.servers = servers;
        }
    }
}

