/*
 * Decompiled with CFR 0.152.
 */
package lumien.custommainmenu;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import lumien.custommainmenu.configuration.Config;
import lumien.custommainmenu.configuration.ConfigurationLoader;
import lumien.custommainmenu.handler.CMMEventHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="custommainmenu", name="Custom Main Menu", version="1.11.2")
public class CustomMainMenu {
    public static final String MOD_ID = "custommainmenu";
    public static final String MOD_NAME = "Custom Main Menu";
    @Mod.Instance(value="custommainmenu")
    public static CustomMainMenu INSTANCE;
    public static CMMEventHandler EVENT_HANDLER;
    private ConfigurationLoader configLoader;
    public Config config;
    public Logger logger;
    public File configFolder;
    static ResourceLocation transparentTexture;

    public static void bindTransparent() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(transparentTexture);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configFolder = event.getModConfigurationDirectory();
        this.config = new Config();
        transparentTexture = new ResourceLocation("custommainmenu:textures/gui/transparent.png");
        EVENT_HANDLER = new CMMEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)EVENT_HANDLER);
        FMLCommonHandler.instance().bus().register((Object)EVENT_HANDLER);
        this.logger = event.getModLog();
        this.configLoader = new ConfigurationLoader(this.config);
        try {
            this.configLoader.load();
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "Error while loading config file. Will have to crash here :(.");
            throw new RuntimeException(e);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("curseProjectName", "226406-custom-main-menu");
        compound.func_74778_a("curseFilenameParser", "CustomMainMenu-MC1.8-[].jar");
        compound.func_74778_a("modDisplayName", MOD_NAME);
        FMLInterModComms.sendRuntimeMessage((Object)MOD_ID, (String)"VersionChecker", (String)"addCurseCheck", (NBTTagCompound)compound);
    }

    public void reload() {
        Config backup = this.config;
        this.config = new Config();
        this.configLoader = new ConfigurationLoader(this.config);
        try {
            this.configLoader.load();
            CustomMainMenu.EVENT_HANDLER.displayMs = -1L;
        }
        catch (Exception e) {
            e.printStackTrace();
            CustomMainMenu.EVENT_HANDLER.displayMs = System.currentTimeMillis();
            this.logger.log(Level.ERROR, "Error while loading new config file, trying to keep the old one loaded.");
            this.config = backup;
        }
    }
}

