/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.packet;

import com.creativemd.creativecore.common.container.ContainerSub;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class GuiLayerPacket
extends CreativeCorePacket {
    public NBTTagCompound nbt;
    public int layer;
    public boolean closed;

    public GuiLayerPacket() {
    }

    public GuiLayerPacket(NBTTagCompound nbt, int layer, boolean closed) {
        this.nbt = nbt;
        this.layer = layer;
        this.closed = closed;
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbt);
        buf.writeInt(this.layer);
        buf.writeBoolean(this.closed);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        this.nbt = ByteBufUtils.readTag((ByteBuf)buf);
        this.layer = buf.readInt();
        this.closed = buf.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerSub) {
            if (this.closed) {
                ((ContainerSub)player.field_71070_bA).gui.getLayers().get(this.layer).closeLayer(this.nbt, true);
            } else {
                ((ContainerSub)player.field_71070_bA).gui.getLayers().get(this.layer).openNewLayer(this.nbt, true);
            }
        }
    }

    @Override
    public void executeServer(EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerSub) {
            if (this.closed) {
                ((ContainerSub)player.field_71070_bA).layers.get(this.layer).closeLayer(this.nbt, true);
            } else {
                ((ContainerSub)player.field_71070_bA).layers.get(this.layer).openNewLayer(this.nbt, true);
            }
        }
    }
}

