/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils.commands;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.IPCClient;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.DiscordStatus;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.ScrollableListControl;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.SelectorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;

public class CommandsGui
extends ExtendedScreen {
    private static String[] executionCommandArgs;
    public ExtendedButtonControl proceedButton;
    private ExtendedTextControl commandInput;
    private String executionString;
    private String[] commandArgs;
    private String[] filteredCommandArgs;
    private List<String> tabCompletions = Lists.newArrayList();

    public CommandsGui(GuiScreen parentScreen) {
        super(parentScreen);
    }

    public static void executeCommand(String ... args) {
        executionCommandArgs = args;
    }

    private static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (String s1 : possibleCompletions.stream().map(arg_0 -> ((Function)Functions.toStringFunction()).apply(arg_0)).collect(Collectors.toList())) {
                if (!CommandsGui.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
            if (list.isEmpty()) {
                for (Object object : possibleCompletions) {
                    if (StringUtils.isNullOrEmpty(String.valueOf(object)) || !CommandsGui.doesStringStartWith(s, String.valueOf(object))) continue;
                    list.add(String.valueOf(object));
                }
            }
        }
        return list;
    }

    private static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    @Override
    public void initializeUi() {
        this.commandInput = this.addControl(new ExtendedTextControl(this.getFontRenderer(), 115, this.field_146295_m - 30, this.field_146294_l - 120, 20));
        this.commandInput.func_146203_f(512);
        this.proceedButton = this.addControl(new ExtendedButtonControl(10, this.field_146295_m - 30, 100, 20, ModUtils.TRANSLATOR.translate("gui.config.message.button.back", new Object[0]), () -> CraftPresence.GUIS.openScreen(this.parentScreen), new String[0]));
        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.commands", new Object[0]);
        this.renderString(mainTitle, (float)this.field_146294_l / 2.0f - (float)StringUtils.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        if (!StringUtils.isNullOrEmpty(this.commandInput.func_146179_b()) && this.commandInput.func_146179_b().startsWith("/")) {
            this.commandArgs = this.commandInput.func_146179_b().replace("/", "").split(" ");
            this.filteredCommandArgs = this.commandInput.func_146179_b().replace("/", "").replace("cp", "").replace("craftpresence", "").trim().split(" ");
            this.tabCompletions = this.getTabCompletions(this.filteredCommandArgs);
        }
        if (executionCommandArgs != null) {
            if (executionCommandArgs.length == 0 || executionCommandArgs[0].equalsIgnoreCase("help") || executionCommandArgs[0].equalsIgnoreCase("?") || executionCommandArgs[0].equalsIgnoreCase("")) {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.main", new Object[0]);
            } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[0])) {
                if (executionCommandArgs[0].equalsIgnoreCase("request")) {
                    if (executionCommandArgs.length == 1) {
                        if (CraftPresence.CLIENT.STATUS == DiscordStatus.JoinRequest && CraftPresence.CLIENT.REQUESTER_USER != null) {
                            if (CraftPresence.CONFIG.enableJoinRequest) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.info", CraftPresence.CLIENT.REQUESTER_USER.getName(), CraftPresence.SYSTEM.TIMER);
                                CraftPresence.CLIENT.awaitingReply = true;
                            } else {
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY, null);
                                CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                            CraftPresence.CLIENT.awaitingReply = false;
                        }
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (CraftPresence.CLIENT.awaitingReply && CraftPresence.CONFIG.enableJoinRequest) {
                            if (executionCommandArgs[1].equalsIgnoreCase("accept")) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.accept", CraftPresence.CLIENT.REQUESTER_USER.getName());
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.ACCEPT, null);
                                CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            } else if (executionCommandArgs[1].equalsIgnoreCase("deny")) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.denied", CraftPresence.CLIENT.REQUESTER_USER.getName());
                                CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY, null);
                                CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                                CraftPresence.SYSTEM.TIMER = 0;
                                CraftPresence.CLIENT.awaitingReply = false;
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.request.none", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("export")) {
                    String clientId = CraftPresence.CONFIG.clientId;
                    boolean doFullCopy = false;
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.export", clientId, false);
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (executionCommandArgs.length != 2 && !StringUtils.isNullOrEmpty(executionCommandArgs[2])) {
                                if (StringUtils.isValidBoolean(executionCommandArgs[2])) {
                                    doFullCopy = Boolean.parseBoolean(executionCommandArgs[2]);
                                } else {
                                    clientId = executionCommandArgs[2];
                                }
                                if (executionCommandArgs.length != 3 && !StringUtils.isNullOrEmpty(executionCommandArgs[3])) {
                                    if (StringUtils.isValidBoolean(executionCommandArgs[3])) {
                                        doFullCopy = Boolean.parseBoolean(executionCommandArgs[3]);
                                    } else {
                                        clientId = executionCommandArgs[3];
                                    }
                                }
                            }
                            DiscordAsset[] assetList = DiscordAssetUtils.loadAssets(clientId, false);
                            OutputStream outputData = null;
                            OutputStreamWriter outputStream = null;
                            BufferedWriter bw = null;
                            boolean hasError = false;
                            if (assetList != null) {
                                block97: {
                                    String filePath = "craftpresence" + File.separator + "export" + File.separator + clientId + File.separator;
                                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.pre", assetList.length, clientId, doFullCopy);
                                    if (!doFullCopy) {
                                        try {
                                            File dataDir = new File(filePath + "downloads.txt");
                                            if (!dataDir.getParentFile().exists() && !dataDir.getParentFile().mkdirs()) {
                                                hasError = true;
                                            }
                                            outputData = new FileOutputStream(dataDir);
                                            outputStream = new OutputStreamWriter(outputData, CraftPresence.CLIENT.ipcInstance.getEncoding());
                                            bw = new BufferedWriter(outputStream);
                                            bw.write("## Export Data => " + clientId);
                                            bw.newLine();
                                            bw.newLine();
                                        }
                                        catch (Exception ex) {
                                            ex.printStackTrace();
                                            hasError = true;
                                        }
                                    }
                                    for (DiscordAsset asset : assetList) {
                                        String assetUrl = DiscordAssetUtils.getAssetUrl(clientId, asset.getId(), false);
                                        String assetName = asset.getName() + ".png";
                                        if (doFullCopy) {
                                            FileUtils.downloadFile(assetUrl, new File(filePath + assetName));
                                            continue;
                                        }
                                        if (!hasError) {
                                            try {
                                                bw.write("* " + assetName + " => " + assetUrl);
                                                bw.newLine();
                                            }
                                            catch (Exception ex) {
                                                ex.printStackTrace();
                                                hasError = true;
                                            }
                                            continue;
                                        }
                                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.exception", clientId);
                                    }
                                    try {
                                        if (bw != null) {
                                            bw.close();
                                        }
                                        if (outputStream != null) {
                                            outputStream.close();
                                        }
                                        if (outputData != null) {
                                            outputData.close();
                                        }
                                    }
                                    catch (Exception ex) {
                                        ModUtils.LOG.debugError(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
                                        if (!ModUtils.IS_VERBOSE) break block97;
                                        ex.printStackTrace();
                                    }
                                }
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.post", assetList.length, clientId, doFullCopy);
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.export.exception", clientId);
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else if (executionCommandArgs[0].equalsIgnoreCase("reload")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reload", new Object[0]);
                    CommandUtils.reloadData(true);
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reload.complete", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("shutdown")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.shutdown.pre", new Object[0]);
                    CraftPresence.CLIENT.shutDown();
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.shutdown.post", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("reboot")) {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reboot.pre", new Object[0]);
                    CommandUtils.rebootRPC();
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.reboot.post", new Object[0]);
                } else if (executionCommandArgs[0].equalsIgnoreCase("view")) {
                    if (executionCommandArgs.length == 1) {
                        this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.view", new Object[0]);
                    } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[1])) {
                        if (executionCommandArgs[1].equalsIgnoreCase("items")) {
                            if (CraftPresence.TILE_ENTITIES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.items", new Object[0]), CraftPresence.TILE_ENTITIES.TILE_ENTITY_NAMES, null, null, false, false, ScrollableListControl.RenderType.ItemData, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_item", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("entities")) {
                            if (CraftPresence.ENTITIES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.entity", new Object[0]), CraftPresence.ENTITIES.ENTITY_NAMES, null, null, false, false, ScrollableListControl.RenderType.EntityData, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_entity", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("servers")) {
                            if (CraftPresence.SERVER.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.servers", new Object[0]), CraftPresence.SERVER.knownAddresses, null, null, false, false, ScrollableListControl.RenderType.ServerData, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("screens")) {
                            if (CraftPresence.GUIS.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.guis", new Object[0]), CraftPresence.GUIS.GUI_NAMES, null, null, false, false, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.advanced.enable_per_gui", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("biomes")) {
                            if (CraftPresence.BIOMES.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.biomes", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, false, false, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("dimensions")) {
                            if (CraftPresence.DIMENSIONS.enabled) {
                                CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.dimensions", new Object[0]), CraftPresence.DIMENSIONS.DIMENSION_NAMES, null, null, false, false, null, null));
                            } else {
                                this.executionString = ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]));
                            }
                        } else if (executionCommandArgs[1].equalsIgnoreCase("currentData")) {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.current_data", CraftPresence.CLIENT.CURRENT_USER.getName(), StringUtils.getConvertedString(CraftPresence.CLIENT.DETAILS, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.GAME_STATE, "UTF-8", true), CraftPresence.CLIENT.START_TIMESTAMP, CraftPresence.CLIENT.CLIENT_ID, StringUtils.getConvertedString(CraftPresence.CLIENT.LARGE_IMAGE_KEY, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.LARGE_IMAGE_TEXT, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.SMALL_IMAGE_KEY, "UTF-8", true), StringUtils.getConvertedString(CraftPresence.CLIENT.SMALL_IMAGE_TEXT, "UTF-8", true), CraftPresence.CLIENT.PARTY_ID, CraftPresence.CLIENT.PARTY_SIZE, CraftPresence.CLIENT.PARTY_MAX, CraftPresence.CLIENT.PARTY_PRIVACY.getDisplayName(), CraftPresence.CLIENT.JOIN_SECRET, CraftPresence.CLIENT.END_TIMESTAMP, CraftPresence.CLIENT.MATCH_SECRET, CraftPresence.CLIENT.SPECTATE_SECRET, CraftPresence.CLIENT.BUTTONS.toString(), CraftPresence.CLIENT.INSTANCE);
                        } else if (executionCommandArgs[1].equalsIgnoreCase("assets")) {
                            if (executionCommandArgs.length == 2) {
                                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.usage.view.assets", new Object[0]);
                            } else if (!StringUtils.isNullOrEmpty(executionCommandArgs[2])) {
                                if (executionCommandArgs[2].equalsIgnoreCase("large")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.large", new Object[0]), DiscordAssetUtils.LARGE_ICONS, null, null, false, false, ScrollableListControl.RenderType.DiscordAsset, null, null));
                                } else if (executionCommandArgs[2].equalsIgnoreCase("small")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.small", new Object[0]), DiscordAssetUtils.SMALL_ICONS, null, null, false, false, ScrollableListControl.RenderType.DiscordAsset, null, null));
                                } else if (executionCommandArgs[2].equalsIgnoreCase("all")) {
                                    CraftPresence.GUIS.openScreen(new SelectorGui(this.currentScreen, ModUtils.TRANSLATOR.translate("gui.config.title.selector.view.assets.all", new Object[0]), DiscordAssetUtils.ICON_LIST, null, null, false, false, ScrollableListControl.RenderType.DiscordAsset, null, null));
                                }
                            }
                        } else {
                            this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                        }
                    }
                } else {
                    this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.command.unrecognized", new Object[0]);
                }
            } else {
                this.executionString = ModUtils.TRANSLATOR.translate("craftpresence.logger.error.command", new Object[0]);
            }
        }
        executionCommandArgs = null;
        CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(this.executionString), 25, 35, this.field_146294_l, this.field_146295_m, this.getWrapWidth(), this.getFontRenderer(), false);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (this.commandInput.func_146206_l() && this.commandInput.func_146179_b().startsWith("/") && this.commandArgs != null && this.commandArgs.length > 0 && (this.commandArgs[0].equalsIgnoreCase("cp") || this.commandArgs[0].equalsIgnoreCase("craftpresence"))) {
            if (keyCode == 15 && !this.tabCompletions.isEmpty()) {
                if (this.commandArgs.length > 1 && (this.filteredCommandArgs[this.filteredCommandArgs.length - 1].length() > 1 || this.filteredCommandArgs[this.filteredCommandArgs.length - 1].equalsIgnoreCase("?"))) {
                    this.commandInput.func_146180_a(this.commandInput.func_146179_b().replace(this.filteredCommandArgs[this.filteredCommandArgs.length - 1], this.tabCompletions.get(0)));
                }
            } else if (keyCode == 28 || keyCode == 156) {
                CommandsGui.executeCommand(this.filteredCommandArgs);
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private List<String> getTabCompletions(String[] args) {
        ArrayList baseCompletions = Lists.newArrayList();
        ArrayList exportCompletions = Lists.newArrayList();
        ArrayList assetsCompletions = Lists.newArrayList();
        ArrayList viewCompletions = Lists.newArrayList();
        ArrayList requestCompletions = Lists.newArrayList();
        baseCompletions.add("?");
        baseCompletions.add("help");
        baseCompletions.add("config");
        baseCompletions.add("reload");
        baseCompletions.add("request");
        baseCompletions.add("export");
        baseCompletions.add("view");
        baseCompletions.add("reboot");
        baseCompletions.add("shutdown");
        exportCompletions.add("assets");
        viewCompletions.add("currentData");
        viewCompletions.add("assets");
        viewCompletions.add("dimensions");
        viewCompletions.add("biomes");
        viewCompletions.add("guis");
        viewCompletions.add("items");
        viewCompletions.add("entities");
        viewCompletions.add("servers");
        assetsCompletions.add("all");
        assetsCompletions.add("large");
        assetsCompletions.add("small");
        requestCompletions.add("accept");
        requestCompletions.add("deny");
        if (args.length == 1) {
            return CommandsGui.getListOfStringsMatchingLastWord(args, baseCompletions);
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("export")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, exportCompletions);
            }
            if (args[0].equalsIgnoreCase("view")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, viewCompletions);
            }
            if (args[0].equalsIgnoreCase("request")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, requestCompletions);
            }
            return Lists.newArrayList();
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("view") && args[1].equalsIgnoreCase("assets")) {
                return CommandsGui.getListOfStringsMatchingLastWord(args, assetsCompletions);
            }
            return Lists.newArrayList();
        }
        return Lists.newArrayList();
    }
}

