/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.utils;

import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public class UrlUtils {
    private static final String USER_AGENT = "craftpresence/" + ModUtils.MCVersion;
    private static final float JAVA_SPEC = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final Gson GSON = new GsonBuilder().create();

    public static String getURLText(URL url, String encoding) throws Exception {
        return UrlUtils.getString(UrlUtils.getURLReader(url, encoding));
    }

    private static String getString(BufferedReader urlReader) throws Exception {
        String inputLine;
        StringBuilder response = new StringBuilder();
        while (!StringUtils.isNullOrEmpty(inputLine = urlReader.readLine())) {
            response.append(inputLine);
        }
        urlReader.close();
        return response.toString();
    }

    public static String getURLText(String url, String encoding) throws Exception {
        return UrlUtils.getString(UrlUtils.getURLReader(url, encoding));
    }

    public static BufferedReader getURLReader(String url, String encoding) throws Exception {
        return UrlUtils.getURLReader(new URL(url), encoding);
    }

    public static BufferedReader getURLReader(URL url, String encoding) throws Exception {
        return new BufferedReader(UrlUtils.getURLStreamReader(url, encoding));
    }

    public static InputStream getURLStream(URL url) throws Exception {
        if ((double)JAVA_SPEC < 1.8) {
            System.setProperty("https.protocols", "TLSv1.2");
        }
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        return connection.getInputStream();
    }

    public static InputStreamReader getURLStreamReader(URL url, String encoding) throws Exception {
        return new InputStreamReader(UrlUtils.getURLStream(url), Charset.forName(encoding));
    }

    public static <T> T getJSONFromURL(String url, Class<T> targetClass) throws Exception {
        return UrlUtils.getJSONFromURL(new URL(url), targetClass);
    }

    public static <T> T getJSONFromURL(URL url, Class<T> targetClass) throws Exception {
        return (T)GSON.fromJson((Reader)UrlUtils.getURLStreamReader(url, "UTF-8"), targetClass);
    }

    public static void openUrl(String targetUrl) {
        try {
            UrlUtils.openUrl(new URI(targetUrl));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void openUrl(URL targetUrl) {
        try {
            UrlUtils.openUrl(targetUrl.toURI());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void openUrl(URI targetUrl) {
        try {
            Desktop desktop = Desktop.getDesktop();
            desktop.browse(targetUrl);
        }
        catch (Exception ex) {
            try {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("xdg-open " + targetUrl.toString());
            }
            catch (Exception ex2) {
                ex2.printStackTrace();
            }
        }
    }
}

