/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.ModUtils;
import com.gitlab.cdagaming.craftpresence.impl.KeyConverter;
import com.gitlab.cdagaming.craftpresence.impl.Pair;
import com.gitlab.cdagaming.craftpresence.impl.Tuple;
import com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import com.gitlab.cdagaming.craftpresence.utils.TranslationUtils;
import com.gitlab.cdagaming.craftpresence.utils.discord.rpc.entities.PartyPrivacy;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfigUtils {
    public final List<Pair<String, Object>> configDataMappings = Lists.newArrayList();
    private final String[] blackListedCharacters = new String[]{",", "[", "]"};
    private final String[] keyCodeTriggers = new String[]{"keycode", "keybinding"};
    private final String[] languageTriggers = new String[]{"language", "lang", "langId", "languageId"};
    private final String[] globalTriggers = new String[]{"global", "last", "schema"};
    private final List<Pair<String, String>> configPropertyMappings = Lists.newArrayList();
    private final String fileName;
    public String NAME_schemaVersion;
    public String NAME_lastMcVersionId;
    public String NAME_detectCurseManifest;
    public String NAME_detectMultiMCManifest;
    public String NAME_detectMCUpdaterInstance;
    public String NAME_detectTechnicPack;
    public String NAME_showTime;
    public String NAME_detectBiomeData;
    public String NAME_detectDimensionData;
    public String NAME_detectWorldData;
    public String NAME_clientId;
    public String NAME_defaultIcon;
    public String NAME_enableJoinRequest;
    public String NAME_partyPrivacyLevel;
    public String NAME_resetTimeOnInit;
    public String NAME_autoRegister;
    public String NAME_defaultBiomeIcon;
    public String NAME_biomeMessages;
    public String NAME_defaultDimensionIcon;
    public String NAME_dimensionMessages;
    public String NAME_defaultServerIcon;
    public String NAME_defaultServerName;
    public String NAME_defaultServerMotd;
    public String NAME_serverMessages;
    public String NAME_mainMenuMessage;
    public String NAME_loadingMessage;
    public String NAME_lanMessage;
    public String NAME_singlePlayerMessage;
    public String NAME_packPlaceholderMessage;
    public String NAME_outerPlayerPlaceholderMessage;
    public String NAME_innerPlayerPlaceholderMessage;
    public String NAME_playerCoordinatePlaceholderMessage;
    public String NAME_playerHealthPlaceholderMessage;
    public String NAME_playerAmountPlaceholderMessage;
    public String NAME_playerItemsPlaceholderMessage;
    public String NAME_worldPlaceholderMessage;
    public String NAME_modsPlaceholderMessage;
    public String NAME_vivecraftMessage;
    public String NAME_fallbackPackPlaceholderMessage;
    public String NAME_enableCommands;
    public String NAME_enablePerGui;
    public String NAME_enablePerItem;
    public String NAME_enablePerEntity;
    public String NAME_renderTooltips;
    public String NAME_formatWords;
    public String NAME_debugMode;
    public String NAME_verboseMode;
    public String NAME_splitCharacter;
    public String NAME_refreshRate;
    public String NAME_roundSize;
    public String NAME_includeExtraGuiClasses;
    public String NAME_guiMessages;
    public String NAME_itemMessages;
    public String NAME_entityTargetMessages;
    public String NAME_entityAttackingMessages;
    public String NAME_entityRidingMessages;
    public String NAME_playerSkinEndpoint;
    public String NAME_tooltipBackgroundColor;
    public String NAME_tooltipBorderColor;
    public String NAME_guiBackgroundColor;
    public String NAME_buttonBackgroundColor;
    public String NAME_showBackgroundAsDark;
    public String NAME_languageId;
    public String NAME_stripTranslationColors;
    public String NAME_showLoggingInChat;
    public String NAME_stripExtraGuiElements;
    public String NAME_configKeyCode;
    public String NAME_gameStateMessage_FORMAT;
    public String NAME_detailsMessage_FORMAT;
    public String NAME_largeImageMessage_FORMAT;
    public String NAME_smallImageMessage_FORMAT;
    public String NAME_largeImageKey_FORMAT;
    public String NAME_smallImageKey_FORMAT;
    public String schemaVersion;
    public String lastMcVersionId;
    public boolean detectCurseManifest;
    public boolean detectMultiMCManifest;
    public boolean detectMCUpdaterInstance;
    public boolean detectTechnicPack;
    public boolean showTime;
    public boolean detectBiomeData;
    public boolean detectDimensionData;
    public boolean detectWorldData;
    public boolean enableJoinRequest;
    public boolean resetTimeOnInit;
    public boolean autoRegister;
    public String clientId;
    public String defaultIcon;
    public int partyPrivacyLevel;
    public String defaultBiomeIcon;
    public String[] biomeMessages;
    public String defaultDimensionIcon;
    public String[] dimensionMessages;
    public String defaultServerIcon;
    public String defaultServerName;
    public String defaultServerMotd;
    public String[] serverMessages;
    public String mainMenuMessage;
    public String loadingMessage;
    public String lanMessage;
    public String singlePlayerMessage;
    public String packPlaceholderMessage;
    public String outerPlayerPlaceholderMessage;
    public String innerPlayerPlaceholderMessage;
    public String playerCoordinatePlaceholderMessage;
    public String playerHealthPlaceholderMessage;
    public String playerAmountPlaceholderMessage;
    public String playerItemsPlaceholderMessage;
    public String worldPlaceholderMessage;
    public String modsPlaceholderMessage;
    public String vivecraftMessage;
    public String fallbackPackPlaceholderMessage;
    public boolean enableCommands;
    public boolean enablePerGui;
    public boolean enablePerItem;
    public boolean enablePerEntity;
    public boolean renderTooltips;
    public boolean formatWords;
    public boolean debugMode;
    public boolean verboseMode;
    public boolean includeExtraGuiClasses;
    public String splitCharacter;
    public String playerSkinEndpoint;
    public int refreshRate;
    public int roundSize;
    public String[] guiMessages;
    public String[] itemMessages;
    public String[] entityTargetMessages;
    public String[] entityAttackingMessages;
    public String[] entityRidingMessages;
    public String tooltipBackgroundColor;
    public String tooltipBorderColor;
    public String guiBackgroundColor;
    public String buttonBackgroundColor;
    public String languageId;
    public int configKeyCode;
    public boolean showBackgroundAsDark;
    public boolean stripTranslationColors;
    public boolean showLoggingInChat;
    public boolean stripExtraGuiElements;
    public String gameStateMessage;
    public String detailsMessage;
    public String largeImageMessage;
    public String smallImageMessage;
    public String largeImageKey;
    public String smallImageKey;
    public boolean hasChanged = false;
    public boolean hasClientPropertiesChanged = false;
    public Map<String, Integer> keySyncQueue = Maps.newHashMap();
    public List<String> avoidanceFilter = Lists.newArrayList();
    public String queuedSplitCharacter;
    public File configFile;
    public File parentDir;
    public Properties properties = new Properties();
    private boolean initialized = false;
    private boolean isConfigNew = false;

    public ConfigUtils(String fileName) {
        this.fileName = fileName;
    }

    public void setupInitialValues() {
        this.NAME_schemaVersion = ModUtils.TRANSLATOR.translate(true, "gui.config.name.global.schema_version", new Object[0]).replaceAll(" ", "_");
        this.schemaVersion = Integer.toString(2);
        this.NAME_lastMcVersionId = ModUtils.TRANSLATOR.translate(true, "gui.config.name.global.last_mc_version_id", new Object[0]).replaceAll(" ", "_");
        this.lastMcVersionId = Integer.toString(ModUtils.MCProtocolID);
        this.NAME_detectCurseManifest = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_curse_manifest", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectMultiMCManifest = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_multimc_manifest", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectMCUpdaterInstance = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_mcupdater_instance", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectTechnicPack = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_technic_pack", new Object[0]).replaceAll(" ", "_");
        this.NAME_showTime = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.show_time", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectBiomeData = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_biome_data", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectDimensionData = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_dimension_data", new Object[0]).replaceAll(" ", "_");
        this.NAME_detectWorldData = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.detect_world_data", new Object[0]).replaceAll(" ", "_");
        this.NAME_clientId = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.client_id", new Object[0]).replaceAll(" ", "_");
        this.NAME_defaultIcon = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.default_icon", new Object[0]).replaceAll(" ", "_");
        this.NAME_enableJoinRequest = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.enable_join_request", new Object[0]).replaceAll(" ", "_");
        this.NAME_partyPrivacyLevel = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.party_privacy", new Object[0]).replaceAll(" ", "_");
        this.NAME_resetTimeOnInit = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.reset_time_on_init", new Object[0]).replaceAll(" ", "_");
        this.NAME_autoRegister = ModUtils.TRANSLATOR.translate(true, "gui.config.name.general.auto_register", new Object[0]).replaceAll(" ", "_");
        this.detectCurseManifest = true;
        this.detectMultiMCManifest = true;
        this.detectMCUpdaterInstance = true;
        this.detectTechnicPack = true;
        this.showTime = true;
        this.detectBiomeData = false;
        this.detectDimensionData = true;
        this.detectWorldData = true;
        this.clientId = "450485984333660181";
        this.defaultIcon = "grass";
        this.enableJoinRequest = false;
        this.partyPrivacyLevel = PartyPrivacy.Public.getPartyIndex();
        this.resetTimeOnInit = false;
        this.autoRegister = false;
        this.NAME_defaultBiomeIcon = ModUtils.TRANSLATOR.translate(true, "gui.config.name.biome_messages.biome_icon".replaceAll(" ", "_"), new Object[0]);
        this.NAME_biomeMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.biome_messages.biome_messages", new Object[0]).replaceAll(" ", "_");
        this.defaultBiomeIcon = "unknown";
        this.biomeMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "Playing in &biome&"};
        this.NAME_defaultDimensionIcon = ModUtils.TRANSLATOR.translate(true, "gui.config.name.dimension_messages.dimension_icon", new Object[0]).replaceAll(" ", "_");
        this.NAME_dimensionMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.dimension_messages.dimension_messages", new Object[0]).replaceAll(" ", "_");
        this.defaultDimensionIcon = "unknown";
        this.dimensionMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "In the &dimension&"};
        this.NAME_defaultServerIcon = ModUtils.TRANSLATOR.translate(true, "gui.config.name.server_messages.server_icon", new Object[0]).replaceAll(" ", "_");
        this.NAME_defaultServerName = ModUtils.TRANSLATOR.translate(true, "gui.config.name.server_messages.server_name", new Object[0]).replaceAll(" ", "_");
        this.NAME_defaultServerMotd = ModUtils.TRANSLATOR.translate(true, "gui.config.name.server_messages.server_motd", new Object[0]).replaceAll(" ", "_");
        this.NAME_serverMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.server_messages.server_messages", new Object[0]).replaceAll(" ", "_");
        this.defaultServerIcon = "default";
        this.defaultServerName = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.server_messages.server_name", new Object[0]);
        this.defaultServerMotd = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.server_messages.server_motd", new Object[0]);
        this.serverMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "Playing on &motd&"};
        this.NAME_mainMenuMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.main_menu_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_loadingMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.loading_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_lanMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.lan_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_singlePlayerMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.single_player_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_packPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.pack_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_outerPlayerPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.player_message.out", new Object[0]).replaceAll(" ", "_");
        this.NAME_innerPlayerPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.player_message.in", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerCoordinatePlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.player_coordinate_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerHealthPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.player_health_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerAmountPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.player_amount_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerItemsPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.player_item_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_worldPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.world_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_modsPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.placeholder.mods_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_vivecraftMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.special.vivecraft_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_fallbackPackPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "gui.config.name.status_messages.fallback.pack_placeholder_message", new Object[0]).replaceAll(" ", "_");
        this.mainMenuMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.state.main_menu", new Object[0]);
        this.loadingMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.state.loading", new Object[0]);
        this.lanMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.state.lan", new Object[0]);
        this.singlePlayerMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.state.single_player", new Object[0]);
        this.packPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.pack", new Object[0]);
        this.outerPlayerPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.player_info.out", new Object[0]);
        this.innerPlayerPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.player_info.in", new Object[0]);
        this.playerCoordinatePlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.player_info.coordinate", new Object[0]);
        this.playerHealthPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.player_info.health", new Object[0]);
        this.playerAmountPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.players", new Object[0]);
        this.playerItemsPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.player_info.items", new Object[0]);
        this.worldPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.world_info", new Object[0]);
        this.modsPlaceholderMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.placeholder.mods", new Object[0]);
        this.vivecraftMessage = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.special.vivecraft", new Object[0]);
        this.fallbackPackPlaceholderMessage = "";
        this.NAME_enableCommands = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.enable_commands", new Object[0]).replaceAll(" ", "_");
        this.NAME_enablePerGui = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.enable_per_gui", new Object[0]).replaceAll(" ", "_");
        this.NAME_enablePerItem = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.enable_per_item", new Object[0]).replaceAll(" ", "_");
        this.NAME_enablePerEntity = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.enable_per_entity", new Object[0]).replaceAll(" ", "_");
        this.NAME_renderTooltips = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.render_tooltips", new Object[0]).replaceAll(" ", "_");
        this.NAME_formatWords = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.format_words", new Object[0]).replaceAll(" ", "_");
        this.NAME_debugMode = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.debug_mode", new Object[0]).replaceAll(" ", "_");
        this.NAME_verboseMode = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.verbose_mode", new Object[0]).replaceAll(" ", "_");
        this.NAME_splitCharacter = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.split_character", new Object[0]).replaceAll(" ", "_");
        this.NAME_refreshRate = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.refresh_rate", new Object[0]).replaceAll(" ", "_");
        this.NAME_roundSize = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.round_size", new Object[0]).replaceAll(" ", "_");
        this.NAME_includeExtraGuiClasses = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.include_extra_gui_classes", new Object[0]).replaceAll(" ", "_");
        this.NAME_guiMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.gui_messages", new Object[0]).replaceAll(" ", "_");
        this.NAME_itemMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.item_messages", new Object[0]).replaceAll(" ", "_");
        this.NAME_entityTargetMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.entity_target_messages", new Object[0]).replaceAll(" ", "_");
        this.NAME_entityAttackingMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.entity_attacking_messages", new Object[0]).replaceAll(" ", "_");
        this.NAME_entityRidingMessages = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.entity_riding_messages", new Object[0]).replaceAll(" ", "_");
        this.NAME_playerSkinEndpoint = ModUtils.TRANSLATOR.translate(true, "gui.config.name.advanced.player_skin_endpoint", new Object[0]).replaceAll(" ", "_");
        this.enableCommands = true;
        this.enablePerGui = false;
        this.enablePerItem = false;
        this.enablePerEntity = false;
        this.renderTooltips = true;
        this.formatWords = true;
        this.debugMode = false;
        this.verboseMode = false;
        this.splitCharacter = ";";
        this.refreshRate = 2;
        this.roundSize = 3;
        this.includeExtraGuiClasses = false;
        this.guiMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "In &screen&"};
        this.itemMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "Holding &item&"};
        this.entityTargetMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "Targeting &entity&"};
        this.entityAttackingMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "Attacking &entity&"};
        this.entityRidingMessages = new String[]{"default" + (!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";") + "Riding &entity&"};
        this.playerSkinEndpoint = ModUtils.TRANSLATOR.translate(true, "craftpresence.defaults.advanced.player_skin_endpoint", new Object[0]);
        this.NAME_tooltipBackgroundColor = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.tooltip_background_color", new Object[0]).replaceAll(" ", "_");
        this.NAME_tooltipBorderColor = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.tooltip_border_color", new Object[0]).replaceAll(" ", "_");
        this.NAME_guiBackgroundColor = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.gui_background_color", new Object[0]).replaceAll(" ", "_");
        this.NAME_buttonBackgroundColor = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.button_background_color", new Object[0]).replaceAll(" ", "_");
        this.NAME_languageId = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.language_id", new Object[0]).replaceAll(" ", "_");
        this.NAME_showBackgroundAsDark = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.show_background_as_dark", new Object[0]).replaceAll(" ", "_");
        this.NAME_stripTranslationColors = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.strip_translation_colors", new Object[0]).replaceAll(" ", "_");
        this.NAME_showLoggingInChat = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.show_logging_in_chat", new Object[0]).replaceAll(" ", "_");
        this.NAME_stripExtraGuiElements = ModUtils.TRANSLATOR.translate(true, "gui.config.name.accessibility.strip_extra_gui_elements", new Object[0]).replaceAll(" ", "_");
        this.NAME_configKeyCode = ModUtils.TRANSLATOR.translate(true, "key.craftpresence.config_keycode.name", new Object[0]).replaceAll(" ", "_");
        this.tooltipBackgroundColor = "0xF0100010";
        this.tooltipBorderColor = "0x505000FF";
        StringBuilder stringBuilder = new StringBuilder().append("minecraft").append(!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";");
        if (ModUtils.MCProtocolID <= 61) {
            // empty if block
        }
        this.guiBackgroundColor = stringBuilder.append("textures/gui/options_background.png").toString();
        StringBuilder stringBuilder2 = new StringBuilder().append("minecraft").append(!StringUtils.isNullOrEmpty(this.splitCharacter) ? this.splitCharacter : ";");
        if (ModUtils.MCProtocolID <= 61) {
            // empty if block
        }
        this.buttonBackgroundColor = stringBuilder2.append("textures/gui/widgets.png").toString();
        this.languageId = ModUtils.MCProtocolID >= 315 ? "en_us" : "en_US";
        this.showBackgroundAsDark = true;
        this.stripTranslationColors = false;
        this.showLoggingInChat = false;
        this.stripExtraGuiElements = false;
        this.configKeyCode = ModUtils.MCProtocolID > 340 ? 96 : 41;
        this.NAME_gameStateMessage_FORMAT = ModUtils.TRANSLATOR.translate(true, "gui.config.name.display.game_state_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_detailsMessage_FORMAT = ModUtils.TRANSLATOR.translate(true, "gui.config.name.display.details_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_largeImageMessage_FORMAT = ModUtils.TRANSLATOR.translate(true, "gui.config.name.display.large_image_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_smallImageMessage_FORMAT = ModUtils.TRANSLATOR.translate(true, "gui.config.name.display.small_image_message", new Object[0]).replaceAll(" ", "_");
        this.NAME_largeImageKey_FORMAT = ModUtils.TRANSLATOR.translate(true, "gui.config.name.display.large_image_key", new Object[0]).replaceAll(" ", "_");
        this.NAME_smallImageKey_FORMAT = ModUtils.TRANSLATOR.translate(true, "gui.config.name.display.small_image_key", new Object[0]).replaceAll(" ", "_");
        this.gameStateMessage = "&SERVER& &PACK&";
        this.detailsMessage = "&MAINMENU&&DIMENSION&";
        this.largeImageMessage = "&MAINMENU&&DIMENSION&";
        this.smallImageMessage = "&SERVER& &PACK&";
        this.largeImageKey = "&MAINMENU&&DIMENSION&";
        this.smallImageKey = "&SERVER&&PACK&";
        this.syncMappings();
        this.initialized = true;
    }

    private void syncMappings() {
        this.configDataMappings.clear();
        this.configPropertyMappings.clear();
        this.avoidanceFilter.clear();
        for (Field field : this.getClass().getDeclaredFields()) {
            boolean isName = field.getName().startsWith("NAME_");
            boolean shouldAvoid = field.getName().endsWith("_FORMAT");
            if (!isName) continue;
            try {
                Field valueField = this.getClass().getField(field.getName().replaceFirst("NAME_", "").replaceFirst("_FORMAT", ""));
                field.setAccessible(true);
                valueField.setAccessible(true);
                this.configDataMappings.add(new Pair<String, Object>(field.get(this).toString(), valueField.get(this)));
                this.configPropertyMappings.add(new Pair<String, String>(field.getName(), valueField.getName()));
                if (!shouldAvoid) continue;
                this.avoidanceFilter.add(field.get(this).toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void initialize() {
        try {
            this.configFile = new File(this.fileName);
            this.parentDir = this.configFile.getParentFile();
            this.isConfigNew = !this.parentDir.exists() && this.parentDir.mkdirs() || !this.configFile.exists() && this.configFile.createNewFile();
            this.setupInitialValues();
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            if (this.initialized) {
                if (this.isConfigNew) {
                    this.updateConfig(false);
                }
                this.read(false, "UTF-8");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(boolean skipLogging, String encoding) {
        boolean shouldRefreshLater;
        int currentIndex;
        InputStreamReader configReader = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.configFile);
            configReader = new InputStreamReader((InputStream)inputStream, Charset.forName(encoding));
            this.properties.load(configReader);
            currentIndex = 0;
            shouldRefreshLater = false;
        }
        catch (Exception ex) {
            boolean shouldRefreshLater2;
            try {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
                ex.printStackTrace();
                currentIndex = 0;
                shouldRefreshLater2 = false;
            }
            catch (Throwable throwable) {
                int currentIndex2 = 0;
                boolean shouldRefreshLater3 = false;
                ArrayList propertyList = Lists.newArrayList(this.properties.stringPropertyNames());
                ArrayList migrationData = Lists.newArrayList();
                for (Pair<String, String> configProperty : this.configPropertyMappings) {
                    block106: {
                        String propertyName;
                        block111: {
                            Object fieldObject = null;
                            propertyName = this.configDataMappings.get(currentIndex2).getFirst();
                            Object defaultValue = this.configDataMappings.get(currentIndex2).getSecond();
                            Class<?> expectedClass = this.configDataMappings.get(currentIndex2).getSecond().getClass();
                            if (!propertyList.contains(propertyName)) break block111;
                            propertyList.remove(propertyName);
                            Object foundProperty = this.properties.get(propertyName);
                            try {
                                fieldObject = expectedClass.cast(foundProperty);
                                if (!StringUtils.isNullOrEmpty(defaultValue.toString()) && (fieldObject == null || StringUtils.isNullOrEmpty(fieldObject.toString()))) {
                                    throw new IllegalArgumentException(ModUtils.TRANSLATOR.translate(true, "craftpresence.exception.config.prop.null", propertyName));
                                }
                                if (fieldObject == null) break block106;
                                fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                            }
                            catch (Exception ex2) {
                                try {
                                    if ((expectedClass == Boolean.TYPE || expectedClass == Boolean.class) && StringUtils.isValidBoolean(foundProperty)) {
                                        fieldObject = Boolean.parseBoolean(foundProperty.toString());
                                    } else if ((expectedClass == Integer.TYPE || expectedClass == Integer.class) && StringUtils.getValidInteger(foundProperty).getFirst().booleanValue()) {
                                        Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(foundProperty);
                                        if (boolData.getFirst().booleanValue()) {
                                            block32: for (String keyTrigger : this.keyCodeTriggers) {
                                                if (!configProperty.getSecond().toLowerCase().contains(keyTrigger.toLowerCase())) continue;
                                                if (!CraftPresence.KEYBINDINGS.isValidKeyCode(boolData.getSecond())) {
                                                    if (!skipLogging) {
                                                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                                    }
                                                    fieldObject = defaultValue;
                                                    break;
                                                }
                                                for (Pair migrationChunk : migrationData) {
                                                    if (!((List)migrationChunk.getFirst()).contains(keyTrigger.toLowerCase()) || ((String)migrationChunk.getSecond()).equalsIgnoreCase(KeyConverter.ConversionMode.Unknown.name())) continue;
                                                    int migratedKeyCode = KeyConverter.convertKey(boolData.getSecond(), KeyConverter.ConversionMode.valueOf((String)migrationChunk.getSecond()));
                                                    if (!skipLogging && migratedKeyCode != boolData.getSecond()) {
                                                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.apply", ((List)migrationChunk.getFirst()).toString(), migrationChunk.getSecond(), propertyName, boolData.getSecond(), migratedKeyCode), new Object[0]);
                                                    }
                                                    fieldObject = migratedKeyCode;
                                                    break block32;
                                                }
                                                break;
                                            }
                                            if (fieldObject == null) {
                                                fieldObject = boolData.getSecond();
                                            }
                                        } else if (!this.avoidanceFilter.contains(propertyName)) {
                                            if (!skipLogging) {
                                                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                            }
                                            fieldObject = defaultValue;
                                        }
                                    } else if (expectedClass == String[].class) {
                                        String convertedString = StringUtils.removeMatches(StringUtils.getMatches("\\[([^\\s]+?)\\]", foundProperty), null, 1);
                                        if (!StringUtils.isNullOrEmpty(convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]")) {
                                            String preArrayString = convertedString.replaceAll("\\[", "").replaceAll("]", "");
                                            fieldObject = preArrayString.contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString});
                                        }
                                    } else if (!this.avoidanceFilter.contains(propertyName)) {
                                        if (!skipLogging) {
                                            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                        }
                                        fieldObject = defaultValue;
                                    }
                                    if (fieldObject == null) break block106;
                                    fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                                }
                                catch (Throwable throwable2) {
                                    if (fieldObject != null) {
                                        fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                                        StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                                    }
                                    throw throwable2;
                                }
                                StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                                break block106;
                            }
                            StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                            break block106;
                        }
                        if (!this.avoidanceFilter.contains(propertyName) && !skipLogging) {
                            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                            for (String globalTrigger : this.globalTriggers) {
                                if (!propertyName.toLowerCase().contains(globalTrigger.toLowerCase())) continue;
                                shouldRefreshLater3 = true;
                                break;
                            }
                        }
                    }
                    ++currentIndex2;
                }
                for (String remainingProp : propertyList) {
                    if (!skipLogging) {
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.invalid", remainingProp), new Object[0]);
                    }
                    this.properties.remove(remainingProp);
                    this.save("UTF-8");
                }
                this.updateConfig(shouldRefreshLater3);
                throw throwable;
            }
            ArrayList propertyList = Lists.newArrayList(this.properties.stringPropertyNames());
            ArrayList migrationData = Lists.newArrayList();
            for (Pair<String, String> configProperty : this.configPropertyMappings) {
                block105: {
                    String propertyName;
                    block110: {
                        Object fieldObject = null;
                        propertyName = this.configDataMappings.get(currentIndex).getFirst();
                        Object defaultValue = this.configDataMappings.get(currentIndex).getSecond();
                        Class<?> expectedClass = this.configDataMappings.get(currentIndex).getSecond().getClass();
                        if (!propertyList.contains(propertyName)) break block110;
                        propertyList.remove(propertyName);
                        Object foundProperty = this.properties.get(propertyName);
                        try {
                            fieldObject = expectedClass.cast(foundProperty);
                            if (!StringUtils.isNullOrEmpty(defaultValue.toString()) && (fieldObject == null || StringUtils.isNullOrEmpty(fieldObject.toString()))) {
                                throw new IllegalArgumentException(ModUtils.TRANSLATOR.translate(true, "craftpresence.exception.config.prop.null", propertyName));
                            }
                            if (fieldObject == null) break block105;
                            fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                        }
                        catch (Exception ex3) {
                            try {
                                if ((expectedClass == Boolean.TYPE || expectedClass == Boolean.class) && StringUtils.isValidBoolean(foundProperty)) {
                                    fieldObject = Boolean.parseBoolean(foundProperty.toString());
                                } else if ((expectedClass == Integer.TYPE || expectedClass == Integer.class) && StringUtils.getValidInteger(foundProperty).getFirst().booleanValue()) {
                                    Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(foundProperty);
                                    if (boolData.getFirst().booleanValue()) {
                                        block27: for (String keyTrigger : this.keyCodeTriggers) {
                                            if (!configProperty.getSecond().toLowerCase().contains(keyTrigger.toLowerCase())) continue;
                                            if (!CraftPresence.KEYBINDINGS.isValidKeyCode(boolData.getSecond())) {
                                                if (!skipLogging) {
                                                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                                }
                                                fieldObject = defaultValue;
                                                break;
                                            }
                                            for (Pair migrationChunk : migrationData) {
                                                if (!((List)migrationChunk.getFirst()).contains(keyTrigger.toLowerCase()) || ((String)migrationChunk.getSecond()).equalsIgnoreCase(KeyConverter.ConversionMode.Unknown.name())) continue;
                                                int migratedKeyCode = KeyConverter.convertKey(boolData.getSecond(), KeyConverter.ConversionMode.valueOf((String)migrationChunk.getSecond()));
                                                if (!skipLogging && migratedKeyCode != boolData.getSecond()) {
                                                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.apply", ((List)migrationChunk.getFirst()).toString(), migrationChunk.getSecond(), propertyName, boolData.getSecond(), migratedKeyCode), new Object[0]);
                                                }
                                                fieldObject = migratedKeyCode;
                                                break block27;
                                            }
                                            break;
                                        }
                                        if (fieldObject == null) {
                                            fieldObject = boolData.getSecond();
                                        }
                                    } else if (!this.avoidanceFilter.contains(propertyName)) {
                                        if (!skipLogging) {
                                            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                        }
                                        fieldObject = defaultValue;
                                    }
                                } else if (expectedClass == String[].class) {
                                    String convertedString = StringUtils.removeMatches(StringUtils.getMatches("\\[([^\\s]+?)\\]", foundProperty), null, 1);
                                    if (!StringUtils.isNullOrEmpty(convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]")) {
                                        String preArrayString = convertedString.replaceAll("\\[", "").replaceAll("]", "");
                                        fieldObject = preArrayString.contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString});
                                    }
                                } else if (!this.avoidanceFilter.contains(propertyName)) {
                                    if (!skipLogging) {
                                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                    }
                                    fieldObject = defaultValue;
                                }
                                if (fieldObject == null) break block105;
                                fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                            }
                            catch (Throwable throwable) {
                                if (fieldObject != null) {
                                    fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                                    StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                                }
                                throw throwable;
                            }
                            StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                            break block105;
                        }
                        StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                        break block105;
                    }
                    if (!this.avoidanceFilter.contains(propertyName) && !skipLogging) {
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                        for (String globalTrigger : this.globalTriggers) {
                            if (!propertyName.toLowerCase().contains(globalTrigger.toLowerCase())) continue;
                            shouldRefreshLater2 = true;
                            break;
                        }
                    }
                }
                ++currentIndex;
            }
            for (String remainingProp : propertyList) {
                if (!skipLogging) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.invalid", remainingProp), new Object[0]);
                }
                this.properties.remove(remainingProp);
                this.save("UTF-8");
            }
            this.updateConfig(shouldRefreshLater2);
        }
        ArrayList propertyList = Lists.newArrayList(this.properties.stringPropertyNames());
        ArrayList migrationData = Lists.newArrayList();
        for (Pair<String, String> configProperty : this.configPropertyMappings) {
            block104: {
                String propertyName;
                block108: {
                    Object fieldObject = null;
                    propertyName = this.configDataMappings.get(currentIndex).getFirst();
                    Object defaultValue = this.configDataMappings.get(currentIndex).getSecond();
                    Class<?> expectedClass = this.configDataMappings.get(currentIndex).getSecond().getClass();
                    if (!propertyList.contains(propertyName)) break block108;
                    propertyList.remove(propertyName);
                    Object foundProperty = this.properties.get(propertyName);
                    try {
                        fieldObject = expectedClass.cast(foundProperty);
                        if (!StringUtils.isNullOrEmpty(defaultValue.toString()) && (fieldObject == null || StringUtils.isNullOrEmpty(fieldObject.toString()))) {
                            throw new IllegalArgumentException(ModUtils.TRANSLATOR.translate(true, "craftpresence.exception.config.prop.null", propertyName));
                        }
                        if (fieldObject == null) break block104;
                        fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                    }
                    catch (Exception ex) {
                        try {
                            if ((expectedClass == Boolean.TYPE || expectedClass == Boolean.class) && StringUtils.isValidBoolean(foundProperty)) {
                                fieldObject = Boolean.parseBoolean(foundProperty.toString());
                            } else if ((expectedClass == Integer.TYPE || expectedClass == Integer.class) && StringUtils.getValidInteger(foundProperty).getFirst().booleanValue()) {
                                Pair<Boolean, Integer> boolData = StringUtils.getValidInteger(foundProperty);
                                if (boolData.getFirst().booleanValue()) {
                                    block22: for (String keyTrigger : this.keyCodeTriggers) {
                                        if (!configProperty.getSecond().toLowerCase().contains(keyTrigger.toLowerCase())) continue;
                                        if (!CraftPresence.KEYBINDINGS.isValidKeyCode(boolData.getSecond())) {
                                            if (!skipLogging) {
                                                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                            }
                                            fieldObject = defaultValue;
                                            break;
                                        }
                                        for (Pair migrationChunk : migrationData) {
                                            if (!((List)migrationChunk.getFirst()).contains(keyTrigger.toLowerCase()) || ((String)migrationChunk.getSecond()).equalsIgnoreCase(KeyConverter.ConversionMode.Unknown.name())) continue;
                                            int migratedKeyCode = KeyConverter.convertKey(boolData.getSecond(), KeyConverter.ConversionMode.valueOf((String)migrationChunk.getSecond()));
                                            if (!skipLogging && migratedKeyCode != boolData.getSecond()) {
                                                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.apply", ((List)migrationChunk.getFirst()).toString(), migrationChunk.getSecond(), propertyName, boolData.getSecond(), migratedKeyCode), new Object[0]);
                                            }
                                            fieldObject = migratedKeyCode;
                                            break block22;
                                        }
                                        break;
                                    }
                                    if (fieldObject == null) {
                                        fieldObject = boolData.getSecond();
                                    }
                                } else if (!this.avoidanceFilter.contains(propertyName)) {
                                    if (!skipLogging) {
                                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                    }
                                    fieldObject = defaultValue;
                                }
                            } else if (expectedClass == String[].class) {
                                String convertedString = StringUtils.removeMatches(StringUtils.getMatches("\\[([^\\s]+?)\\]", foundProperty), null, 1);
                                if (!StringUtils.isNullOrEmpty(convertedString) && convertedString.startsWith("[") && convertedString.endsWith("]")) {
                                    String preArrayString = convertedString.replaceAll("\\[", "").replaceAll("]", "");
                                    fieldObject = preArrayString.contains(", ") ? preArrayString.split(", ") : (preArrayString.contains(",") ? preArrayString.split(",") : new String[]{preArrayString});
                                }
                            } else if (!this.avoidanceFilter.contains(propertyName)) {
                                if (!skipLogging) {
                                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                                }
                                fieldObject = defaultValue;
                            }
                            if (fieldObject == null) break block104;
                            fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                        }
                        catch (Throwable throwable) {
                            if (fieldObject != null) {
                                fieldObject = this.syncMigrationData(skipLogging, migrationData, configProperty, fieldObject, foundProperty, propertyName, defaultValue);
                                StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                            }
                            throw throwable;
                        }
                        StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                        break block104;
                    }
                    StringUtils.updateField(this.getClass(), CraftPresence.CONFIG, new Tuple<String, Object, Object>(configProperty.getSecond(), fieldObject, null));
                    break block104;
                }
                if (!this.avoidanceFilter.contains(propertyName) && !skipLogging) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.prop.empty", propertyName), new Object[0]);
                    for (String globalTrigger : this.globalTriggers) {
                        if (!propertyName.toLowerCase().contains(globalTrigger.toLowerCase())) continue;
                        shouldRefreshLater = true;
                        break;
                    }
                }
            }
            ++currentIndex;
        }
        for (String remainingProp : propertyList) {
            if (!skipLogging) {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.prop.invalid", remainingProp), new Object[0]);
            }
            this.properties.remove(remainingProp);
            this.save("UTF-8");
        }
        this.updateConfig(shouldRefreshLater);
        try {
            if (configReader != null) {
                ((Reader)configReader).close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            if (!skipLogging) {
                if (this.isConfigNew) {
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.new", new Object[0]), new Object[0]);
                } else {
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.save", new Object[0]), new Object[0]);
                }
            }
        }
    }

    private Object syncMigrationData(boolean skipLogging, List<Pair<List<String>, String>> migrationData, Pair<String, String> configProperty, Object fieldObject, Object foundProperty, String propertyName, Object defaultValue) {
        Object finalFieldObject = fieldObject;
        for (String globalTrigger : this.globalTriggers) {
            if (!configProperty.getSecond().toLowerCase().contains(globalTrigger.toLowerCase())) continue;
            if (!skipLogging && !finalFieldObject.toString().equals(defaultValue.toString())) {
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.adjust.global", propertyName), new Object[0]);
            }
            if (propertyName.equals(this.NAME_lastMcVersionId)) {
                int defaultParseValue;
                int currentParseValue;
                block19: {
                    currentParseValue = -1;
                    defaultParseValue = Integer.parseInt(defaultValue.toString());
                    try {
                        currentParseValue = Integer.parseInt(finalFieldObject.toString());
                    }
                    catch (Error | Exception ex) {
                        if (!ModUtils.IS_VERBOSE) break block19;
                        ex.printStackTrace();
                    }
                }
                String keyCodeMigrationId = KeyConverter.ConversionMode.Unknown.name();
                String languageMigrationId = TranslationUtils.ConversionMode.Unknown.name();
                if (currentParseValue <= 340 && defaultParseValue > 340) {
                    keyCodeMigrationId = KeyConverter.ConversionMode.Lwjgl3.name();
                } else if (currentParseValue > 340 && defaultParseValue <= 340) {
                    keyCodeMigrationId = KeyConverter.ConversionMode.Lwjgl2.name();
                } else if (currentParseValue >= 0 && defaultParseValue >= 0) {
                    keyCodeMigrationId = KeyConverter.ConversionMode.None.name();
                }
                if (currentParseValue < 315 && defaultParseValue >= 315) {
                    languageMigrationId = TranslationUtils.ConversionMode.PackFormat3.name();
                } else if (currentParseValue >= 315 && defaultParseValue < 315) {
                    languageMigrationId = TranslationUtils.ConversionMode.PackFormat2.name();
                } else if (currentParseValue >= 0 && defaultParseValue >= 0) {
                    languageMigrationId = TranslationUtils.ConversionMode.None.name();
                }
                if (!skipLogging) {
                    ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.add", Arrays.asList(this.keyCodeTriggers).toString(), keyCodeMigrationId, keyCodeMigrationId.equals(KeyConverter.ConversionMode.None.name()) ? "Verification" : "Setting Change"), new Object[0]);
                    ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.add", Arrays.asList(this.languageTriggers).toString(), languageMigrationId, languageMigrationId.equals(TranslationUtils.ConversionMode.None.name()) ? "Verification" : "Setting Change"), new Object[0]);
                }
                migrationData.add(new Pair<List<String>, String>(Arrays.asList(this.keyCodeTriggers), keyCodeMigrationId));
                migrationData.add(new Pair<List<String>, String>(Arrays.asList(this.languageTriggers), languageMigrationId));
            }
            finalFieldObject = defaultValue;
            break;
        }
        block3: for (String langTrigger : this.languageTriggers) {
            if (!configProperty.getSecond().toLowerCase().contains(langTrigger.toLowerCase())) continue;
            for (Pair<List<String>, String> migrationChunk : migrationData) {
                if (!migrationChunk.getFirst().contains(langTrigger.toLowerCase()) || migrationChunk.getSecond().equalsIgnoreCase(TranslationUtils.ConversionMode.Unknown.name())) continue;
                String migratedLanguageId = TranslationUtils.convertId(foundProperty.toString(), TranslationUtils.ConversionMode.valueOf(migrationChunk.getSecond()));
                if (!skipLogging && !migratedLanguageId.equals(foundProperty.toString())) {
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.migration.apply", migrationChunk.getFirst().toString(), migrationChunk.getSecond(), propertyName, foundProperty.toString(), migratedLanguageId), new Object[0]);
                }
                finalFieldObject = migratedLanguageId;
                break block3;
            }
            break;
        }
        return finalFieldObject;
    }

    public void updateConfig(boolean shouldDataSync) {
        boolean needsDataSync = shouldDataSync;
        this.syncMappings();
        for (Pair<String, Object> configDataSet : this.configDataMappings) {
            Class<?> expectedClass = configDataSet.getSecond().getClass();
            try {
                String finalOutput;
                if (expectedClass == String[].class) {
                    boolean defaultFound;
                    Object[] finalArray = (String[])configDataSet.getSecond();
                    boolean bl = defaultFound = !StringUtils.isNullOrEmpty(StringUtils.getConfigPart((String[])finalArray, "default", 0, 1, this.splitCharacter, null));
                    if (!defaultFound) {
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.missing.default", configDataSet.getFirst()), new Object[0]);
                        finalArray = StringUtils.addToArray((String[])finalArray, finalArray.length, "default" + this.splitCharacter + "NaN");
                        needsDataSync = true;
                    }
                    finalOutput = Arrays.toString(finalArray);
                } else {
                    finalOutput = configDataSet.getSecond().toString();
                }
                if (!StringUtils.isNullOrEmpty(this.queuedSplitCharacter) && finalOutput.contains(this.splitCharacter) && !Arrays.asList(this.blackListedCharacters).contains(this.queuedSplitCharacter)) {
                    finalOutput = finalOutput.replace(this.splitCharacter, this.queuedSplitCharacter);
                    needsDataSync = true;
                }
                this.properties.setProperty(configDataSet.getFirst(), finalOutput);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (!StringUtils.isNullOrEmpty(this.queuedSplitCharacter) && !Arrays.asList(this.blackListedCharacters).contains(this.queuedSplitCharacter)) {
            this.splitCharacter = this.queuedSplitCharacter;
            this.queuedSplitCharacter = null;
        }
        this.save("UTF-8");
        if (needsDataSync) {
            this.read(true, "UTF-8");
        }
    }

    public void save(String encoding) {
        OutputStreamWriter configWriter = null;
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(this.configFile);
            configWriter = new OutputStreamWriter((OutputStream)outputStream, Charset.forName(encoding));
            this.properties.store(configWriter, ModUtils.TRANSLATOR.translate(true, "gui.config.title", new Object[0]) + "\n" + ModUtils.TRANSLATOR.translate(true, "gui.config.comment.title", "v1.8.3-GTNH", 2) + "\n\n" + ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.config.notice", new Object[0]));
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.config.save", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        try {
            if (configWriter != null) {
                ((Writer)configWriter).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.data.close", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
    }
}

