/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.util;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

public class DefaultLibraries {
    public static boolean isDefaultLibrary(File file) {
        String[] prefixes;
        String home = System.getProperty("java.home");
        if (home != null && file.getAbsolutePath().startsWith(home)) {
            return true;
        }
        String name = file.getName();
        if (!name.endsWith(".jar")) {
            return false;
        }
        for (String s : prefixes = new String[]{"launchwrapper-", "asm-all-", "akka-actor_2.11-", "config-", "scala-", "jopt-simple-", "lzma-", "realms-", "httpclient-", "httpcore-", "vecmath-", "trove4j-", "icu4j-core-mojang-", "codecjorbis-", "codecwav-", "libraryjavawound-", "librarylwjglopenal-", "soundsystem-", "netty-all-", "guava-", "commons-lang3-", "commons-compress-", "commons-logging-", "commons-io-", "commons-codec-", "jinput-", "jutils-", "gson-", "authlib-", "log4j-api-", "log4j-core-", "lwjgl-", "lwjgl_util-", "twitch-", "jline-", "jna-", "platform-", "oshi-core-", "netty-", "libraryjavasound-", "fastutil-", "lombok-"}) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefaultLibrary(URL url) {
        try {
            return DefaultLibraries.isDefaultLibrary(new File(url.toURI()));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

