/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.util;

import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.ICustomLadder;
import com.thecodewarrior.catwalks.block.BlockCatwalk;
import com.thecodewarrior.catwalks.block.BlockScaffold;
import com.thecodewarrior.catwalks.util.CatwalkEntityProperties;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import com.thecodewarrior.catwalks.util.CustomLadderRegistry;
import com.thecodewarrior.catwalks.util.Predicate;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.BlockEvent;

public class CommonProxy {
    public boolean isClient = false;
    public LinkedList<WeakReference<EntityLivingBase>> entities = new LinkedList();

    public void init() {
        this.initClient();
    }

    public void initClient() {
    }

    public void spawnCustomParticle(String name, World world, double x, double y, double z) {
    }

    public void postInit() {
    }

    public EntityPlayer getPlayerLooking(Vec3 start, Vec3 end) {
        EntityPlayerMP player = null;
        List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
        for (EntityPlayerMP p : players) {
            Vec3 lookStart = RayTracer.getStartVec((EntityPlayer)p);
            Vec3 lookEnd = RayTracer.getEndVec((EntityPlayer)p);
            double lookDistance = RayTracer.getBlockReachDistance((EntityPlayer)p);
            double dStart = lookStart.func_72438_d(start);
            double dEnd = lookEnd.func_72438_d(start);
            double dStart_ = lookStart.func_72438_d(end);
            double dEnd_ = lookEnd.func_72438_d(end);
            if (dStart + dEnd != lookDistance || dStart_ + dEnd_ != lookDistance) continue;
            player = p;
            break;
        }
        return player;
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        BlockCoord coord = this.getLadderCoord(event.entityLiving);
        EntityLivingBase e = event.entityLiving;
        CatwalkEntityProperties catwalkEP = CatwalkUtil.getOrCreateEP(event.entity);
        if (coord.y >= 0) {
            Block b = event.entity.field_70170_p.func_147439_a(coord.x, coord.y, coord.z);
            ICustomLadder icl = CustomLadderRegistry.getCustomLadderOrNull(b);
            double upSpeed = icl.getLadderVelocity((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e);
            double downSpeed = icl.getLadderFallVelocity((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e);
            double motY = e.field_70163_u - catwalkEP.lastPosY;
            if (e.field_70123_F) {
                if (e.field_70181_x < upSpeed) {
                    e.field_70181_x = upSpeed;
                    catwalkEP.highSpeedLadder = true;
                }
            } else {
                if (downSpeed > 0.0) {
                    e.field_70143_R = 0.0f;
                }
                if (downSpeed > 0.0 && e.field_70181_x < -downSpeed) {
                    e.field_70181_x = -downSpeed;
                }
                boolean shouldStopOnLadder = icl.shouldHoldOn((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e);
                boolean shouldClimbDown = icl.shouldClimbDown((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e);
                double climbDownSpeed = icl.getClimbDownVelocity((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e);
                if (shouldStopOnLadder && !shouldClimbDown && e.field_70181_x < 0.0) {
                    e.field_70181_x = 0.0;
                }
                if (shouldClimbDown && e.field_70181_x <= 0.0) {
                    e.field_70181_x = -climbDownSpeed;
                }
            }
            if (motY >= 0.0) {
                e.field_70143_R = 0.0f;
            }
            double dY = e.field_70163_u - catwalkEP.lastStepY;
            double distanceClimbed = Math.abs(dY);
            double distanceRequired = upSpeed * 10.0;
            if (catwalkEP.isSlidingDownLadder && dY >= 0.0) {
                distanceRequired = 0.0;
            }
            boolean bl = catwalkEP.isSlidingDownLadder = dY < 0.0;
            if (distanceClimbed > distanceRequired && distanceRequired > 0.0) {
                boolean shouldPlay;
                catwalkEP.lastStepX = e.field_70165_t;
                catwalkEP.lastStepY = e.field_70163_u;
                catwalkEP.lastStepZ = e.field_70161_v;
                boolean bl2 = shouldPlay = dY < 0.0 ? icl.shouldPlayStepSound((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e, true) : icl.shouldPlayStepSound((IBlockAccess)e.field_70170_p, coord.x, coord.y, coord.z, e, false);
                if (shouldPlay) {
                    Block.SoundType soundtype = e.field_70170_p.func_147439_a((int)coord.x, (int)coord.y, (int)coord.z).field_149762_H;
                    e.func_85030_a(soundtype.func_150498_e(), soundtype.func_150497_c() * 0.15f, soundtype.func_150494_d());
                }
            }
        }
        catwalkEP.lastPosX = e.field_70165_t;
        catwalkEP.lastPosY = e.field_70163_u;
        catwalkEP.lastPosZ = e.field_70161_v;
        if (catwalkEP.highSpeedLadder && !event.entityLiving.field_70123_F) {
            if (event.entity.field_70181_x > 0.2) {
                event.entity.field_70181_x = 0.2;
            }
            catwalkEP.highSpeedLadder = false;
        }
    }

    public BlockCoord getLadderCoord(EntityLivingBase entity) {
        return this.findCollidingBlock(entity, new Predicate<BlockCoord>(new Object[]{entity}){

            @Override
            public boolean test(BlockCoord bc) {
                EntityLivingBase ent = (EntityLivingBase)this.args[0];
                Block b = ent.field_70170_p.func_147439_a(bc.x, bc.y, bc.z);
                if (b == null) {
                    return false;
                }
                ICustomLadder icl = CustomLadderRegistry.getCustomLadderOrNull(b);
                if (icl == null) {
                    return false;
                }
                return icl.isOnLadder((IBlockAccess)ent.field_70170_p, bc.x, bc.y, bc.z, ent);
            }
        });
    }

    public BlockCoord findCollidingBlock(EntityLivingBase entity, Predicate<BlockCoord> mat) {
        World world = entity.field_70170_p;
        AxisAlignedBB bb = entity.field_70121_D;
        double buf = 9.765625E-4;
        int mX = MathHelper.func_76128_c((double)(bb.field_72340_a - buf));
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)(bb.field_72339_c - buf));
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d + buf) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f + buf) {
                    BlockCoord bc = new BlockCoord(x2, y2, z2);
                    if (mat.test(bc)) {
                        return bc;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return new BlockCoord(0, -1, 0);
    }

    private boolean isPlayerOnCatwalk(EntityPlayerMP player) {
        BlockCoord catwalkCoords = this.findCollidingBlock((EntityLivingBase)player, new Predicate<BlockCoord>(new Object[]{player}){

            @Override
            public boolean test(BlockCoord bc) {
                EntityPlayerMP player = (EntityPlayerMP)this.args[0];
                Block b = player.field_70170_p.func_147439_a(bc.x, bc.y, bc.z);
                return b instanceof BlockCatwalk;
            }
        });
        return catwalkCoords.y != -1;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        double catwalkSpeedBonus = CatwalkMod.speedModifier.func_111164_d() * (double)CatwalkMod.options.speedPotionLevel;
        if (event.phase == TickEvent.Phase.END) {
            List players = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b;
            for (EntityPlayerMP player : players) {
                boolean hasModifier;
                boolean shouldHaveModifier = this.isPlayerOnCatwalk(player);
                IAttributeInstance playerSpeedAttribute = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
                AttributeModifier catwalksModifier = playerSpeedAttribute.func_111127_a(CatwalkMod.speedModifier.func_111167_a());
                boolean bl = hasModifier = catwalksModifier != null;
                if (hasModifier) {
                    if (!shouldHaveModifier) {
                        playerSpeedAttribute.func_111124_b(CatwalkMod.speedModifier);
                        continue;
                    }
                    if (catwalksModifier.func_111164_d() != catwalkSpeedBonus) {
                        playerSpeedAttribute.func_111124_b(CatwalkMod.speedModifier);
                        hasModifier = false;
                    }
                }
                if (!shouldHaveModifier || hasModifier) continue;
                catwalksModifier = new AttributeModifier(CatwalkMod.speedModifier.func_111167_a(), "catwalkmod.speedup", catwalkSpeedBonus, 2);
                catwalksModifier.func_111168_a(false);
                playerSpeedAttribute.func_111121_a(catwalksModifier);
            }
        }
    }

    @SubscribeEvent
    public void blockPlaceEvent(BlockEvent.PlaceEvent event) {
        if (event.blockSnapshot.replacedBlock instanceof BlockScaffold) {
            CatwalkUtil.giveItemsToPlayer(event.player, event.blockSnapshot.replacedBlock.getDrops(event.world, event.x, event.y, event.z, event.blockMetadata, 0));
        }
    }
}

