/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.forestry.pipes;

import buildcraft.BuildCraftCompat;
import buildcraft.compat.forestry.pipes.EnumFilterType;
import buildcraft.compat.forestry.pipes.network.PacketGenomeFilterChange;
import buildcraft.compat.forestry.pipes.network.PacketRequestFilterSet;
import buildcraft.compat.forestry.pipes.network.PacketTypeFilterChange;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketNBT;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeLogicPropolis {
    private final Pipe<PipeTransportItems> pipe;
    private final EnumFilterType[] typeFilter = new EnumFilterType[6];
    private final IAllele[][][] genomeFilter = new IAllele[6][3][2];

    public PipeLogicPropolis(Pipe<PipeTransportItems> pipe) {
        this.pipe = pipe;
        for (int i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.CLOSED;
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        int i;
        for (i = 0; i < this.typeFilter.length; ++i) {
            this.typeFilter[i] = EnumFilterType.values()[nbttagcompound.func_74771_c("TypeFilter" + i)];
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (nbttagcompound.func_74764_b("GenomeFilterS" + i + '-' + j + '-' + 0)) {
                    this.genomeFilter[i][j][0] = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i("GenomeFilterS" + i + '-' + j + '-' + 0));
                }
                if (!nbttagcompound.func_74764_b("GenomeFilterS" + i + '-' + j + '-' + 1)) continue;
                this.genomeFilter[i][j][1] = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i("GenomeFilterS" + i + '-' + j + '-' + 1));
            }
        }
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        int i;
        for (i = 0; i < this.typeFilter.length; ++i) {
            nbttagcompound.func_74774_a("TypeFilter" + i, (byte)this.typeFilter[i].ordinal());
        }
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.genomeFilter[i][j][0] != null) {
                    nbttagcompound.func_74778_a("GenomeFilterS" + i + '-' + j + '-' + 0, this.genomeFilter[i][j][0].getUID());
                }
                if (this.genomeFilter[i][j][1] == null) continue;
                nbttagcompound.func_74778_a("GenomeFilterS" + i + '-' + j + '-' + 1, this.genomeFilter[i][j][1].getUID());
            }
        }
    }

    public boolean isClosed(ForgeDirection orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.CLOSED;
    }

    public boolean isIndiscriminate(ForgeDirection orientation) {
        return this.typeFilter[orientation.ordinal()] == EnumFilterType.ANYTHING;
    }

    public boolean matchType(ForgeDirection orientation, EnumFilterType type, IBee bee) {
        EnumFilterType filter = this.typeFilter[orientation.ordinal()];
        if (filter == EnumFilterType.BEE) {
            return type != EnumFilterType.ITEM && type != EnumFilterType.CLOSED;
        }
        if (bee != null) {
            if (filter == EnumFilterType.PURE_BREED) {
                return bee.isPureBred((IChromosomeType)EnumBeeChromosome.SPECIES);
            }
            if (filter == EnumFilterType.NOCTURNAL) {
                return bee.getGenome().getNocturnal();
            }
            if (filter == EnumFilterType.PURE_NOCTURNAL) {
                return bee.getGenome().getNocturnal() && bee.isPureBred((IChromosomeType)EnumBeeChromosome.NOCTURNAL);
            }
            if (filter == EnumFilterType.FLYER) {
                return bee.getGenome().getTolerantFlyer();
            }
            if (filter == EnumFilterType.PURE_FLYER) {
                return bee.getGenome().getTolerantFlyer() && bee.isPureBred((IChromosomeType)EnumBeeChromosome.TOLERANT_FLYER);
            }
            if (filter == EnumFilterType.CAVE) {
                return bee.getGenome().getCaveDwelling();
            }
            if (filter == EnumFilterType.PURE_CAVE) {
                return bee.getGenome().getCaveDwelling() && bee.isPureBred((IChromosomeType)EnumBeeChromosome.CAVE_DWELLING);
            }
            if (filter == EnumFilterType.NATURAL) {
                return bee.isNatural();
            }
        }
        return filter == type;
    }

    public ArrayList<IAllele[]> getGenomeFilters(ForgeDirection orientation) {
        ArrayList<IAllele[]> filters = new ArrayList<IAllele[]>();
        for (int i = 0; i < 3; ++i) {
            if (this.genomeFilter[orientation.ordinal()][i] == null || this.genomeFilter[orientation.ordinal()][i][0] == null && this.genomeFilter[orientation.ordinal()][i][1] == null) continue;
            filters.add(this.genomeFilter[orientation.ordinal()][i]);
        }
        return filters;
    }

    public EnumFilterType getTypeFilter(ForgeDirection orientation) {
        return this.typeFilter[orientation.ordinal()];
    }

    public void setTypeFilter(ForgeDirection orientation, EnumFilterType type) {
        this.typeFilter[orientation.ordinal()] = type;
        if (this.pipe.getWorld().field_72995_K) {
            this.sendTypeFilterChange(orientation, type);
        }
    }

    public IAlleleSpecies getSpeciesFilter(ForgeDirection orientation, int pattern, int allele) {
        if (this.genomeFilter[orientation.ordinal()] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()].length <= pattern) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern] == null) {
            return null;
        }
        if (this.genomeFilter[orientation.ordinal()][pattern].length <= allele) {
            return null;
        }
        return (IAlleleSpecies)this.genomeFilter[orientation.ordinal()][pattern][allele];
    }

    public void setSpeciesFilter(ForgeDirection orientation, int pattern, int allele, IAllele species) {
        this.genomeFilter[orientation.ordinal()][pattern][allele] = species;
        if (this.pipe.getWorld().field_72995_K) {
            this.sendGenomeFilterChange(orientation, pattern, allele, species);
        }
    }

    public void sendFilterSet(EntityPlayer player) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        PacketNBT packet = new PacketNBT(120, nbttagcompound, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        BuildCraftCompat.instance.sendToPlayer(player, (Packet)packet);
    }

    public void handleFilterSet(PacketNBT packet) {
        this.readFromNBT(packet.getTagCompound());
    }

    public void requestFilterSet() {
        TileGenericPipe pipeTile = this.pipe.container;
        PacketRequestFilterSet packet = new PacketRequestFilterSet(pipeTile.field_145851_c, pipeTile.field_145848_d, pipeTile.field_145849_e);
        BuildCraftCompat.instance.sendToServer((Packet)packet);
    }

    public void sendTypeFilterChange(ForgeDirection orientation, EnumFilterType filter) {
        PacketTypeFilterChange packet = new PacketTypeFilterChange((TileEntity)this.pipe.container, orientation, filter);
        BuildCraftCompat.instance.sendToServer((Packet)packet);
    }

    public void handleTypeFilterChange(PacketTypeFilterChange packet) {
        int orientation = packet.getOrientation();
        int filterOrdinal = packet.getFilter();
        this.typeFilter[orientation] = EnumFilterType.values()[filterOrdinal];
    }

    public void sendGenomeFilterChange(ForgeDirection orientation, int pattern, int allele, IAllele species) {
        PacketGenomeFilterChange packet = new PacketGenomeFilterChange((TileEntity)this.pipe.container, orientation, pattern, allele, species);
        BuildCraftCompat.instance.sendToServer((Packet)packet);
    }

    public void handleGenomeFilterChange(PacketGenomeFilterChange packet) {
        IAllele species = packet.getSpecies();
        int orientation = packet.getOrientation();
        int pattern = packet.getPattern();
        int allele = packet.getAllele();
        this.genomeFilter[orientation][pattern][allele] = species;
    }
}

