/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.compat.forestry.pipes.gui;

import buildcraft.compat.CompatModuleForestry;
import buildcraft.compat.forestry.pipes.EnumFilterType;
import buildcraft.compat.forestry.pipes.PipeItemsPropolis;
import buildcraft.compat.forestry.pipes.PipeLogicPropolis;
import buildcraft.compat.forestry.pipes.gui.ContainerPropolisPipe;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.gui.widgets.Widget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiPropolisPipe
extends GuiBuildCraft {
    private static final ResourceLocation texture = new ResourceLocation("buildcraftcompat", "textures/gui/propolisPipe.png");
    private final PipeLogicPropolis pipeLogic;

    public GuiPropolisPipe(EntityPlayer player, PipeItemsPropolis pipe) {
        super((BuildCraftContainer)new ContainerPropolisPipe((IInventory)player.field_71071_by, pipe), null, texture);
        this.pipeLogic = pipe.pipeLogic;
        if (pipe.getWorld().field_72995_K) {
            this.pipeLogic.requestFilterSet();
        }
        this.field_146999_f = 175;
        this.field_147000_g = 225;
        for (int i = 0; i < 6; ++i) {
            this.container.addWidget((Widget)new TypeFilterSlot(8, 18 + i * 18, ForgeDirection.values()[i], this.pipeLogic));
        }
        IApiaristTracker tracker = CompatModuleForestry.beeRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
        for (int i = 0; i < 6; ++i) {
            for (int pattern = 0; pattern < 3; ++pattern) {
                for (int allele = 0; allele < 2; ++allele) {
                    int x = 44 + pattern * 45 + allele * 18;
                    int y = 18 + i * 18;
                    this.container.addWidget((Widget)new SpeciesFilterSlot(tracker, x, y, ForgeDirection.values()[i], pattern, allele, this.pipeLogic));
                }
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String title = StatCollector.func_74838_a((String)"item.buildcraftPipe.pipeitemspropolis.name");
        this.field_146289_q.func_78276_b(title, this.getCenteredOffset(title), 6, 0x303030);
    }

    class SpeciesFilterSlot
    extends Widget {
        private final IApiaristTracker tracker;
        private final ForgeDirection orientation;
        private final PipeLogicPropolis logic;
        private final int pattern;
        private final int allele;
        private final ToolTip toolTip;

        public SpeciesFilterSlot(IApiaristTracker tracker, int x, int y, ForgeDirection orientation, int pattern, int allele, PipeLogicPropolis logic) {
            super(x, y, 0, 0, 16, 16);
            this.toolTip = new ToolTip(new ToolTipLine[0]){

                public void refresh() {
                    SpeciesFilterSlot.this.refreshTooltip();
                }
            };
            this.tracker = tracker;
            this.orientation = orientation;
            this.pattern = pattern;
            this.allele = allele;
            this.logic = logic;
        }

        public IAlleleSpecies getSpecies() {
            return this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
        }

        public boolean isDefined() {
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            return species != null;
        }

        @SideOnly(value=Side.CLIENT)
        public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
            if (!this.isDefined()) {
                return;
            }
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            GL11.glDisable((int)2896);
            gui.bindTexture(TextureMap.field_110576_c);
            for (int i = 0; i < 3; ++i) {
                IAlleleBeeSpecies beeSpecies = (IAlleleBeeSpecies)species;
                IIcon icon = beeSpecies.getIcon(EnumBeeType.DRONE, i);
                int color = beeSpecies.getIconColour(i);
                float colorR = (float)(color >> 16 & 0xFF) / 255.0f;
                float colorG = (float)(color >> 8 & 0xFF) / 255.0f;
                float colorB = (float)(color & 0xFF) / 255.0f;
                GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
                gui.func_94065_a(guiX + this.x, guiY + this.y, icon, this.w, this.h);
            }
            GL11.glEnable((int)2896);
        }

        private void refreshTooltip() {
            this.toolTip.clear();
            IAlleleSpecies species = this.logic.getSpeciesFilter(this.orientation, this.pattern, this.allele);
            if (species != null) {
                String speciesName = species.getName();
                this.toolTip.add((Object)new ToolTipLine(speciesName));
            }
        }

        public ToolTip getToolTip() {
            return this.toolTip;
        }

        public boolean handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            IAlleleBeeSpecies change;
            block7: {
                change = null;
                if (mouseButton == 1) {
                    change = null;
                } else if (this.getSpecies() == null) {
                    for (Map.Entry entry : AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet()) {
                        if (!(entry.getValue() instanceof IAlleleBeeSpecies)) continue;
                        change = (IAlleleBeeSpecies)entry.getValue();
                        break;
                    }
                } else {
                    Iterator it = AlleleManager.alleleRegistry.getRegisteredAlleles().entrySet().iterator();
                    while (it.hasNext()) {
                        IAlleleBeeSpecies species;
                        Map.Entry entry = it.next();
                        if (!(entry.getValue() instanceof IAlleleBeeSpecies) || !(species = (IAlleleBeeSpecies)entry.getValue()).getUID().equals(this.getSpecies().getUID())) continue;
                        while (it.hasNext()) {
                            IAlleleBeeSpecies next;
                            Map.Entry entry2 = it.next();
                            if (!(entry2.getValue() instanceof IAlleleBeeSpecies)) continue;
                            change = next = (IAlleleBeeSpecies)entry2.getValue();
                            break block7;
                        }
                        break;
                    }
                }
            }
            GuiPropolisPipe.this.pipeLogic.setSpeciesFilter(this.orientation, this.pattern, this.allele, (IAllele)change);
            return true;
        }
    }

    class TypeFilterSlot
    extends Widget {
        private final ForgeDirection orientation;
        private final PipeLogicPropolis logic;
        private final ToolTip toolTip;

        public TypeFilterSlot(int x, int y, ForgeDirection orientation, PipeLogicPropolis logic) {
            super(x, y, 0, 0, 16, 16);
            this.toolTip = new ToolTip(new ToolTipLine[0]){

                public void refresh() {
                    TypeFilterSlot.this.refreshTooltip();
                }
            };
            this.orientation = orientation;
            this.logic = logic;
        }

        public EnumFilterType getType() {
            return this.logic.getTypeFilter(this.orientation);
        }

        @SideOnly(value=Side.CLIENT)
        public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
            EnumFilterType type = this.logic.getTypeFilter(this.orientation);
            IIcon icon = null;
            if (type != null) {
                icon = type.getIcon();
            }
            if (icon == null) {
                return;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            gui.bindTexture(TextureMap.field_110576_c);
            gui.func_94065_a(guiX + this.x, guiY + this.y, icon, this.w, this.h);
        }

        private void refreshTooltip() {
            this.toolTip.clear();
            EnumFilterType type = this.logic.getTypeFilter(this.orientation);
            String filterName = StatCollector.func_74838_a((String)("for.gui.pipe.filter." + type.toString().toLowerCase(Locale.ENGLISH)));
            this.toolTip.add((Object)new ToolTipLine(filterName));
        }

        @SideOnly(value=Side.CLIENT)
        public ToolTip getToolTip() {
            return this.toolTip;
        }

        public boolean handleMouseClick(int mouseX, int mouseY, int mouseButton) {
            EnumFilterType change = mouseButton == 1 ? EnumFilterType.CLOSED : (this.getType().ordinal() < EnumFilterType.values().length - 1 ? EnumFilterType.values()[this.getType().ordinal() + 1] : EnumFilterType.CLOSED);
            GuiPropolisPipe.this.pipeLogic.setTypeFilter(this.orientation, change);
            return true;
        }
    }
}

