/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.filters.SimpleFluidFilter;
import buildcraft.robotics.statements.ActionRobotFilter;
import buildcraft.robotics.statements.ActionStationAcceptFluids;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class AIRobotUnloadFluids
extends AIRobot {
    private int waitedCycles = 0;

    public AIRobotUnloadFluids(EntityRobotBase iRobot) {
        super(iRobot);
        this.setSuccess(false);
    }

    @Override
    public void update() {
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            if (AIRobotUnloadFluids.unload(this.robot, this.robot.getDockingStation(), true) == 0) {
                this.terminate();
            } else {
                this.setSuccess(true);
            }
        }
    }

    public static int unload(EntityRobotBase robot, DockingStation station, boolean doUnload) {
        if (station == null) {
            return 0;
        }
        if (!ActionRobotFilter.canInteractWithFluid(station, new SimpleFluidFilter(robot.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid), ActionStationAcceptFluids.class)) {
            return 0;
        }
        IFluidHandler fluidHandler = station.getFluidOutput();
        if (fluidHandler == null) {
            return 0;
        }
        FluidStack drainable = robot.drain(ForgeDirection.UNKNOWN, 1000, false);
        if (drainable == null) {
            return 0;
        }
        drainable = drainable.copy();
        int filled = fluidHandler.fill(station.getFluidOutputSide(), drainable, doUnload);
        if (filled > 0 && doUnload) {
            drainable.amount = filled;
            robot.drain(ForgeDirection.UNKNOWN, drainable, true);
        }
        return filled;
    }

    @Override
    public int getEnergyCost() {
        return 10;
    }
}

