/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.power.IRedstoneEngine;
import buildcraft.api.power.IRedstoneEngineReceiver;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.lib.engines.TileEngineBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEngineWood
extends TileEngineBase
implements IRedstoneEngine {
    private boolean hasSent = false;

    @Override
    public ResourceLocation getTrunkTexture(TileEngineBase.EnergyStage stage) {
        return super.getTrunkTexture(stage == TileEngineBase.EnergyStage.RED && (double)this.progress < 0.5 ? TileEngineBase.EnergyStage.YELLOW : stage);
    }

    @Override
    protected TileEngineBase.EnergyStage computeEnergyStage() {
        double energyLevel = this.getEnergyLevel();
        if (energyLevel < (double)0.33f) {
            return TileEngineBase.EnergyStage.BLUE;
        }
        if (energyLevel < (double)0.66f) {
            return TileEngineBase.EnergyStage.GREEN;
        }
        if (energyLevel < 0.75) {
            return TileEngineBase.EnergyStage.YELLOW;
        }
        return TileEngineBase.EnergyStage.RED;
    }

    @Override
    public int getCurrentOutputLimit() {
        return 10;
    }

    @Override
    public float getPistonSpeed() {
        if (!this.field_145850_b.field_72995_K) {
            return Math.max(0.08f * this.getHeatLevel(), 0.01f);
        }
        switch (this.getEnergyStage()) {
            case GREEN: {
                return 0.02f;
            }
            case YELLOW: {
                return 0.04f;
            }
            case RED: {
                return 0.08f;
            }
        }
        return 0.01f;
    }

    @Override
    public void engineUpdate() {
        super.engineUpdate();
        if (this.isRedstonePowered && this.field_145850_b.func_82737_E() % 16L == 0L) {
            this.addEnergy(10);
        }
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, ForgeDirection with) {
        return IPipeConnection.ConnectOverride.DISCONNECT;
    }

    @Override
    public boolean isBurning() {
        return this.isRedstonePowered;
    }

    @Override
    public int getMaxEnergy() {
        return 1000;
    }

    @Override
    public int getIdealOutput() {
        return 10;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return false;
    }

    @Override
    public int getEnergyStored(ForgeDirection side) {
        return 0;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection side) {
        return 0;
    }

    @Override
    protected void sendPower() {
        if (this.progressPart == 2 && !this.hasSent) {
            this.hasSent = true;
            TileEntity tile = this.getTile(this.orientation);
            if (tile instanceof IRedstoneEngineReceiver && ((IRedstoneEngineReceiver)tile).canConnectRedstoneEngine(this.orientation.getOpposite())) {
                super.sendPower();
            } else {
                this.energy = 0;
            }
        } else if (this.progressPart != 2) {
            this.hasSent = false;
        }
    }
}

