/*
 * Decompiled with CFR 0.152.
 */
package jss.bugtorch.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jss.bugtorch.config.BugTorchConfig;
import jss.bugtorch.core.BugTorchCore;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import ru.timeconqueror.spongemixins.MinecraftURLClassPath;

public class BugTorchMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            if (BugTorchConfig.ganysSurfaceJarName.equals("d") || !BugTorchMixinPlugin.loadJar(BugTorchConfig.ganysSurfaceJarName, "Gany's Surface")) {
                BugTorchConfig.fixGanysSurfaceOpenTrapdoorBackTexture = false;
            }
            if (BugTorchConfig.thaumcraftJarName.equals("d") || !BugTorchMixinPlugin.loadJar(BugTorchConfig.thaumcraftJarName, "Thaumcraft")) {
                BugTorchConfig.fixThaumcraftCandleColorArrayOutOfBounds = false;
            }
            if (BugTorchConfig.witcheryJarName.equals("d") || !BugTorchMixinPlugin.loadJar(BugTorchConfig.witcheryJarName, "Witchery")) {
                BugTorchConfig.fixWitcheryGarlicGarlandBlockBounds = false;
                BugTorchConfig.fixWitcheryLeavesShearDupeAndOptifineRendering = false;
            }
            if (BugTorchConfig.aetherIIJarName.equals("d") || !BugTorchMixinPlugin.loadJar(BugTorchConfig.aetherIIJarName, "The Aether II")) {
                BugTorchConfig.reuseAetherIIRenderPlayer = false;
            }
        }
        if (BugTorchConfig.cobwebsCanBeSheared) {
            mixins.add("minecraft.block.MixinBlockWeb");
        }
        if (BugTorchConfig.deadBushesDropSticks) {
            mixins.add("minecraft.block.MixinBlockDeadBush");
        }
        if (BugTorchConfig.fireArrowsDetonateTNTCarts) {
            mixins.add("minecraft.entity.item.MixinEntityMinecartTNT");
        }
        if (BugTorchConfig.throwEnderPearlsInCrativeMode) {
            mixins.add("minecraft.item.MixinItemEnderPearl");
        }
        if (BugTorchConfig.fixEnchantmentBlendFunc) {
            mixins.add("minecraft.client.renderer.entity.MixinItemRenderer");
        }
        if (BugTorchConfig.fixFireChargeUseSound) {
            mixins.add("minecraft.item.MixinItemFireball");
        }
        if (BugTorchConfig.fixLavaHissOnAirReplace) {
            mixins.add("minecraft.block.MixinBlockLiquid");
        }
        if (BugTorchConfig.fixMineshaftAirPockets) {
            mixins.add("minecraft.world.gen.structure.MixinStructureStart");
            mixins.add("minecraft.world.gen.structure.MixinStructureMineshaftPieces$Room");
        }
        if (BugTorchConfig.fixNettyConnectionFailureResourceLeak) {
            mixins.add("netty.channel.socket.nio.MixinNioSocketChannel");
        }
        if (BugTorchConfig.fixPumpkinPlacementCheck) {
            mixins.add("minecraft.block.MixinBlockPumpkin");
        }
        if (BugTorchConfig.fixRedstoneTorchMemoryLeak) {
            mixins.add("minecraft.block.MixinBlockRedstoneTorch");
        }
        if (BugTorchConfig.fixStoneMonsterEggDoubleSpawns) {
            mixins.add("minecraft.block.MixinBlockSilverfish");
        }
        if (BugTorchConfig.fixShearedBlocksDropExtraItems) {
            mixins.add("minecraft.block.MixinBlockLeaves");
            mixins.add("minecraft.block.MixinBlockTallGrass");
        }
        if (BugTorchConfig.fixShearsNotTakingDamageFromNormalBlocks) {
            mixins.add("minecraft.item.MixinItemShears");
        }
        if (BugTorchConfig.fixSignPacketChatMessages) {
            mixins.add("minecraft.client.network.MixinNetHandlerPlayClient");
        }
        if (BugTorchConfig.fixVillagePathsHavePlantsOnTop) {
            mixins.add("minecraft.world.gen.structure.MixinStructureVillagePieces_Path");
        }
        if (BugTorchConfig.fixVillagerTradeMetadataDetection) {
            mixins.add("minecraft.inventory.MixinSlotMerchantResult");
            mixins.add("minecraft.village.MixinMerchantRecipe");
        }
        if (BugTorchConfig.fixVillageSieges) {
            mixins.add("minecraft.village.MixinVillageSiege");
        }
        if (BugTorchConfig.fixVillageWellDesertMaterial) {
            mixins.add("minecraft.world.gen.structure.MixinStructureVillagePieces_Well");
        }
        if (BugTorchConfig.brokenChestsDontSplitStacks) {
            mixins.add("minecraft.block.MixinBlockChest");
        }
        if (BugTorchConfig.brokenHoppersDontSplitStacks) {
            mixins.add("minecraft.block.MixinBlockHopper");
        }
        if (BugTorchConfig.fasterDroppedItemStackingChecks) {
            mixins.add("minecraft.entity.item.MixinEntityItem");
        }
        if (BugTorchConfig.fasterEntityLivingBaseIsPotionActiveAndSetAir) {
            mixins.add("minecraft.entity.MixinEntityLivingBase");
        }
        if (BugTorchConfig.fasterGetBlockByIdForAirBlocks) {
            mixins.add("minecraft.block.MixinBlock");
        }
        if (BugTorchConfig.fasterSnowBlockTicks) {
            mixins.add("minecraft.block.MixinBlockSnowBlock");
        }
        if (BugTorchConfig.moreAccurateLayeredSnowFaceCulling) {
            mixins.add("minecraft.block.MixinBlockSnow");
        }
        if (BugTorchConfig.replaceRandomInEffectRenderer) {
            mixins.add("random.client.particle.MixinEffectRenderer");
        }
        if (BugTorchConfig.replaceRandomInEntity) {
            mixins.add("random.entity.MixinEntity");
        }
        if (BugTorchConfig.replaceRandomInItem) {
            mixins.add("random.item.MixinItem");
        }
        if (BugTorchConfig.replaceRandomInMinecraftServer) {
            mixins.add("random.server.MixinMinecraftServer");
        }
        if (BugTorchConfig.replaceRandomInRenderItem) {
            mixins.add("random.client.renderer.entity.MixinRenderItem");
        }
        if (BugTorchConfig.replaceRandomInWorld) {
            BugTorchCore.logger.info("World.class will use a faster Random implementation, this impacts world generation slightly.");
            mixins.add("random.world.MixinWorld");
        }
        if (BugTorchConfig.replaceRandomInWorldClient) {
            mixins.add("random.client.multiplayer.MixinWorldClient");
        }
        if (BugTorchConfig.skipInitialWorldChunkLoad) {
            mixins.add("minecraft.server.MixinMinecraftServer");
        }
        if (BugTorchConfig.farmlandImprovements) {
            mixins.add("minecraft.block.MixinBlockFarmland");
        }
        if (BugTorchConfig.lanPortOverride) {
            mixins.add("minecraft.server.integrated.MixinIntegratedServer");
        }
        if (BugTorchConfig.placeEndPortalsAnywhere) {
            mixins.add("minecraft.block.MixinBlockEndPortal");
        }
        if (BugTorchConfig.placePressurePlatesOnAnyWallOrFence) {
            mixins.add("minecraft.block.MixinBlockBasePressurePlate");
        }
        if (BugTorchConfig.placeTorchesOnAnyFence) {
            mixins.add("minecraft.block.MixinBlockFence");
        }
        if (BugTorchConfig.placeTorchesOnAnyWall) {
            mixins.add("minecraft.block.MixinBlockWall");
        }
        if (BugTorchConfig.potionParticlesAreClearForClientPlayer) {
            mixins.add("minecraft.entity.MixinEntityLivingBase2");
        }
        if (BugTorchConfig.removeEntityDuplicateExtendedPropertiesIdentifierSpam) {
            mixins.add("minecraft.entity.MixinEntity");
        }
        if (BugTorchConfig.fixGanysSurfaceOpenTrapdoorBackTexture) {
            mixins.add("ganyssurface.blocks.MixinBlockWoodTrapdoor");
        }
        if (BugTorchConfig.fixThaumcraftCandleColorArrayOutOfBounds) {
            mixins.add("thaumcraft.common.blocks.MixinBlockCandle");
        }
        if (BugTorchConfig.fixWitcheryGarlicGarlandBlockBounds) {
            mixins.add("witchery.blocks.MixinBlockGarlicGarland");
        }
        if (BugTorchConfig.fixWitcheryLeavesShearDupeAndOptifineRendering) {
            mixins.add("witchery.blocks.MixinBlockWitchLeaves");
        }
        if (BugTorchConfig.reuseAetherIIRenderPlayer) {
            mixins.add("aetherii.client.MixinClientEventHandler");
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static boolean loadJar(String jarName, String modName) {
        try {
            File jar = MinecraftURLClassPath.getJarInModPath((String)jarName);
            if (jar == null) {
                BugTorchCore.logger.info(modName + " jar not found: " + jarName);
                return false;
            }
            BugTorchCore.logger.info("Attempting to add " + jar.toString() + " to the URL Class Path");
            if (!jar.exists()) {
                throw new FileNotFoundException(jar.toString());
            }
            MinecraftURLClassPath.addJar((File)jar);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        String configFolder = "config" + File.separator + "bugtorch" + File.separator;
        BugTorchConfig.loadBaseMixinConfig(new File(Launch.minecraftHome, configFolder + "mixins.cfg"));
        BugTorchConfig.loadModdedMixinConfig(new File(Launch.minecraftHome, configFolder + "mixinsModSupport.cfg"));
    }
}

