/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.world;

import blockrenderer6343.client.world.DummyWorld;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.joml.Vector3f;

public class TrackedDummyWorld
extends DummyWorld {
    public final Long2ObjectMap<Block> blockMap = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<TileEntity> tileMap = new Long2ObjectOpenHashMap();
    public final Long2IntMap blockMetaMap = new Long2IntOpenHashMap();
    private final Vector3f minPos = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
    private final Vector3f maxPos = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);
    private final Vector3f size = new Vector3f();
    private boolean hasChanged;
    private int visibleYLevel = -1;

    public boolean func_147465_d(int x, int y, int z, Block block, int meta, int flags) {
        long pos = CoordinatePacker.pack((int)x, (int)y, (int)z);
        if (block == Blocks.field_150350_a) {
            this.blockMap.remove(pos);
            this.blockMetaMap.remove(pos);
            if (block.hasTileEntity(meta)) {
                this.func_147475_p(x, y, z);
            }
        } else {
            TileEntity tile;
            this.blockMap.put(pos, (Object)block);
            this.blockMetaMap.put(pos, meta);
            if (block.hasTileEntity(meta) && (tile = block.createTileEntity((World)this, meta)) != null) {
                this.func_147455_a(x, y, z, tile);
            }
            block.func_149726_b((World)this, x, y, z);
        }
        this.hasChanged = true;
        this.minPos.x = Math.min(this.minPos.x, (float)x);
        this.minPos.y = Math.min(this.minPos.y, (float)y);
        this.minPos.z = Math.min(this.minPos.z, (float)z);
        this.maxPos.x = Math.max(this.maxPos.x, (float)x);
        this.maxPos.y = Math.max(this.maxPos.y, (float)y);
        this.maxPos.z = Math.max(this.maxPos.z, (float)z);
        return y >= 0 && y < 256;
    }

    public Block func_147439_a(int x, int y, int z) {
        Block block = (Block)this.blockMap.get(CoordinatePacker.pack((int)x, (int)y, (int)z));
        return block == null ? Blocks.field_150350_a : block;
    }

    public int func_72805_g(int x, int y, int z) {
        return this.blockMetaMap.get(CoordinatePacker.pack((int)x, (int)y, (int)z));
    }

    public boolean func_72921_c(int x, int y, int z, int meta, int flag) {
        long pos = CoordinatePacker.pack((int)x, (int)y, (int)z);
        if (!this.blockMap.containsKey(pos)) {
            return false;
        }
        this.blockMetaMap.put(pos, meta);
        TileEntity tile = (TileEntity)this.tileMap.get(pos);
        if (tile != null) {
            tile.func_145836_u();
            tile.field_145847_g = meta;
        }
        return true;
    }

    public void func_147455_a(int x, int y, int z, TileEntity tile) {
        tile.func_145834_a((World)this);
        tile.field_145851_c = x;
        tile.field_145848_d = y;
        tile.field_145849_e = z;
        tile.func_145829_t();
        this.tileMap.put(CoordinatePacker.pack((int)x, (int)y, (int)z), (Object)tile);
    }

    public void func_147475_p(int x, int y, int z) {
        ((TileEntity)this.tileMap.remove(CoordinatePacker.pack((int)x, (int)y, (int)z))).func_145843_s();
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        return (TileEntity)this.tileMap.get(CoordinatePacker.pack((int)x, (int)y, (int)z));
    }

    @Override
    public void updateEntitiesForNEI() {
        for (TileEntity tile : this.tileMap.values()) {
            if (!tile.canUpdate()) continue;
            tile.func_145845_h();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72802_i(int p_72802_1_, int p_72802_2_, int p_72802_3_, int p_72802_4_) {
        return 0xF000F0;
    }

    public Vector3f getSize() {
        return this.size.set(this.maxPos.x - this.minPos.x + 1.0f, this.maxPos.y - this.minPos.y + 1.0f, this.maxPos.z - this.minPos.z + 1.0f);
    }

    public Vector3f getMinPos() {
        return this.minPos;
    }

    public Vector3f getMaxPos() {
        return this.maxPos;
    }

    public void setVisibleYLevel(int visibleYLevel) {
        this.visibleYLevel = visibleYLevel;
    }

    public MovingObjectPosition rayTraceBlocksWithTargetMap(Vec3 start, Vec3 end, LongSet targetedBlocks) {
        return this.rayTraceBlocksWithTargetMap(start, end, targetedBlocks, false, false, false);
    }

    public MovingObjectPosition rayTraceBlocksWithTargetMap(Vec3 start, Vec3 end, LongSet targetedBlocks, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
            if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                MovingObjectPosition movingobjectposition;
                int i = MathHelper.func_76128_c((double)end.field_72450_a);
                int j = MathHelper.func_76128_c((double)end.field_72448_b);
                int k = MathHelper.func_76128_c((double)end.field_72449_c);
                int l = MathHelper.func_76128_c((double)start.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)start.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)start.field_72449_c);
                Block block = this.func_147439_a(l, i1, j1);
                int k1 = this.func_72805_g(l, i1, j1);
                if (!(ignoreBlockWithoutBoundingBox && block.func_149668_a((World)this, l, i1, j1) == null || !block.func_149678_a(k1, stopOnLiquid) || this.visibleYLevel != -1 && this.visibleYLevel != i1 || (movingobjectposition = block.func_149731_a((World)this, l, i1, j1, start, end)) == null || !this.isBlockTargeted(movingobjectposition, targetedBlocks))) {
                    return movingobjectposition;
                }
                MovingObjectPosition movingobjectposition2 = null;
                k1 = 200;
                while (k1-- >= 0) {
                    int b0;
                    if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? movingobjectposition2 : null;
                    }
                    boolean flag6 = true;
                    boolean flag3 = true;
                    boolean flag4 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag6 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag3 = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag4 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = end.field_72450_a - start.field_72450_a;
                    double d7 = end.field_72448_b - start.field_72448_b;
                    double d8 = end.field_72449_c - start.field_72449_c;
                    if (flag6) {
                        d3 = (d0 - start.field_72450_a) / d6;
                    }
                    if (flag3) {
                        d4 = (d1 - start.field_72448_b) / d7;
                    }
                    if (flag4) {
                        d5 = (d2 - start.field_72449_c) / d8;
                    }
                    boolean flag5 = false;
                    if (d3 < d4 && d3 < d5) {
                        b0 = i > l ? 4 : 5;
                        start.field_72450_a = d0;
                        start.field_72448_b += d7 * d3;
                        start.field_72449_c += d8 * d3;
                    } else if (d4 < d5) {
                        b0 = j > i1 ? 0 : 1;
                        start.field_72450_a += d6 * d4;
                        start.field_72448_b = d1;
                        start.field_72449_c += d8 * d4;
                    } else {
                        b0 = k > j1 ? 2 : 3;
                        start.field_72450_a += d6 * d5;
                        start.field_72448_b += d7 * d5;
                        start.field_72449_c = d2;
                    }
                    Vec3 vec32 = Vec3.func_72443_a((double)start.field_72450_a, (double)start.field_72448_b, (double)start.field_72449_c);
                    vec32.field_72450_a = MathHelper.func_76128_c((double)start.field_72450_a);
                    l = (int)vec32.field_72450_a;
                    if (b0 == 5) {
                        --l;
                        vec32.field_72450_a += 1.0;
                    }
                    vec32.field_72448_b = MathHelper.func_76128_c((double)start.field_72448_b);
                    i1 = (int)vec32.field_72448_b;
                    if (b0 == 1) {
                        --i1;
                        vec32.field_72448_b += 1.0;
                    }
                    vec32.field_72449_c = MathHelper.func_76128_c((double)start.field_72449_c);
                    j1 = (int)vec32.field_72449_c;
                    if (b0 == 3) {
                        --j1;
                        vec32.field_72449_c += 1.0;
                    }
                    Block block1 = this.func_147439_a(l, i1, j1);
                    int l1 = this.func_72805_g(l, i1, j1);
                    if (ignoreBlockWithoutBoundingBox && block1.func_149668_a((World)this, l, i1, j1) == null) continue;
                    if (block1.func_149678_a(l1, stopOnLiquid)) {
                        MovingObjectPosition movingobjectposition1;
                        if (this.visibleYLevel != -1 && this.visibleYLevel != i1 || (movingobjectposition1 = block1.func_149731_a((World)this, l, i1, j1, start, end)) == null || !this.isBlockTargeted(movingobjectposition1, targetedBlocks)) continue;
                        return movingobjectposition1;
                    }
                    movingobjectposition2 = new MovingObjectPosition(l, i1, j1, b0, start, false);
                }
                return returnLastUncollidableBlock ? movingobjectposition2 : null;
            }
            return null;
        }
        return null;
    }

    private boolean isBlockTargeted(MovingObjectPosition result, LongSet targetedBlocks) {
        return targetedBlocks.contains(CoordinatePacker.pack((int)result.field_72311_b, (int)result.field_72312_c, (int)result.field_72309_d));
    }

    public boolean hasChanged() {
        boolean changed = this.hasChanged;
        this.hasChanged = false;
        return changed;
    }
}

