/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.client.utils;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;

public class TieredConstructable
implements ISurvivalConstructable {
    private final IConstructable original;
    private final int tier;

    public TieredConstructable(IConstructable original, int tier) {
        this.original = original;
        this.tier = tier;
    }

    public IConstructable getOriginal() {
        return this.original;
    }

    public int getTier() {
        return this.tier;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.original.construct(stackSize, hintsOnly);
    }

    public IStructureDefinition<?> getStructureDefinition() {
        return this.original.getStructureDefinition();
    }

    public String[] getStructureDescription(ItemStack stackSize) {
        return this.original.getStructureDescription(stackSize);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        int n;
        IConstructable iConstructable = this.original;
        if (iConstructable instanceof ISurvivalConstructable) {
            ISurvivalConstructable survivalConstructable = (ISurvivalConstructable)iConstructable;
            n = survivalConstructable.survivalConstruct(stackSize, elementBudget, env);
        } else {
            n = -2;
        }
        return n;
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        int n;
        IConstructable iConstructable = this.original;
        if (iConstructable instanceof ISurvivalConstructable) {
            ISurvivalConstructable survivalConstructable = (ISurvivalConstructable)iConstructable;
            n = survivalConstructable.survivalConstruct(stackSize, elementBudget, source, actor);
        } else {
            n = -2;
        }
        return n;
    }
}

