/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.gregtech;

import blockrenderer6343.api.utils.BlockPosition;
import blockrenderer6343.api.utils.CreativeItemSource;
import blockrenderer6343.api.utils.PositionedIStructureElement;
import blockrenderer6343.client.world.ClientFakePlayer;
import blockrenderer6343.common.GUI_MultiblocksHandler;
import codechicken.lib.math.MathHelper;
import com.gtnewhorizon.structurelib.StructureEvent;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ConstructableUtility;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.ITurnable;
import gregtech.api.threads.GT_Runnable_MachineBlockUpdate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_GUI_MultiblocksHandler
extends GUI_MultiblocksHandler<ISurvivalConstructable> {
    protected static final int TIER_BUTTON_X = 0;
    protected static final int TIER_BUTTON_Y = 115;
    protected static final int TIER_BUTTON_SPACE_X = 25;
    protected static final int PROJECT_BUTTON_X = 145;
    protected static final int PROJECT_BUTTON_Y = -5;
    private static final BlockPosition MB_PLACE_POS = new BlockPosition(0, 64, 0);
    public static final int MAX_PLACE_ROUNDS = 2000;
    protected static int tierIndex = 1;
    private static EntityPlayer fakeMultiblockBuilder;
    private final List<List<ItemStack>> candidates = new ArrayList<List<ItemStack>>();
    protected List<PositionedIStructureElement> structureElements = new ArrayList<PositionedIStructureElement>();
    protected Consumer<List<List<ItemStack>>> onCandidateChanged;

    public GT_GUI_MultiblocksHandler() {
        GUI_MultiblocksHandler.ClearGuiButton previousTierButton = new GUI_MultiblocksHandler.ClearGuiButton(0, 0, 115, 20, 20, "<");
        GUI_MultiblocksHandler.ClearGuiButton nextTierButton = new GUI_MultiblocksHandler.ClearGuiButton(0, 45, 115, 20, 20, ">");
        GuiButton projectMultiblocksButton = new GuiButton(0, 145, -5, 20, 20, "P");
        buttons.put(previousTierButton, this::togglePreviousTier);
        buttons.put(nextTierButton, this::toggleNextTier);
        buttons.put(projectMultiblocksButton, this::projectMultiblocks);
    }

    public void setOnCandidateChanged(Consumer<List<List<ItemStack>>> callback) {
        this.onCandidateChanged = callback;
    }

    @Override
    protected void loadNewMultiblock() {
        tierIndex = 1;
        layerIndex = -1;
        this.initializeSceneRenderer(true);
        this.lastRenderingController = this.renderingController;
    }

    private void projectMultiblocks() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient baseWorld = Minecraft.func_71410_x().field_71441_e;
        MovingObjectPosition lookingPos = player.func_70614_a(10.0, 1.0f);
        if (lookingPos.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            return;
        }
        int playerDir = MathHelper.floor_double((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ItemStack itemStack = this.stackForm;
        if (!baseWorld.func_147437_c(lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d)) {
            return;
        }
        itemStack.func_77973_b().func_77648_a(itemStack, (EntityPlayer)player, (World)baseWorld, lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d, 0, (float)lookingPos.field_72311_b, (float)lookingPos.field_72312_c, (float)lookingPos.field_72309_d);
        ConstructableUtility.handle((ItemStack)GT_GUI_MultiblocksHandler.getTriggerStack(), (EntityPlayer)player, (World)baseWorld, (int)lookingPos.field_72311_b, (int)(lookingPos.field_72312_c + 1), (int)lookingPos.field_72309_d, (int)playerDir);
        baseWorld.func_147468_f(lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d);
        baseWorld.func_147475_p(lookingPos.field_72311_b, lookingPos.field_72312_c + 1, lookingPos.field_72309_d);
    }

    @NotNull
    private static ItemStack getTriggerStack() {
        return new ItemStack(StructureLibAPI.getDefaultHologramItem(), tierIndex);
    }

    private void toggleNextTier() {
        ++tierIndex;
        this.initializeSceneRenderer(false);
    }

    private void togglePreviousTier() {
        if (tierIndex > 1) {
            --tierIndex;
            this.initializeSceneRenderer(false);
        }
    }

    @Override
    protected String getMultiblockName() {
        return I18n.func_135052_a((String)this.stackForm.func_82833_r(), (Object[])new Object[0]);
    }

    @Override
    protected void drawButtonsTitle() {
        super.drawButtonsTitle();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String tierText = "Tier: " + tierIndex;
        fontRenderer.func_78276_b(tierText, 20 + (25 - fontRenderer.func_78256_a(tierText)) / 2, 120, 0x333333);
    }

    @Override
    protected void placeMultiblock() {
        if (GT_Runnable_MachineBlockUpdate.isCurrentThreadEnabled()) {
            GT_Runnable_MachineBlockUpdate.setCurrentThreadEnabled((boolean)false);
        }
        fakeMultiblockBuilder = new ClientFakePlayer(GT_GUI_MultiblocksHandler.renderer.world, new GameProfile(UUID.fromString("518FDF18-EC2A-4322-832A-58ED1721309B"), "[GregTech]"));
        GT_GUI_MultiblocksHandler.renderer.world.func_72828_b(Arrays.asList(fakeMultiblockBuilder));
        IConstructable constructable = null;
        int oStackSize = this.stackForm.field_77994_a;
        this.stackForm.func_77973_b().func_77648_a(this.stackForm, fakeMultiblockBuilder, GT_GUI_MultiblocksHandler.renderer.world, GT_GUI_MultiblocksHandler.MB_PLACE_POS.x, GT_GUI_MultiblocksHandler.MB_PLACE_POS.y, GT_GUI_MultiblocksHandler.MB_PLACE_POS.z, 0, (float)GT_GUI_MultiblocksHandler.MB_PLACE_POS.x, (float)GT_GUI_MultiblocksHandler.MB_PLACE_POS.y, (float)GT_GUI_MultiblocksHandler.MB_PLACE_POS.z);
        this.stackForm.field_77994_a = oStackSize;
        TileEntity tTileEntity = GT_GUI_MultiblocksHandler.renderer.world.func_147438_o(GT_GUI_MultiblocksHandler.MB_PLACE_POS.x, GT_GUI_MultiblocksHandler.MB_PLACE_POS.y, GT_GUI_MultiblocksHandler.MB_PLACE_POS.z);
        ((ITurnable)tTileEntity).setFrontFacing(ForgeDirection.SOUTH);
        IMetaTileEntity mte = ((IGregTechTileEntity)tTileEntity).getMetaTileEntity();
        if (!StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.enableInstrument((Object)"blockrenderer6343");
        }
        this.structureElements.clear();
        if (mte instanceof ISurvivalConstructable) {
            int result;
            int iterations = 0;
            while ((result = ((ISurvivalConstructable)mte).survivalConstruct(GT_GUI_MultiblocksHandler.getTriggerStack(), Integer.MAX_VALUE, ISurvivalBuildEnvironment.create((IItemSource)CreativeItemSource.instance, (EntityPlayer)fakeMultiblockBuilder))) > 0 && ++iterations < 2000) {
            }
        } else if (tTileEntity instanceof IConstructableProvider) {
            constructable = ((IConstructableProvider)tTileEntity).getConstructable();
        } else if (tTileEntity instanceof IConstructable) {
            constructable = (IConstructable)tTileEntity;
        }
        if (constructable != null) {
            constructable.construct(GT_GUI_MultiblocksHandler.getTriggerStack(), false);
        }
        if (StructureLibAPI.isInstrumentEnabled()) {
            StructureLibAPI.disableInstrument();
        }
        if (!GT_Runnable_MachineBlockUpdate.isCurrentThreadEnabled()) {
            GT_Runnable_MachineBlockUpdate.setCurrentThreadEnabled((boolean)true);
        }
    }

    private void scanCandidates() {
        this.candidates.clear();
        if (selectedBlock != null) {
            for (PositionedIStructureElement structureElement : this.structureElements) {
                if (structureElement.x != GT_GUI_MultiblocksHandler.selectedBlock.x || structureElement.y != GT_GUI_MultiblocksHandler.selectedBlock.y || structureElement.z != GT_GUI_MultiblocksHandler.selectedBlock.z) continue;
                IStructureElement.BlocksToPlace blocksToPlace = structureElement.element.getBlocksToPlace((Object)((ISurvivalConstructable)this.renderingController), GT_GUI_MultiblocksHandler.renderer.world, GT_GUI_MultiblocksHandler.selectedBlock.x, GT_GUI_MultiblocksHandler.selectedBlock.y, GT_GUI_MultiblocksHandler.selectedBlock.z, GT_GUI_MultiblocksHandler.getTriggerStack(), AutoPlaceEnvironment.fromLegacy((IItemSource)CreativeItemSource.instance, (EntityPlayer)fakeMultiblockBuilder, iChatComponent -> {}));
                if (blocksToPlace != null) {
                    Predicate predicate = blocksToPlace.getPredicate();
                    Set<ItemStack> rawCandidates = CreativeItemSource.instance.takeEverythingMatches(predicate, false, 0).keySet();
                    ArrayList stackedCandidates = new ArrayList();
                    for (ItemStack rawCandidate : rawCandidates) {
                        boolean added = false;
                        for (List list : stackedCandidates) {
                            List firstCandidateTooltip = ((ItemStack)list.get(0)).func_82840_a(fakeMultiblockBuilder, false);
                            List rawCandidateTooltip = rawCandidate.func_82840_a(fakeMultiblockBuilder, false);
                            if (firstCandidateTooltip.size() <= 1 || rawCandidateTooltip.size() <= 1 || !((String)firstCandidateTooltip.get(1)).equals(rawCandidateTooltip.get(1))) continue;
                            list.add(rawCandidate);
                            added = true;
                            break;
                        }
                        if (added) continue;
                        ArrayList<ItemStack> newStackedCandidate = new ArrayList<ItemStack>();
                        newStackedCandidate.add(rawCandidate);
                        stackedCandidates.add(newStackedCandidate);
                    }
                    this.candidates.addAll(stackedCandidates);
                    if (this.onCandidateChanged != null) {
                        this.onCandidateChanged.accept(this.candidates);
                    }
                }
                return;
            }
        }
        if (this.onCandidateChanged != null) {
            this.onCandidateChanged.accept(this.candidates);
        }
    }

    @Override
    protected void onBlockSelected() {
        this.scanCandidates();
    }

    @SubscribeEvent
    public void OnStructureEvent(StructureEvent.StructureElementVisitedEvent event) {
        this.structureElements.add(new PositionedIStructureElement(event.getX(), event.getY(), event.getZ(), (IStructureElement<ISurvivalConstructable>)event.getElement()));
    }
}

