/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.polymeriser;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.genetics.Engineering;
import net.minecraft.item.ItemStack;

public class PolymeriserComponentLogic
extends ComponentProcessSetCost
implements IProcess {
    private static final float chargePerProcess = 0.4f;
    private float dnaDrain = 0.0f;
    private float bacteriaDrain = 0.0f;

    public PolymeriserComponentLogic(Machine machine) {
        super(machine, 96000, 2400);
    }

    private float getCatalyst() {
        return this.getUtil().getSlotCharge(1) > 0.0f ? 0.2f : 1.0f;
    }

    @Override
    public int getProcessLength() {
        return (int)((float)(super.getProcessLength() * this.getNumberOfGenes()) * this.getCatalyst());
    }

    @Override
    public int getProcessEnergy() {
        return (int)((float)(super.getProcessEnergy() * this.getNumberOfGenes()) * this.getCatalyst());
    }

    private float getDNAPerProcess() {
        return this.getNumberOfGenes() * 50;
    }

    @Override
    public void onTickTask() {
        super.onTickTask();
        this.getUtil().useCharge(1, 0.4f * this.getProgressPerTick() / 100.0f);
        this.dnaDrain += this.getDNAPerProcess() * this.getProgressPerTick() / 100.0f;
        this.bacteriaDrain += 0.2f * this.getDNAPerProcess() * this.getProgressPerTick() / 100.0f;
        if (this.dnaDrain >= 1.0f) {
            this.getUtil().drainTank(1, 1);
            this.dnaDrain -= 1.0f;
        }
        if (this.bacteriaDrain >= 1.0f) {
            this.getUtil().drainTank(0, 1);
            this.bacteriaDrain -= 1.0f;
        }
    }

    private int getNumberOfGenes() {
        ItemStack serum = this.getUtil().getStack(0);
        if (serum == null) {
            return 1;
        }
        return Engineering.getGenes(serum).length;
    }

    @Override
    public String getTooltip() {
        int n = this.getNumberOfGenes();
        if (n > 1) {
            return I18N.localise("genetics.machine.polymeriser.replicatingWithGenes", n);
        }
        return I18N.localise("genetics.machine.polymeriser.replicatingWithGene");
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.polymeriser.error.noItem"), 0);
        }
        if (!this.getUtil().getStack(0).func_77951_h()) {
            return new ErrorState.InvalidItem(I18N.localise("genetics.machine.polymeriser.error.itemFilled"), 0);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getUtil().getFluid(0) == null) {
            return new ErrorState.InsufficientLiquid(I18N.localise("genetics.machine.polymeriser.error.noLiquid"), 0);
        }
        if (this.getUtil().getFluid(1) == null) {
            return new ErrorState.InsufficientLiquid(I18N.localise("genetics.machine.polymeriser.error.noDNA"), 1);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        super.onFinishTask();
        this.getUtil().damageItem(0, -1);
    }
}

