/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.nei;

import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.nei.PositionedStackAdv;
import binnie.core.nei.RecipeHandlerBase;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import binnie.genetics.machine.acclimatiser.ToleranceType;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class AcclimatiserRecipeHandler
extends RecipeHandlerBase {
    private static final List<AcclimatiserRecipe> recipes = new ArrayList<AcclimatiserRecipe>();

    @Override
    public void prepare() {
        Acclimatiser.temperatureItems.forEach((resource, effect) -> {
            ArrayList<ItemStack> targets = new ArrayList<ItemStack>();
            if (BinnieCore.isApicultureActive()) {
                targets.add(Mods.forestry.stack("beeDroneGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("beePrincessGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("beeQueenGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("beeLarvaeGE", 1, Short.MAX_VALUE));
            }
            if (BinnieCore.isLepidopteryActive()) {
                targets.add(Mods.forestry.stack("butterflyGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("caterpillarGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("serumGE", 1, Short.MAX_VALUE));
            }
            targets.add(new ItemStack((Item)Botany.flowerItem, 1, Short.MAX_VALUE));
            targets.add(new ItemStack(Botany.seed, 1, Short.MAX_VALUE));
            targets.add(new ItemStack(Botany.pollen, 1, Short.MAX_VALUE));
            recipes.add(new AcclimatiserRecipe(targets, (ItemStack)resource, effect.floatValue(), ToleranceType.Temperature));
        });
        Acclimatiser.humidityItems.forEach((resource, effect) -> {
            ArrayList<ItemStack> targets = new ArrayList<ItemStack>();
            if (BinnieCore.isApicultureActive()) {
                targets.add(Mods.forestry.stack("beeDroneGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("beePrincessGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("beeQueenGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("beeLarvaeGE", 1, Short.MAX_VALUE));
            }
            if (BinnieCore.isLepidopteryActive()) {
                targets.add(Mods.forestry.stack("butterflyGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("caterpillarGE", 1, Short.MAX_VALUE));
                targets.add(Mods.forestry.stack("serumGE", 1, Short.MAX_VALUE));
            }
            targets.add(new ItemStack((Item)Botany.flowerItem, 1, Short.MAX_VALUE));
            targets.add(new ItemStack(Botany.seed, 1, Short.MAX_VALUE));
            targets.add(new ItemStack(Botany.pollen, 1, Short.MAX_VALUE));
            recipes.add(new AcclimatiserRecipe(targets, (ItemStack)resource, effect.floatValue(), ToleranceType.Humidity));
        });
    }

    public String getOverlayIdentifier() {
        return "genetics.acclimatiser";
    }

    public String getGuiTexture() {
        return "genetics:textures/gui/nei/acclimatiser.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"genetics.machine.labMachine.acclimatiser");
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 20, 18, 7);
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)76);
    }

    @Override
    public void loadAllRecipes() {
        for (AcclimatiserRecipe recipe : recipes) {
            this.arecipes.add(new CachedAcclimatiserRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (AcclimatiserRecipe recipe : recipes) {
            if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getResource(), (ItemStack)ingredient)) {
                this.arecipes.add(new CachedAcclimatiserRecipe(recipe));
                continue;
            }
            for (ItemStack itemStack : recipe.getTarget()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)itemStack, (ItemStack)ingredient)) continue;
                this.arecipes.add(new CachedAcclimatiserRecipe(recipe));
                continue block0;
            }
        }
    }

    private static class AcclimatiserRecipe {
        private final ItemStack[] target;
        private final ItemStack resource;
        private final float effect;
        private final ToleranceType type;

        public AcclimatiserRecipe(Object target, ItemStack resource, float effect, ToleranceType type) {
            this.target = NEIServerUtils.extractRecipeItems((Object)target);
            this.resource = resource;
            this.effect = effect;
            this.type = type;
        }

        public ItemStack getResource() {
            return this.resource;
        }

        public ItemStack[] getTarget() {
            return this.target;
        }

        public float getEffect() {
            return this.effect;
        }

        public ToleranceType getType() {
            return this.type;
        }
    }

    public class CachedAcclimatiserRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public List<PositionedStack> target;
        public PositionedStack resource;
        public float effect;
        public ToleranceType type;
        public List<PositionedStack> ingredients;

        public CachedAcclimatiserRecipe(AcclimatiserRecipe recipe) {
            super(AcclimatiserRecipeHandler.this);
            this.target = new ArrayList<PositionedStack>();
            this.ingredients = new ArrayList<PositionedStack>();
            if (recipe.getTarget() != null) {
                for (int i = 0; i < recipe.getTarget().length; ++i) {
                    this.target.add(new PositionedStack((Object)recipe.getTarget()[i], 31 + 18 * (i > 5 ? i % 6 : i), 29 + 18 * (i / 6)));
                }
                this.resource = new PositionedStackAdv(recipe.getResource(), 76, 2).addToTooltip(StatCollector.func_74838_a((String)("genetics.nei.tip." + (recipe.getType().equals((Object)ToleranceType.Temperature) ? "temperature" : "humidity")))).addToTooltip(StatCollector.func_74837_a((String)"genetics.nei.tip.effect", (Object[])new Object[]{Float.valueOf(recipe.getEffect())}));
                this.effect = recipe.getEffect();
                this.type = recipe.getType();
                this.ingredients.addAll(this.target);
                this.ingredients.add(this.resource);
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(AcclimatiserRecipeHandler.this.cycleticks / 40, this.ingredients);
        }

        public PositionedStack getResult() {
            return null;
        }
    }
}

