/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.listbox;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.util.IValidator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ControlList<T>
extends Control
implements IControlValue<T> {
    protected ControlListBox<T> parent;
    protected T value;
    protected Map<T, IWidget> allOptions = new LinkedHashMap<T, IWidget>();
    protected Map<T, IWidget> optionWidgets = new LinkedHashMap<T, IWidget>();
    protected boolean creating;
    protected IValidator<IWidget> validator;

    protected ControlList(ControlListBox<T> parent, float x, float y, float w, float h) {
        super(parent, x, y, w, h);
        this.parent = parent;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        if (value == this.value) {
            return;
        }
        this.value = value;
        if (value != null && this.optionWidgets.containsKey(value)) {
            IWidget child = this.optionWidgets.get(value);
            this.parent.ensureVisible(child.y(), child.y() + child.h(), this.h());
        }
        this.getParent().callEvent(new EventValueChanged<T>(this.getParent(), value));
    }

    public void setOptions(Collection<T> options) {
        this.deleteAllChildren();
        this.allOptions.clear();
        for (T option : options) {
            IWidget optionWidget = ((ControlListBox)this.getParent()).createOption(option, 0);
            if (optionWidget == null) continue;
            this.allOptions.put(option, optionWidget);
        }
        this.filterOptions();
    }

    public void filterOptions() {
        int height = 0;
        this.optionWidgets.clear();
        for (Map.Entry<T, IWidget> entry : this.allOptions.entrySet()) {
            if (this.isValidOption(entry.getValue())) {
                entry.getValue().show();
                this.optionWidgets.put(entry.getKey(), entry.getValue());
                entry.getValue().setPosition(new IPoint(0.0f, height));
                height += (int)entry.getValue().getSize().y();
                continue;
            }
            entry.getValue().hide();
        }
        this.creating = true;
        this.setValue(this.getValue());
        this.setSize(new IPoint(this.getSize().x(), height));
    }

    public Collection<T> getOptions() {
        return this.optionWidgets.keySet();
    }

    public int getIndexOf(T value) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (option.equals(value)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getCurrentIndex() {
        return this.getIndexOf(this.getValue());
    }

    public void setIndex(int currentIndex) {
        int index = 0;
        for (T option : this.getOptions()) {
            if (index == currentIndex) {
                this.setValue(option);
                return;
            }
            ++index;
        }
        this.setValue(null);
    }

    private boolean isValidOption(IWidget widget) {
        return this.validator == null || this.validator.isValid(widget);
    }

    public void setValidator(IValidator<IWidget> validator) {
        if (this.validator != validator) {
            this.validator = validator;
            this.filterOptions();
        }
    }
}

