/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.isolator;

import binnie.core.genetics.Gene;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.item.ItemSequence;
import binnie.genetics.machine.isolator.Isolator;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class IsolatorComponentLogic
extends ComponentProcessSetCost
implements IProcess {
    protected float enzymePerProcess = 0.5f;
    protected float ethanolPerProcess = 10.0f;

    public IsolatorComponentLogic(Machine machine) {
        super(machine, 192000, 4800);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(5)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.isolator.error.noIndividual"), 5);
        }
        if (!this.getUtil().isSlotEmpty(6)) {
            return new ErrorState.NoSpace(I18N.localise("genetics.machine.isolator.error.noRoom"), Isolator.SLOT_FINISHED);
        }
        if (this.getUtil().isSlotEmpty(1)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.isolator.error.noVials"), 1);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.getUtil().liquidInTank(0, (int)this.ethanolPerProcess)) {
            return new ErrorState.InsufficientLiquid(I18N.localise("genetics.machine.isolator.error.noLiquid"), 0);
        }
        if (this.getUtil().getSlotCharge(0) == 0.0f) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.isolator.error.noEnzyme"), 0);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        IChromosomeType chromosome;
        super.onFinishTask();
        Random rand = this.getMachine().getWorld().field_73012_v;
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(this.getUtil().getStack(5));
        if (root == null) {
            return;
        }
        IIndividual individual = root.getMember(this.getUtil().getStack(5));
        if (individual == null) {
            return;
        }
        IChromosomeType[] karyo = root.getKaryotype();
        IChromosome[] chromosomes = individual.getGenome().getChromosomes();
        if (Arrays.stream(chromosomes).allMatch(Objects::isNull)) {
            return;
        }
        while (chromosomes[(chromosome = karyo[rand.nextInt(karyo.length)]).ordinal()] == null) {
        }
        IAllele allele = rand.nextBoolean() ? individual.getGenome().getActiveAllele(chromosome) : individual.getGenome().getInactiveAllele(chromosome);
        Gene gene = new Gene(allele, chromosome, root);
        ItemStack serum = ItemSequence.create(gene);
        this.getUtil().setStack(6, serum);
        this.getUtil().decreaseStack(1, 1);
        if (rand.nextFloat() < 0.05f) {
            this.getUtil().decreaseStack(5, 1);
        }
        this.getUtil().drainTank(0, (int)this.ethanolPerProcess);
    }

    @Override
    protected void onTickTask() {
        this.getMachine().getInterface(IChargedSlots.class).alterCharge(0, -this.enzymePerProcess * this.getProgressPerTick() / 100.0f);
    }
}

