/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.transfer;

import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.IValidatedTankContainer;
import binnie.core.machines.power.ITankMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidTank;

public class TransferRequest {
    private ItemStack itemToTransfer = null;
    private ItemStack returnItem = null;
    private IInventory origin;
    private IInventory destination;
    private int[] targetSlots = new int[0];
    private int[] targetTanks = new int[0];
    private boolean transferLiquids = true;
    private boolean ignoreReadOnly = false;
    private final List<TransferSlot> insertedSlots = new ArrayList<TransferSlot>();
    private final List<Integer> insertedTanks = new ArrayList<Integer>();

    public TransferRequest(ItemStack toTransfer, IInventory destination) {
        int[] target = new int[destination.func_70302_i_()];
        for (int i = 0; i < target.length; ++i) {
            target[i] = i;
        }
        int[] targetTanks = new int[]{};
        if (destination instanceof ITankMachine) {
            targetTanks = new int[((ITankMachine)destination).getTanks().length];
            for (int j = 0; j < targetTanks.length; ++j) {
                targetTanks[j] = j;
            }
        }
        if (toTransfer != null) {
            this.setItemToTransfer(toTransfer.func_77946_l());
            this.setReturnItem(toTransfer.func_77946_l());
        }
        this.setOrigin(null);
        this.setDestination(destination);
        this.setTargetSlots(target);
        this.setTargetTanks(targetTanks);
        this.transferLiquids = true;
    }

    private void setItemToTransfer(ItemStack itemToTransfer) {
        this.itemToTransfer = itemToTransfer;
    }

    private void setReturnItem(ItemStack returnItem) {
        this.returnItem = returnItem;
    }

    public TransferRequest setOrigin(IInventory origin) {
        this.origin = origin;
        return this;
    }

    private void setDestination(IInventory destination) {
        this.destination = destination;
    }

    public TransferRequest setTargetSlots(int[] targetSlots) {
        this.targetSlots = targetSlots;
        return this;
    }

    public TransferRequest setTargetTanks(int[] targetTanks) {
        this.targetTanks = targetTanks;
        return this;
    }

    public TransferRequest ignoreValidation() {
        this.ignoreReadOnly = true;
        return this;
    }

    public ItemStack getReturnItem() {
        return this.returnItem;
    }

    public ItemStack transfer(boolean doAdd) {
        ItemStack item = this.returnItem;
        if (item == null || this.destination == null) {
            return null;
        }
        if (this.transferLiquids && this.destination instanceof ITankMachine) {
            for (int tankID : this.targetTanks) {
                if ((item = this.transferToTank(item, this.origin, (ITankMachine)this.destination, tankID, doAdd)) == null) continue;
                item = this.transferFromTank(item, this.origin, (ITankMachine)this.destination, tankID, doAdd);
            }
        }
        if (item != null) {
            for (int slot : this.targetSlots) {
                if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && ((IInventorySlots)this.destination).getSlot(slot) != null && ((IInventorySlots)this.destination).getSlot(slot).isRecipe() || this.destination.func_70301_a(slot) == null || !item.func_77985_e() || this.destination.func_70297_j_() <= 1) continue;
                ItemStack merged = this.destination.func_70301_a(slot).func_77946_l();
                ItemStack[] newStacks = TransferRequest.mergeStacks(item.func_77946_l(), merged.func_77946_l());
                item = newStacks[0];
                if (!TransferRequest.areItemsEqual(merged, newStacks[1])) {
                    this.insertedSlots.add(new TransferSlot(slot, this.destination));
                }
                if (doAdd) {
                    this.destination.func_70299_a(slot, newStacks[1]);
                }
                if (item != null) continue;
                return null;
            }
            for (int slot : this.targetSlots) {
                if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && ((IInventorySlots)this.destination).getSlot(slot) != null && ((IInventorySlots)this.destination).getSlot(slot).isRecipe() || this.destination.func_70301_a(slot) != null) continue;
                this.insertedSlots.add(new TransferSlot(slot, this.destination));
                if (doAdd) {
                    ItemStack movedStack = item.func_77946_l();
                    if (movedStack.field_77994_a > this.destination.func_70297_j_()) {
                        movedStack.field_77994_a = this.destination.func_70297_j_();
                    }
                    item.field_77994_a -= movedStack.field_77994_a;
                    this.destination.func_70299_a(slot, movedStack);
                    if (item.field_77994_a <= 0) {
                        item = null;
                    }
                    return item;
                }
                return null;
            }
        }
        this.setReturnItem(item);
        return item;
    }

    private static boolean areItemsEqual(ItemStack merged, ItemStack itemstack) {
        return ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)merged) && itemstack.func_77969_a(merged);
    }

    public static ItemStack[] mergeStacks(ItemStack itemstack, ItemStack merged) {
        int space;
        if (TransferRequest.areItemsEqual(itemstack, merged) && (space = merged.func_77976_d() - merged.field_77994_a) > 0) {
            if (itemstack.field_77994_a > space) {
                itemstack.field_77994_a -= space;
                merged.field_77994_a += space;
            } else {
                merged.field_77994_a += itemstack.field_77994_a;
                itemstack = null;
            }
        }
        return new ItemStack[]{itemstack, merged};
    }

    private ItemStack transferToTank(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        item = this.transferToTankUsingContainerData(item, origin, destination, tankID, doAdd);
        item = this.transferToTankUsingFluidContainer(item, origin, destination, tankID, doAdd);
        return item;
    }

    private ItemStack transferToTankUsingFluidContainer(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        Item item2;
        if (item == null || !((item2 = item.func_77973_b()) instanceof IFluidContainerItem)) {
            return item;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)item2;
        FluidStack fluid = fluidContainer.getFluid(item);
        if (fluid == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        IValidatedTankContainer validated = Machine.getInterface(IValidatedTankContainer.class, destination);
        if (validated != null && (!validated.isLiquidValidForTank(fluid, tankID) || validated.isTankReadOnly(tankID))) {
            return item;
        }
        int maxFill = tank.fill(fluid, false);
        FluidStack toTake = fluidContainer.drain(item, maxFill, true);
        if (doAdd) {
            tank.fill(toTake, true);
        }
        return item;
    }

    private ItemStack transferToTankUsingContainerData(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        TransferRequest containersDump;
        ItemStack containersThatCantBeDumped;
        ItemStack copy;
        if (item == null) {
            return item;
        }
        FluidStack containerLiquid = null;
        FluidContainerRegistry.FluidContainerData containerLiquidData = null;
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.filledContainer.func_77969_a(item)) continue;
            containerLiquidData = data;
            containerLiquid = data.fluid.copy();
            break;
        }
        if (containerLiquid == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        IValidatedTankContainer validated = Machine.getInterface(IValidatedTankContainer.class, destination);
        if (validated != null && (!validated.isLiquidValidForTank(containerLiquid, tankID) || validated.isTankReadOnly(tankID))) {
            return item;
        }
        FluidStack largeAmountOfLiquid = containerLiquid.copy();
        largeAmountOfLiquid.amount = tank.getCapacity();
        int amountAdded = tank.fill(largeAmountOfLiquid, false);
        int numberOfContainersToAdd = containerLiquid.amount > 0 ? amountAdded / containerLiquid.amount : item.field_77994_a;
        if (numberOfContainersToAdd > item.field_77994_a) {
            numberOfContainersToAdd = item.field_77994_a;
        }
        ItemStack leftOverContainers = copy = item.func_77946_l();
        copy.field_77994_a -= numberOfContainersToAdd;
        if (leftOverContainers.field_77994_a <= 0) {
            leftOverContainers = null;
        }
        ItemStack emptyContainers = containerLiquidData.emptyContainer.func_77946_l();
        emptyContainers.field_77994_a = 0;
        ItemStack itemStack = emptyContainers;
        itemStack.field_77994_a += numberOfContainersToAdd;
        if (emptyContainers.field_77994_a <= 0) {
            emptyContainers = null;
        }
        if ((containersThatCantBeDumped = (containersDump = new TransferRequest(emptyContainers, origin)).transfer(false)) != null) {
            return item;
        }
        if (doAdd) {
            FluidStack copy2;
            FluidStack liquidToFillTank = copy2 = containerLiquid.copy();
            copy2.amount *= numberOfContainersToAdd;
            tank.fill(liquidToFillTank, true);
            containersDump.transfer(true);
        }
        return leftOverContainers;
    }

    private ItemStack transferFromTank(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        item = this.transferFromTankUsingContainerData(item, origin, destination, tankID, doAdd);
        item = this.transferFromTankUsingFluidContainer(item, origin, destination, tankID, doAdd);
        return item;
    }

    private ItemStack transferFromTankUsingFluidContainer(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        int amount;
        Item item2;
        if (item == null || !((item2 = item.func_77973_b()) instanceof IFluidContainerItem)) {
            return item;
        }
        IFluidContainerItem fluidContainer = (IFluidContainerItem)item2;
        IFluidTank tank = destination.getTanks()[tankID];
        FluidStack fluid = tank.getFluid();
        if (fluid == null) {
            return item;
        }
        if ((amount = Math.min(amount, tank.drain(amount = fluidContainer.fill(item, fluid, false), false) == null ? 0 : tank.drain((int)amount, (boolean)false).amount)) <= 0) {
            return item;
        }
        fluidContainer.fill(item, tank.drain(amount, doAdd), doAdd);
        return item;
    }

    private ItemStack transferFromTankUsingContainerData(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        TransferRequest containersDump;
        ItemStack containersThatCantBeDumped;
        ItemStack copy;
        if (item == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        FluidStack liquidInTank = tank.getFluid();
        if (liquidInTank == null) {
            return item;
        }
        FluidContainerRegistry.FluidContainerData containerLiquidData = null;
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.emptyContainer.func_77969_a(item) || !liquidInTank.isFluidEqual(data.fluid)) continue;
            containerLiquidData = data;
            break;
        }
        FluidStack fluid = null;
        ItemStack filled = null;
        if (containerLiquidData != null) {
            fluid = containerLiquidData.fluid;
            filled = containerLiquidData.filledContainer;
        }
        if (fluid == null || filled == null) {
            return item;
        }
        int maximumExtractedLiquid = item.field_77994_a * fluid.amount;
        FluidStack drainedLiquid = tank.drain(maximumExtractedLiquid, false);
        int amountInTank = drainedLiquid == null ? 0 : drainedLiquid.amount;
        int numberOfContainersToFill = fluid.amount > 0 ? amountInTank / fluid.amount : item.field_77994_a;
        if (numberOfContainersToFill > item.field_77994_a) {
            numberOfContainersToFill = item.field_77994_a;
        }
        ItemStack leftOverContainers = copy = item.func_77946_l();
        copy.field_77994_a -= numberOfContainersToFill;
        if (leftOverContainers.field_77994_a <= 0) {
            leftOverContainers = null;
        }
        ItemStack filledContainers = filled.func_77946_l();
        filledContainers.field_77994_a = 0;
        ItemStack itemStack = filledContainers;
        itemStack.field_77994_a += numberOfContainersToFill;
        if (filledContainers.field_77994_a <= 0) {
            filledContainers = null;
        }
        if ((containersThatCantBeDumped = (containersDump = new TransferRequest(filledContainers, origin)).transfer(false)) != null) {
            return item;
        }
        if (doAdd) {
            tank.drain(maximumExtractedLiquid, true);
            containersDump.transfer(true);
        }
        return leftOverContainers;
    }

    public List<TransferSlot> getInsertedSlots() {
        return this.insertedSlots;
    }

    public List<Integer> getInsertedTanks() {
        return this.insertedTanks;
    }

    public IInventory getOrigin() {
        return this.origin;
    }

    public IInventory getDestination() {
        return this.destination;
    }

    public ItemStack getItemToTransfer() {
        return this.itemToTransfer;
    }

    public int[] getTargetSlots() {
        return this.targetSlots;
    }

    public int[] getTargetTanks() {
        return this.targetTanks;
    }

    public static class TransferSlot {
        public int id;
        public IInventory inventory;

        public TransferSlot(int id, IInventory inventory) {
            this.id = id;
            this.inventory = inventory;
        }
    }
}

