/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.database;

import binnie.core.craftgui.CraftGUI;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.ControlText;
import binnie.core.craftgui.controls.ControlTextCentered;
import binnie.core.craftgui.database.ControlDatabaseIndividualDisplay;
import binnie.core.craftgui.database.DatabaseTab;
import binnie.core.craftgui.database.EnumDiscoveryState;
import binnie.core.craftgui.database.PageSpecies;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.IPoint;
import binnie.core.craftgui.geometry.TextJustification;
import binnie.core.util.I18N;
import forestry.api.genetics.IAlleleSpecies;
import net.minecraft.util.EnumChatFormatting;

public class PageSpeciesOverview
extends PageSpecies {
    private final ControlText controlName;
    private final ControlText controlScientific;
    private final ControlText controlAuthority;
    private final ControlText controlComplexity;
    private final ControlText controlDescription;
    private final ControlText controlSignature;
    private final ControlDatabaseIndividualDisplay controlInd1 = new ControlDatabaseIndividualDisplay(this, 5.0f, 5.0f);
    private final ControlDatabaseIndividualDisplay controlInd2 = new ControlDatabaseIndividualDisplay(this, 123.0f, 5.0f);

    public PageSpeciesOverview(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        this.controlName = new ControlTextCentered((IWidget)this, 8.0f, "");
        this.controlScientific = new ControlTextCentered((IWidget)this, 32.0f, "");
        this.controlAuthority = new ControlTextCentered((IWidget)this, 44.0f, "");
        this.controlComplexity = new ControlTextCentered((IWidget)this, 56.0f, "");
        this.controlDescription = new ControlText(this, new IArea(8.0f, 84.0f, this.getSize().x() - 16.0f, 0.0f), "", TextJustification.MIDDLE_CENTER);
        this.controlSignature = new ControlText(this, new IArea(8.0f, 84.0f, this.getSize().x() - 16.0f, 0.0f), "", TextJustification.BOTTOM_RIGHT);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.controlInd1.setSpecies(species, EnumDiscoveryState.SHOW);
        this.controlInd2.setSpecies(species, EnumDiscoveryState.SHOW);
        String branchBinomial = species.getBranch() != null ? species.getBranch().getScientific() : I18N.localise("extratrees.genetics.unknown");
        this.controlName.setValue(EnumChatFormatting.BOLD + species.getName() + EnumChatFormatting.RESET);
        this.controlScientific.setValue(EnumChatFormatting.ITALIC + branchBinomial + " " + species.getBinomial() + EnumChatFormatting.RESET);
        this.controlAuthority.setValue(EnumChatFormatting.BOLD + I18N.localise("extratrees.genetics.discoveredBy", species.getAuthority()) + EnumChatFormatting.RESET);
        this.controlComplexity.setValue(I18N.localise("extratrees.genetics.complexity", species.getComplexity()));
        String desc = species.getDescription();
        StringBuilder descBody = new StringBuilder(EnumChatFormatting.ITALIC.toString());
        String descSig = "";
        if (desc == null || desc.isEmpty() || desc.matches("(\\w+\\.?)+")) {
            descBody.append(I18N.localise("binniecore.gui.database.species.noDesc"));
        } else {
            String[] descStrings = desc.split("\\|");
            descBody.append(descStrings[0]);
            for (int i = 1; i < descStrings.length - 1; ++i) {
                descBody.append(" ").append(descStrings[i]);
            }
            if (descStrings.length > 1) {
                descSig = descSig + descStrings[descStrings.length - 1];
            }
        }
        this.controlDescription.setValue(descBody.toString() + EnumChatFormatting.RESET);
        this.controlSignature.setValue(descSig + EnumChatFormatting.RESET);
        float descHeight = CraftGUI.render.textHeight(this.controlDescription.getValue(), this.controlDescription.getSize().x());
        this.controlSignature.setPosition(new IPoint(this.controlSignature.pos().x(), this.controlDescription.getPosition().y() + descHeight + 10.0f));
    }
}

