/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.ForestryAllele;
import binnie.core.util.I18N;
import binnie.core.util.UniqueItemStackSet;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.FakeWorld;
import binnie.extratrees.machines.lumbermill.Lumbermill;
import binnie.genetics.genetics.AlleleHelper;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAllelePlantType;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.alleles.EnumAllele;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.util.ForgeDirection;

public class TreeBreedingSystem
extends BreedingSystem {
    public UniqueItemStackSet allFruits = new UniqueItemStackSet();
    public UniqueItemStackSet allWoods = new UniqueItemStackSet();
    private UniqueItemStackSet discoveredFruits = new UniqueItemStackSet();
    private UniqueItemStackSet discoveredWoods = new UniqueItemStackSet();

    public TreeBreedingSystem() {
        this.iconUndiscovered = Binnie.Resource.getItemIcon(ExtraTrees.instance, "icon/undiscoveredTree");
        this.iconDiscovered = Binnie.Resource.getItemIcon(ExtraTrees.instance, "icon/discoveredTree");
    }

    @Override
    public float getChance(IMutation mutation, EntityPlayer player, IAllele species1, IAllele species2) {
        ISpeciesRoot speciesRoot = this.getSpeciesRoot();
        ITreeGenome genome0 = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(species1.getUID()));
        ITreeGenome genome2 = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(species2.getUID()));
        return ((ITreeMutation)mutation).getChance(player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, (IAlleleTreeSpecies)species1, (IAlleleTreeSpecies)species2, genome0, genome2);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return Binnie.Genetics.getTreeRoot();
    }

    @Override
    public int getColor() {
        return 53006;
    }

    @Override
    public Class<? extends IBreedingTracker> getTrackerClass() {
        return IArboristTracker.class;
    }

    @Override
    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        if (chromosome == EnumTreeChromosome.GIRTH) {
            return ((IAlleleInteger)allele).getValue() + "x" + ((IAlleleInteger)allele).getValue();
        }
        if (chromosome == EnumTreeChromosome.PLANT) {
            EnumSet types = ((IAllelePlantType)allele).getPlantTypes();
            return types.isEmpty() ? I18N.localise("binniecore.allele.none") : ((EnumPlantType)types.iterator().next()).toString();
        }
        if (chromosome == EnumTreeChromosome.FRUITS && allele.getUID().contains(".")) {
            IFruitProvider provider = ((IAlleleFruit)allele).getProvider();
            return provider.getProducts().length == 0 ? I18N.localise("binniecore.allele.none") : provider.getProducts()[0].func_82833_r();
        }
        if (chromosome == EnumTreeChromosome.GROWTH) {
            if (allele.getUID().contains("Tropical")) {
                return I18N.localise("binniecore.allele.growth.tropical");
            }
            if (allele.getUID().contains("Lightlevel")) {
                return I18N.localise("binniecore.allele.growth.lightlevel");
            }
        }
        return super.getAlleleName(chromosome, allele);
    }

    @Override
    public void onSyncBreedingTracker(IBreedingTracker tracker) {
        this.discoveredFruits.clear();
        this.discoveredWoods.clear();
        for (IAlleleSpecies species : this.getDiscoveredSpecies(tracker)) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ISpeciesRoot speciesRoot = this.getSpeciesRoot();
            ITreeGenome genome = (ITreeGenome)speciesRoot.templateAsGenome(speciesRoot.getTemplate(tSpecies.getUID()));
            FakeWorld world = FakeWorld.instance;
            genome.getPrimary().getGenerator().setLogBlock(genome, (World)world, 0, 0, 0, ForgeDirection.UP);
            ItemStack wood = world.getWooLog();
            if (wood != null) {
                this.discoveredWoods.add(wood);
            }
            this.discoveredFruits.addAll((Collection<? extends ItemStack>)Arrays.asList(genome.getFruitProvider().getProducts()));
            for (ItemStack itemStack : this.discoveredWoods) {
            }
        }
    }

    @Override
    public void calculateArrays() {
        super.calculateArrays();
        for (IAlleleSpecies species : this.allActiveSpecies) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            FakeWorld world = FakeWorld.instance;
            genome.getPrimary().getGenerator().setLogBlock(genome, (World)world, 0, 0, 0, ForgeDirection.UP);
            ItemStack wood = world.getWooLog();
            if (wood != null) {
                this.allWoods.add(wood);
            }
            this.allFruits.addAll((Collection<? extends ItemStack>)Arrays.asList(genome.getFruitProvider().getProducts()));
        }
    }

    public Collection<IAlleleSpecies> getTreesThatBearFruit(ItemStack fruit, boolean nei, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                found.add(species);
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatCanBearFruit(ItemStack fruit, boolean nei, World world, GameProfile player) {
        IAlleleTreeSpecies tSpecies;
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        HashSet<IFruitFamily> providers = new HashSet<IFruitFamily>();
        for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = (ITreeGenome)this.getSpeciesRoot().templateAsGenome(this.getSpeciesRoot().getTemplate(tSpecies.getUID()));
            for (ItemStack fruit2 : genome.getFruitProvider().getProducts()) {
                if (!fruit2.func_77969_a(fruit)) continue;
                providers.add(genome.getFruitProvider().getFamily());
            }
        }
        block2: for (IAlleleSpecies species : set) {
            tSpecies = (IAlleleTreeSpecies)species;
            for (IFruitFamily family : providers) {
                if (!tSpecies.getSuitableFruit().contains(family)) continue;
                found.add(species);
                continue block2;
            }
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatHaveWood(ItemStack fruit, boolean nei, World world, GameProfile player) {
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = TreeManager.treeRoot.templateAsGenome(TreeManager.treeRoot.getTemplate(tSpecies.getUID()));
            tSpecies.getGenerator().setLogBlock(genome, (World)FakeWorld.instance, 0, 0, 0, ForgeDirection.UP);
            ItemStack fruit2 = FakeWorld.instance.getWooLog();
            if (!fruit2.func_77969_a(fruit)) continue;
            found.add(species);
        }
        return found;
    }

    public Collection<IAlleleSpecies> getTreesThatMakePlanks(ItemStack fruit, boolean nei, World world, GameProfile player) {
        if (fruit == null) {
            return new ArrayList<IAlleleSpecies>();
        }
        Collection<IAlleleSpecies> set = nei ? this.getAllSpecies() : this.getDiscoveredSpecies(world, player);
        ArrayList<IAlleleSpecies> found = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : set) {
            IAlleleTreeSpecies tSpecies = (IAlleleTreeSpecies)species;
            ITreeGenome genome = TreeManager.treeRoot.templateAsGenome(TreeManager.treeRoot.getTemplate(tSpecies.getUID()));
            tSpecies.getGenerator().setLogBlock(genome, (World)FakeWorld.instance, 0, 0, 0, ForgeDirection.UP);
            ItemStack fruit2 = FakeWorld.instance.getWooLog();
            if (Lumbermill.getPlankProduct(fruit2) == null || !fruit.func_77969_a(Lumbermill.getPlankProduct(fruit2))) continue;
            found.add(species);
        }
        return found;
    }

    @Override
    public boolean isDNAManipulable(ItemStack member) {
        return ((ITreeRoot)this.getSpeciesRoot()).getType(member) == EnumGermlingType.POLLEN;
    }

    @Override
    public IIndividual getConversion(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        for (Map.Entry entry : AlleleManager.ersatzSaplings.entrySet()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)entry.getKey()))) continue;
            return (IIndividual)entry.getValue();
        }
        return null;
    }

    @Override
    public int[] getActiveTypes() {
        return new int[]{EnumGermlingType.SAPLING.ordinal(), EnumGermlingType.POLLEN.ordinal()};
    }

    @Override
    public void addExtraAlleles(IChromosomeType chromosome, TreeSet<IAllele> alleles) {
        switch ((EnumTreeChromosome)chromosome) {
            case FERTILITY: {
                for (EnumAllele.Saplings saplings : EnumAllele.Saplings.values()) {
                    alleles.add(AlleleManager.alleleRegistry.getAllele(AlleleHelper.getUid(saplings)));
                }
                break;
            }
            case GIRTH: {
                for (ForestryAllele.Int a2 : ForestryAllele.Int.values()) {
                    alleles.add(a2.getAllele());
                }
                break;
            }
            case HEIGHT: {
                for (EnumAllele.Height height : EnumAllele.Height.values()) {
                    alleles.add(AlleleManager.alleleRegistry.getAllele(AlleleHelper.getUid(height)));
                }
                break;
            }
            case MATURATION: {
                for (EnumAllele.Maturation maturation : EnumAllele.Maturation.values()) {
                    alleles.add(AlleleManager.alleleRegistry.getAllele(AlleleHelper.getUid(maturation)));
                }
                break;
            }
            case SAPPINESS: {
                for (EnumAllele.Sappiness sappiness : EnumAllele.Sappiness.values()) {
                    alleles.add(AlleleManager.alleleRegistry.getAllele(AlleleHelper.getUid(sappiness)));
                }
                break;
            }
            case TERRITORY: {
                for (EnumAllele.Territory territory : EnumAllele.Territory.values()) {
                    alleles.add(AlleleManager.alleleRegistry.getAllele(AlleleHelper.getUid(territory)));
                }
                break;
            }
            case YIELD: {
                for (EnumAllele.Yield yield : EnumAllele.Yield.values()) {
                    alleles.add(AlleleManager.alleleRegistry.getAllele(AlleleHelper.getUid(yield)));
                }
                break;
            }
            case FIREPROOF: {
                for (ForestryAllele.Bool bool : ForestryAllele.Bool.values()) {
                    alleles.add(bool.getAllele());
                }
                break;
            }
        }
    }
}

